/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.config;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.axis.AxisEngine;
import org.apache.axis.client.AxisClient;
import org.apache.axis.server.AxisServer;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.config.ConfigException;
import org.globus.ogsa.utils.MessageUtils;
import org.globus.ogsa.utils.XmlFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ContainerConfig {
    private static String configPath = "";
    private Hashtable globalOptions = new Hashtable();
    private Hashtable serviceNodes = new Hashtable();
    private boolean initialized = false;
    private boolean initializeInProcess = false;
    private static ContainerConfig config = new ContainerConfig();
    private Document doc;
    private Hashtable persistentServicesOptions = new Hashtable();
    private List persistentServicesList = new ArrayList();
    private Node serviceParent = null;
    private String ogsiLocation;
    public static final String SCHEMA_ROOT = "schemaRoot";
    public static final String SCHEMA_CONTEXT = "schemaContext";
    public static final String OGSI_LOCATION = "ogsiLocation";
    public static final String CONTAINER_HANDLERS = "containerHandlers";
    public static final String CONTAINER_THREADS = "containerThreads";
    public static final String CONTAINER_THREADS_MAX = "containerThreadsMax";
    public static final String CONTAINER_THREADS_WATERMARK = "containerThreadsHighWaterMark";
    public static final String THREAD_REAP_INTERVAL = "containerThreadsReapInterval";
    public static final String LOGICAL_HOST = "logicalHost";
    public static final String PUBLISH_HOST_NAME = "publishHostName";
    public static final String DOMAIN_NAME = "domainName";
    public static final String DISABLE_DNS = "disableDNS";
    public static final String OGSA_HOST = "ogsaHost";
    public static final String SWEEPER_THREADS = "sweeperThreads";
    public static final String SWEEPER_INTERVAL = "sweeperInterval";
    public static final String QUERY_ENGINE = "queryEngine";
    public static final String QUERY_EVALUATORS = "queryEvaluators";
    public static String SERVER_CONFIG_OPTION = "axis.ServerConfigFile";
    public static String SERVER_CONFIG = "server-config.wsdd";
    public static String CLIENT_CONFIG_OPTION = "axis.ClientConfigFile";
    public static String CLIENT_CONFIG = "client-config.wsdd";
    private static AxisEngine axisEngine = null;
    private static AxisEngine axisClientEngine = null;
    static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$config$ContainerConfig == null ? (class$org$globus$ogsa$config$ContainerConfig = ContainerConfig.class$("org.globus.ogsa.config.ContainerConfig")) : class$org$globus$ogsa$config$ContainerConfig).getName());
    static /* synthetic */ Class class$org$globus$ogsa$config$ContainerConfig;

    protected ContainerConfig() {
    }

    public synchronized AxisEngine getEngine() throws ConfigException {
        try {
            if (axisEngine == null) {
                axisEngine = new AxisServer();
            }
        }
        catch (Exception e) {
            throw new ConfigException(MessageUtils.getMessage("configError", new String[]{configPath}), e);
        }
        return axisEngine;
    }

    public synchronized AxisEngine getClientEngine() throws ConfigException {
        try {
            if (axisClientEngine == null) {
                axisClientEngine = new AxisClient();
            }
        }
        catch (Exception e) {
            throw new ConfigException(MessageUtils.getMessage("configError", new String[]{configPath}), e);
        }
        return axisClientEngine;
    }

    public static ContainerConfig getConfig() throws ConfigException {
        config.initialize();
        return config;
    }

    public static String getPath() {
        return config.getConfigPath();
    }

    public synchronized void saveService(Element serviceElement) throws ConfigException {
        String serviceName = serviceElement.getAttribute("name");
        Node serviceNode = (Node)this.serviceNodes.get(serviceName);
        if (serviceNode != null) {
            this.serviceParent.removeChild(serviceNode);
        }
        Node importedNode = this.doc.importNode(serviceElement, true);
        this.serviceParent.appendChild(importedNode);
        this.serviceNodes.put(serviceName, importedNode);
        this.saveConfig();
    }

    public synchronized void removeService(String servicePath) throws ConfigException {
        Node node = (Node)this.serviceNodes.get(servicePath);
        if (node == null) {
            return;
        }
        this.serviceParent.removeChild(node);
        this.saveConfig();
    }

    private void saveConfig() throws ConfigException {
        OutputStreamWriter output = null;
        try {
            String cfg = XMLUtils.DocumentToString((Document)this.doc);
            output = new FileWriter(configPath + SERVER_CONFIG);
            output.write(cfg);
            output.flush();
        }
        catch (Exception e) {
            throw new ConfigException(e);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (Exception e) {
                    logger.error((Object)MessageUtils.toString(e));
                }
            }
        }
    }

    public String getOption(String name) {
        return (String)this.globalOptions.get(name);
    }

    public String setOption(String name, String value) {
        return this.globalOptions.put(name, value);
    }

    public static void initConfigPath(String configPath) {
        logger.debug((Object)("Setting ConfigPath to " + configPath));
        if (configPath != null) {
            ContainerConfig.configPath = configPath;
        }
    }

    public String getConfigPath() {
        return configPath;
    }

    protected synchronized void initialize() throws ConfigException {
        String clientConfig;
        if (this.initialized || this.initializeInProcess) {
            return;
        }
        String serverConfig = System.getProperty(SERVER_CONFIG_OPTION);
        if (serverConfig != null) {
            SERVER_CONFIG = serverConfig;
        }
        if ((clientConfig = System.getProperty(CLIENT_CONFIG_OPTION)) != null) {
            CLIENT_CONFIG = clientConfig;
        }
        try {
            this.initializeInProcess = true;
            this.initializeConfigDocument();
            this.initializeGlobalConfig();
            this.initializePersistentServicesConfig();
            this.initialized = true;
            this.initializeInProcess = false;
        }
        catch (Exception e) {
            this.initializeInProcess = false;
            throw new ConfigException(e);
        }
    }

    private void initializeGlobalConfig() throws Exception {
        NodeList configNodes = this.doc.getElementsByTagNameNS("http://xml.apache.org/axis/wsdd/", "globalConfiguration");
        if (configNodes.getLength() == 1) {
            NodeList parameterNodes = ((Element)configNodes.item(0)).getElementsByTagNameNS("http://xml.apache.org/axis/wsdd/", "parameter");
            int parameterNode = 0;
            while (parameterNode < parameterNodes.getLength()) {
                Element node = (Element)parameterNodes.item(parameterNode);
                String name = node.getAttribute("name");
                String value = node.getAttribute("value");
                this.globalOptions.put(name, value);
                ++parameterNode;
            }
        }
    }

    public String getConfigFile() {
        return configPath + SERVER_CONFIG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeConfigDocument() throws ConfigException {
        if (this.doc != null) {
            return;
        }
        InputStream input = null;
        try {
            try {
                logger.debug((Object)("trying to load file: " + configPath + SERVER_CONFIG));
                input = new FileInputStream(configPath + SERVER_CONFIG);
                logger.debug((Object)("loading service configuration from file: " + configPath + SERVER_CONFIG));
            }
            catch (FileNotFoundException fnf) {
                input = (class$org$globus$ogsa$config$ContainerConfig == null ? (class$org$globus$ogsa$config$ContainerConfig = ContainerConfig.class$("org.globus.ogsa.config.ContainerConfig")) : class$org$globus$ogsa$config$ContainerConfig).getClassLoader().getResourceAsStream(SERVER_CONFIG);
                logger.debug((Object)("loading service configuration from resource stream: " + SERVER_CONFIG));
            }
            if (input == null) {
                throw new ConfigException(MessageUtils.getMessage("configFileError", new String[]{SERVER_CONFIG}));
            }
            try {
                this.doc = XmlFactory.newDocument(input);
            }
            catch (GridServiceException e) {
                throw new ConfigException(e);
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception e) {
                    throw new ConfigException(e);
                }
            }
        }
    }

    public Hashtable getPersistentServicesOptions() {
        return this.persistentServicesOptions;
    }

    public List getPersistentServicesList() {
        return this.persistentServicesList;
    }

    private void initializePersistentServicesConfig() throws Exception {
        this.serviceParent = null;
        NodeList serviceNodes = this.doc.getElementsByTagNameNS("http://xml.apache.org/axis/wsdd/", "service");
        int serviceNode = 0;
        while (serviceNode < serviceNodes.getLength()) {
            if (this.serviceParent == null) {
                this.serviceParent = serviceNodes.item(serviceNode).getParentNode();
            }
            Hashtable<String, String> serviceOptions = new Hashtable<String, String>();
            boolean persistentService = false;
            Element serviceElement = (Element)serviceNodes.item(serviceNode);
            String serviceName = serviceElement.getAttribute("name");
            this.serviceNodes.put(serviceName, serviceElement);
            serviceOptions.put("servicePath", serviceName);
            NodeList parameterNodes = ((Element)serviceNodes.item(serviceNode)).getElementsByTagNameNS("http://xml.apache.org/axis/wsdd/", "parameter");
            int parameterNode = 0;
            while (parameterNode < parameterNodes.getLength()) {
                Element node = (Element)parameterNodes.item(parameterNode);
                String name = node.getAttribute("name");
                String value = node.getAttribute("value");
                serviceOptions.put(name, value);
                if (name != null && name.equals("persistent") && value != null && value.toUpperCase().equals("TRUE")) {
                    persistentService = true;
                }
                ++parameterNode;
            }
            if (persistentService) {
                this.persistentServicesOptions.put(serviceName, serviceOptions);
                this.persistentServicesList.add(serviceName);
            }
            ++serviceNode;
        }
    }

    public static String getOgsiLocation() {
        try {
            return ContainerConfig.getConfig().getLocalOgsiLocation();
        }
        catch (Exception e) {
            logger.error((Object)MessageUtils.getMessage("OGSIC010"));
            return "ogsa/services/";
        }
    }

    public synchronized String getLocalOgsiLocation() {
        if (this.ogsiLocation != null) {
            return this.ogsiLocation;
        }
        this.ogsiLocation = this.getOption(OGSI_LOCATION);
        if (this.ogsiLocation == null) {
            this.ogsiLocation = "ogsa/services/";
        }
        return this.ogsiLocation;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

