/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.core.handle;

import java.net.URL;
import javax.xml.rpc.Stub;
import org.apache.axis.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.ServiceProperties;
import org.globus.ogsa.config.ContainerConfig;
import org.globus.ogsa.server.ServiceHost;
import org.globus.ogsa.utils.FaultHelper;
import org.globus.ogsa.utils.GSIUtils;
import org.globus.ogsa.utils.MessageUtils;
import org.globus.ogsa.wsdl.GSR;
import org.gridforum.ogsi.FaultType;
import org.gridforum.ogsi.HandleResolver;
import org.gridforum.ogsi.HandleType;
import org.gridforum.ogsi.InvalidHandleFaultType;
import org.gridforum.ogsi.LocatorType;
import org.gridforum.ogsi.OGSIServiceLocator;

public class HandleHelper {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$impl$core$handle$HandleHelper == null ? (class$org$globus$ogsa$impl$core$handle$HandleHelper = HandleHelper.class$("org.globus.ogsa.impl.core.handle.HandleHelper")) : class$org$globus$ogsa$impl$core$handle$HandleHelper).getName());
    public static final String HANDLE_RESOLVER = "handleResolver";
    private static OGSIServiceLocator serviceLocator = new OGSIServiceLocator();
    static /* synthetic */ Class class$org$globus$ogsa$impl$core$handle$HandleHelper;
    static /* synthetic */ Class class$org$gridforum$ogsi$InvalidHandleFaultType;

    public static String getInstanceID(HandleType handle) throws InvalidHandleFaultType {
        return HandleHelper.getInstanceID(handle.toString());
    }

    public static String getServicePath(HandleType handle) throws InvalidHandleFaultType {
        return HandleHelper.getServicePath(handle.toString());
    }

    public static String getServicePath(String handle) throws InvalidHandleFaultType {
        int serviceIndex = HandleHelper.getServiceIndex(handle);
        return handle.substring(serviceIndex, handle.length());
    }

    public static String getInstanceID(String handle) throws InvalidHandleFaultType {
        int instanceIndex = HandleHelper.getInstanceIndex(handle);
        return handle.substring(instanceIndex, handle.length());
    }

    public static String getParentID(HandleType handle) throws InvalidHandleFaultType {
        return HandleHelper.getParentID(handle.toString());
    }

    public static HandleType getResolverHandle(HandleType handle) throws InvalidHandleFaultType {
        return HandleHelper.getResolverHandle(handle.toString());
    }

    public static HandleType getResolverHandle(String handle) throws InvalidHandleFaultType {
        return new HandleType(HandleHelper.getParentID(handle) + "/" + HANDLE_RESOLVER);
    }

    public static URL getResolverHandle(URL handle) throws InvalidHandleFaultType {
        URL url = null;
        try {
            url = new URL(HandleHelper.getResolverHandle(handle.toString()).toString());
        }
        catch (Exception e) {
            logger.error((Object)MessageUtils.toString(e));
            throw (InvalidHandleFaultType)FaultHelper.makeFault(class$org$gridforum$ogsi$InvalidHandleFaultType == null ? (class$org$gridforum$ogsi$InvalidHandleFaultType = HandleHelper.class$("org.gridforum.ogsi.InvalidHandleFaultType")) : class$org$gridforum$ogsi$InvalidHandleFaultType, "" + handle);
        }
        return url;
    }

    public static String getParentID(String handle) throws InvalidHandleFaultType {
        int instanceIndex = HandleHelper.getInstanceIndex(handle);
        return handle.substring(0, instanceIndex);
    }

    public static GSR getGSR(HandleType handle) throws FaultType {
        try {
            HandleType resolverHandle = HandleHelper.getResolverHandle(handle);
            HandleResolver resolver = serviceLocator.getHandleResolverPort(new URL(resolverHandle.toString()));
            GSIUtils.setDefaultGSIProperties((Stub)resolver);
            LocatorType handleSet = new LocatorType();
            handleSet.setHandle(new HandleType[]{handle});
            LocatorType locator = resolver.findByHandle(handleSet, new LocatorType());
            GSR gsr = GSR.newInstance(locator);
            return gsr;
        }
        catch (FaultType fault) {
            throw fault;
        }
        catch (Exception e) {
            logger.error((Object)MessageUtils.toString(e));
            throw FaultHelper.makeFault(class$org$gridforum$ogsi$InvalidHandleFaultType == null ? (class$org$gridforum$ogsi$InvalidHandleFaultType = HandleHelper.class$("org.gridforum.ogsi.InvalidHandleFaultType")) : class$org$gridforum$ogsi$InvalidHandleFaultType, "" + handle);
        }
    }

    private static int getInstanceIndex(String handle) throws InvalidHandleFaultType {
        if (handle == null) {
            throw (InvalidHandleFaultType)FaultHelper.makeFault(class$org$gridforum$ogsi$InvalidHandleFaultType == null ? (class$org$gridforum$ogsi$InvalidHandleFaultType = HandleHelper.class$("org.gridforum.ogsi.InvalidHandleFaultType")) : class$org$gridforum$ogsi$InvalidHandleFaultType, MessageUtils.getMessage("handleNullError"));
        }
        int instanceIndex = handle.lastIndexOf("/");
        if (instanceIndex == -1) {
            throw (InvalidHandleFaultType)FaultHelper.makeFault(class$org$gridforum$ogsi$InvalidHandleFaultType == null ? (class$org$gridforum$ogsi$InvalidHandleFaultType = HandleHelper.class$("org.gridforum.ogsi.InvalidHandleFaultType")) : class$org$gridforum$ogsi$InvalidHandleFaultType, MessageUtils.getMessage("handleMissingSlashError", new String[]{"" + handle}));
        }
        return instanceIndex + 1;
    }

    private static int getServiceIndex(String handle) throws InvalidHandleFaultType {
        if (handle == null) {
            throw (InvalidHandleFaultType)FaultHelper.makeFault(class$org$gridforum$ogsi$InvalidHandleFaultType == null ? (class$org$gridforum$ogsi$InvalidHandleFaultType = HandleHelper.class$("org.gridforum.ogsi.InvalidHandleFaultType")) : class$org$gridforum$ogsi$InvalidHandleFaultType, MessageUtils.getMessage("handleNullError"));
        }
        int serviceIndex = handle.indexOf(ContainerConfig.getOgsiLocation());
        if (serviceIndex == -1) {
            throw (InvalidHandleFaultType)FaultHelper.makeFault(class$org$gridforum$ogsi$InvalidHandleFaultType == null ? (class$org$gridforum$ogsi$InvalidHandleFaultType = HandleHelper.class$("org.gridforum.ogsi.InvalidHandleFaultType")) : class$org$gridforum$ogsi$InvalidHandleFaultType, MessageUtils.getMessage("handleMissingPathError", new String[]{ContainerConfig.getOgsiLocation(), handle}));
        }
        return serviceIndex + ContainerConfig.getOgsiLocation().length();
    }

    public static String getHandle(String servicePath, ServiceProperties properties) throws GridServiceException {
        ContainerConfig config;
        String handleProtocol = (String)properties.getProperty("handleProtocol");
        String handlePort = null;
        if (handleProtocol != null) {
            handlePort = (String)properties.getProperty("handlePort");
        } else {
            handleProtocol = (String)properties.getProperty("protocol");
            if (handleProtocol == null) {
                handleProtocol = "http";
            } else {
                handlePort = (String)properties.getProperty("port");
            }
        }
        if (handlePort == null && (handlePort = (config = ContainerConfig.getConfig()).getOption(handleProtocol + "Port")) == null) {
            throw new GridServiceException(MessageUtils.getMessage("noPortConfig", new String[]{handleProtocol}));
        }
        return handleProtocol + "://" + ServiceHost.getHost() + ":" + handlePort + servicePath;
    }

    public static String getHandleURL(HandleType handle) {
        if (handle == null) {
            return null;
        }
        return handle.toString() + "?WSDL";
    }

    public static boolean isLocal(HandleType handle) {
        try {
            URL url = new URL(handle.toString());
            if (!ServiceHost.getHost().equals(url.getHost())) {
                return false;
            }
            MessageContext context = MessageContext.getCurrentContext();
            if (context == null) {
                return false;
            }
            String transport = (String)context.getProperty("transport.url");
            URL transportURL = new URL(transport);
            if (transportURL.getPort() != url.getPort()) {
                return false;
            }
        }
        catch (Exception e) {
            logger.error((Object)MessageUtils.toString(e));
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

