/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.core.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.axis.message.MessageElement;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xpath.XPathAPI;
import org.globus.ogsa.GridConstants;
import org.globus.ogsa.ServiceData;
import org.globus.ogsa.ServiceDataSet;
import org.globus.ogsa.impl.core.service.ServiceDataNameEvaluator;
import org.globus.ogsa.types.query.ServiceDataXPathQueryExpressionType;
import org.globus.ogsa.types.subscription.ServiceDataXPathSubscriptionExpressionType;
import org.globus.ogsa.utils.AnyHelper;
import org.globus.ogsa.utils.FaultHelper;
import org.globus.ogsa.utils.MessageUtils;
import org.gridforum.ogsi.ExtensibilityType;
import org.gridforum.ogsi.ExtensibilityTypeFaultType;
import org.gridforum.ogsi.FaultType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceDataXPathEvaluator
extends ServiceDataNameEvaluator {
    static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$impl$core$service$ServiceDataXPathEvaluator == null ? (class$org$globus$ogsa$impl$core$service$ServiceDataXPathEvaluator = ServiceDataXPathEvaluator.class$("org.globus.ogsa.impl.core.service.ServiceDataXPathEvaluator")) : class$org$globus$ogsa$impl$core$service$ServiceDataXPathEvaluator).getName());
    private boolean isDebug = logger.isDebugEnabled();
    private static QName[] expressionNames = null;
    private static HashMap expressionRegistry = null;
    static /* synthetic */ Class class$org$globus$ogsa$impl$core$service$ServiceDataXPathEvaluator;
    static /* synthetic */ Class class$org$globus$ogsa$types$query$ServiceDataXPathQueryExpressionType;
    static /* synthetic */ Class class$org$globus$ogsa$types$subscription$ServiceDataXPathSubscriptionExpressionType;
    static /* synthetic */ Class class$org$gridforum$ogsi$ExtensibilityTypeFaultType;
    static /* synthetic */ Class class$org$gridforum$ogsi$TargetInvalidFaultType;

    public ServiceDataXPathEvaluator() {
        if (expressionRegistry == null) {
            expressionRegistry = new HashMap();
            expressionRegistry.put(GridConstants.QUERY_BY_XPATH, class$org$globus$ogsa$types$query$ServiceDataXPathQueryExpressionType == null ? (class$org$globus$ogsa$types$query$ServiceDataXPathQueryExpressionType = ServiceDataXPathEvaluator.class$("org.globus.ogsa.types.query.ServiceDataXPathQueryExpressionType")) : class$org$globus$ogsa$types$query$ServiceDataXPathQueryExpressionType);
            expressionRegistry.put(GridConstants.SUBSCRIBE_BY_XPATH, class$org$globus$ogsa$types$subscription$ServiceDataXPathSubscriptionExpressionType == null ? (class$org$globus$ogsa$types$subscription$ServiceDataXPathSubscriptionExpressionType = ServiceDataXPathEvaluator.class$("org.globus.ogsa.types.subscription.ServiceDataXPathSubscriptionExpressionType")) : class$org$globus$ogsa$types$subscription$ServiceDataXPathSubscriptionExpressionType);
        }
    }

    public QName[] getExpressionNames() {
        if (expressionNames == null) {
            ArrayList exprNames = new ArrayList();
            exprNames.addAll(expressionRegistry.keySet());
            expressionNames = exprNames.toArray(new QName[exprNames.size()]);
        }
        return expressionNames;
    }

    public Object evaluate(ExtensibilityType extensibility, ServiceDataSet serviceDataSet) throws FaultType {
        String[] namespaces;
        QName qname = null;
        String xpath = null;
        Node namespaceNode = null;
        ServiceDataXPathQueryExpressionType queryExpression = null;
        ServiceDataXPathSubscriptionExpressionType subscriptionExpression = null;
        try {
            if (AnyHelper.contains(extensibility, class$org$globus$ogsa$types$query$ServiceDataXPathQueryExpressionType == null ? (class$org$globus$ogsa$types$query$ServiceDataXPathQueryExpressionType = ServiceDataXPathEvaluator.class$("org.globus.ogsa.types.query.ServiceDataXPathQueryExpressionType")) : class$org$globus$ogsa$types$query$ServiceDataXPathQueryExpressionType)) {
                queryExpression = (ServiceDataXPathQueryExpressionType)AnyHelper.getAsSingleObject(extensibility, class$org$globus$ogsa$types$query$ServiceDataXPathQueryExpressionType == null ? (class$org$globus$ogsa$types$query$ServiceDataXPathQueryExpressionType = ServiceDataXPathEvaluator.class$("org.globus.ogsa.types.query.ServiceDataXPathQueryExpressionType")) : class$org$globus$ogsa$types$query$ServiceDataXPathQueryExpressionType);
            } else if (AnyHelper.contains(extensibility, class$org$globus$ogsa$types$subscription$ServiceDataXPathSubscriptionExpressionType == null ? (class$org$globus$ogsa$types$subscription$ServiceDataXPathSubscriptionExpressionType = ServiceDataXPathEvaluator.class$("org.globus.ogsa.types.subscription.ServiceDataXPathSubscriptionExpressionType")) : class$org$globus$ogsa$types$subscription$ServiceDataXPathSubscriptionExpressionType)) {
                subscriptionExpression = (ServiceDataXPathSubscriptionExpressionType)AnyHelper.getAsSingleObject(extensibility, class$org$globus$ogsa$types$subscription$ServiceDataXPathSubscriptionExpressionType == null ? (class$org$globus$ogsa$types$subscription$ServiceDataXPathSubscriptionExpressionType = ServiceDataXPathEvaluator.class$("org.globus.ogsa.types.subscription.ServiceDataXPathSubscriptionExpressionType")) : class$org$globus$ogsa$types$subscription$ServiceDataXPathSubscriptionExpressionType);
            }
        }
        catch (Exception e) {
            logger.error((Object)MessageUtils.toString(e));
            throw FaultHelper.makeFault(class$org$gridforum$ogsi$ExtensibilityTypeFaultType == null ? (class$org$gridforum$ogsi$ExtensibilityTypeFaultType = ServiceDataXPathEvaluator.class$("org.gridforum.ogsi.ExtensibilityTypeFaultType")) : class$org$gridforum$ogsi$ExtensibilityTypeFaultType, e);
        }
        if (queryExpression != null) {
            qname = queryExpression.getName();
            xpath = queryExpression.getXpath();
            namespaces = queryExpression.getNamespaces();
            namespaceNode = this.createNamespaceContext(namespaces);
        } else if (subscriptionExpression != null) {
            qname = subscriptionExpression.getName();
            xpath = subscriptionExpression.getXpath();
            namespaces = subscriptionExpression.getNamespaces();
            namespaceNode = this.createNamespaceContext(namespaces);
        } else {
            throw new ExtensibilityTypeFaultType();
        }
        Object result = this.evaluate(qname, xpath, namespaceNode, serviceDataSet);
        ExtensibilityType extensibilityResult = new ExtensibilityType();
        try {
            if (result instanceof Object[] && ((Object[])result).length > 0) {
                extensibilityResult.set_any(AnyHelper.toAny((Object[])result));
            }
        }
        catch (Exception e) {
            throw FaultHelper.makeFault(MessageUtils.getMessage("xpathFormattingReturnError"), e);
        }
        return extensibilityResult;
    }

    private Object evaluate(QName serviceDataName, String XPathExpr, Node namespaceNode, ServiceDataSet serviceDataSet) throws FaultType {
        try {
            if (serviceDataName.getLocalPart().equals("*")) {
                return this.getServiceDataSet(serviceDataName.getNamespaceURI(), XPathExpr, namespaceNode, serviceDataSet);
            }
            ServiceData serviceData = null;
            serviceData = serviceDataSet.get(serviceDataName);
            if (serviceData != null) {
                return this.evaluateXPath(serviceData, XPathExpr, namespaceNode).toArray();
            }
            if (serviceDataName.getNamespaceURI().equals("")) {
                String localName = serviceDataName.getLocalPart();
                Iterator iterator = serviceDataSet.iterator();
                while (iterator.hasNext()) {
                    ServiceData localElement = (ServiceData)iterator.next();
                    QName name = localElement.getName();
                    if (name == null || !name.getLocalPart().equals(localName)) continue;
                    serviceData = localElement;
                    break;
                }
            }
            if (serviceData != null) {
                return this.evaluateXPath(serviceData, XPathExpr, namespaceNode).toArray();
            }
            throw FaultHelper.makeFault(class$org$gridforum$ogsi$TargetInvalidFaultType == null ? (class$org$gridforum$ogsi$TargetInvalidFaultType = ServiceDataXPathEvaluator.class$("org.gridforum.ogsi.TargetInvalidFaultType")) : class$org$gridforum$ogsi$TargetInvalidFaultType, serviceDataName.toString());
        }
        catch (Exception e) {
            logger.error((Object)MessageUtils.toString(e));
            throw FaultHelper.makeFault(class$org$gridforum$ogsi$ExtensibilityTypeFaultType == null ? (class$org$gridforum$ogsi$ExtensibilityTypeFaultType = ServiceDataXPathEvaluator.class$("org.gridforum.ogsi.ExtensibilityTypeFaultType")) : class$org$gridforum$ogsi$ExtensibilityTypeFaultType, e);
        }
    }

    private Object getServiceDataSet(String namespaceURI, String XPathExpr, Node namespaceNode, ServiceDataSet serviceDataSet) throws Exception {
        ArrayList results = new ArrayList();
        Iterator iterator = serviceDataSet.iterator();
        while (iterator.hasNext()) {
            ServiceData serviceData = (ServiceData)iterator.next();
            if (namespaceURI == null || namespaceURI.equals("") || namespaceURI.equals("*")) {
                results.addAll(this.evaluateXPath(serviceData, XPathExpr, namespaceNode));
                continue;
            }
            String serviceDataNS = serviceData.getName().getNamespaceURI();
            if (serviceDataNS == null || !serviceDataNS.equals(namespaceURI)) continue;
            results.addAll(this.evaluateXPath(serviceData, XPathExpr, namespaceNode));
        }
        return results.toArray();
    }

    private Node createNamespaceContext(String[] namespaceMappings) {
        if (namespaceMappings == null || namespaceMappings.length == 0) {
            return null;
        }
        DocumentImpl doc = new DocumentImpl();
        Element namespaceElement = doc.createElement("NamespaceMappings");
        int i = 0;
        while (i < namespaceMappings.length) {
            if (namespaceMappings[i] != null && namespaceMappings[i].length() != 0) {
                StringTokenizer toker = new StringTokenizer(namespaceMappings[i], "=");
                if (toker.countTokens() % 2 != 0) {
                    logger.warn((Object)"Token mismatch in Namespace mapping string");
                } else {
                    String prefix = toker.nextToken();
                    String uri = toker.nextToken();
                    namespaceElement.setAttribute(prefix, uri);
                }
            }
            ++i;
        }
        doc.appendChild(namespaceElement);
        return doc.getDocumentElement();
    }

    private ArrayList evaluateXPath(ServiceData serviceData, String XPathExpr, Node namespaceNode) throws Exception {
        NodeList results = null;
        ArrayList<Element> resultList = new ArrayList<Element>();
        try {
            Element[] dataElements = serviceData.externalizeElement();
            if (dataElements.length < 1) {
                return resultList;
            }
            int dataElementPos = 0;
            while (dataElementPos < dataElements.length) {
                Element dataElement = dataElements[dataElementPos];
                if (this.isDebug) {
                    logger.debug((Object)("Applying XPath expression " + XPathExpr + " to " + serviceData.getName().toString() + " using the following namespace mappings: " + XMLUtils.DocumentToString((Document)namespaceNode.getOwnerDocument())));
                }
                try {
                    results = XPathAPI.selectNodeList((Node)dataElement, (String)XPathExpr, (Node)(namespaceNode != null ? namespaceNode : dataElement));
                }
                catch (Exception e) {
                    logger.error((Object)MessageUtils.getMessage("xpathEvaluationException", new String[]{"" + XPathExpr}), (Throwable)e);
                    throw e;
                }
                int i = 0;
                while (i < results.getLength()) {
                    if (results.item(i).getNodeType() != 1) {
                        logger.warn((Object)MessageUtils.getMessage("unsupportedXpathReturn"));
                    } else {
                        if (this.isDebug) {
                            logger.debug((Object)("XPath Query Result: " + XMLUtils.ElementToString((Element)((Element)results.item(i)))));
                        }
                        resultList.add((Element)results.item(i));
                    }
                    ++i;
                }
                ++dataElementPos;
            }
            return resultList;
        }
        catch (Exception e) {
            throw FaultHelper.makeFault(class$org$gridforum$ogsi$ExtensibilityTypeFaultType == null ? (class$org$gridforum$ogsi$ExtensibilityTypeFaultType = ServiceDataXPathEvaluator.class$("org.gridforum.ogsi.ExtensibilityTypeFaultType")) : class$org$gridforum$ogsi$ExtensibilityTypeFaultType, "Exception in ServiceDataXPathEvaluator.evaluateXPath", e);
        }
    }

    public QName[] getSDNames(ExtensibilityType extensibility) throws FaultType {
        QName qname = null;
        Object xpath = null;
        Object namespaceNode = null;
        Object expression = null;
        try {
            MessageElement[] me = extensibility.get_any();
            QName exprQName = me[0].getQName();
            Object exprObj = AnyHelper.getAsSingleObject(extensibility, (Class)expressionRegistry.get(exprQName));
            if (exprObj instanceof ServiceDataXPathQueryExpressionType) {
                qname = ((ServiceDataXPathQueryExpressionType)exprObj).getName();
            } else if (exprObj instanceof ServiceDataXPathSubscriptionExpressionType) {
                qname = ((ServiceDataXPathSubscriptionExpressionType)exprObj).getName();
            }
        }
        catch (Exception e) {
            logger.error((Object)MessageUtils.toString(e));
            throw FaultHelper.makeFault(class$org$gridforum$ogsi$ExtensibilityTypeFaultType == null ? (class$org$gridforum$ogsi$ExtensibilityTypeFaultType = ServiceDataXPathEvaluator.class$("org.gridforum.ogsi.ExtensibilityTypeFaultType")) : class$org$gridforum$ogsi$ExtensibilityTypeFaultType, e);
        }
        if (qname != null) {
            return new QName[]{qname};
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

