/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.core.service;

import java.lang.reflect.Constructor;
import java.net.URL;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.MessageContext;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.client.Service;
import org.apache.axis.configuration.SimpleProvider;
import org.apache.axis.transport.http.HTTPSender;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.axis.transport.GSIHTTPSender;
import org.globus.axis.util.Util;
import org.globus.ogsa.GridLocator;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.impl.core.handle.HandleHelper;
import org.globus.ogsa.repository.ServiceNode;
import org.globus.ogsa.utils.MessageUtils;
import org.globus.ogsa.wsdl.GSR;
import org.gridforum.ogsi.FaultType;
import org.gridforum.ogsi.HandleType;
import org.gridforum.ogsi.LocatorType;

public class ServiceLocator
extends Service
implements GridLocator {
    private GSR cachedGSR = null;
    private URL cachedEndpoint = null;
    private boolean enableCacheGSR = false;
    MessageContext context = null;
    static Log locatorLogger = LogFactory.getLog((String)(class$org$globus$ogsa$impl$core$service$ServiceLocator == null ? (class$org$globus$ogsa$impl$core$service$ServiceLocator = ServiceLocator.class$("org.globus.ogsa.impl.core.service.ServiceLocator")) : class$org$globus$ogsa$impl$core$service$ServiceLocator).getName());
    Class stubClass = null;
    static /* synthetic */ Class class$org$globus$ogsa$impl$core$service$ServiceLocator;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$javax$xml$rpc$Service;

    public ServiceLocator() {
        this.context = MessageContext.getCurrentContext();
        locatorLogger.debug((Object)("Setting context to: " + this.context));
    }

    public void setEnableCacheGSR(boolean enableCacheGSR) {
        this.enableCacheGSR = enableCacheGSR;
    }

    public ServiceLocator(EngineConfiguration config) {
        super(config);
        if (!(config instanceof SimpleProvider)) {
            throw new RuntimeException(MessageUtils.getMessage("invalidConfig"));
        }
        SimpleTargetedChain c = null;
        c = new SimpleTargetedChain((Handler)new GSIHTTPSender());
        ((SimpleProvider)config).deployTransport("httpg", (Handler)c);
        c = new SimpleTargetedChain((Handler)new HTTPSender());
        ((SimpleProvider)config).deployTransport("http", (Handler)c);
    }

    public Object getServicePort(URL endpointAddress) throws GridServiceException {
        if (this.stubClass == null) {
            return null;
        }
        try {
            Constructor constructor = this.stubClass.getConstructor(class$java$net$URL == null ? (class$java$net$URL = ServiceLocator.class$("java.net.URL")) : class$java$net$URL, class$javax$xml$rpc$Service == null ? (class$javax$xml$rpc$Service = ServiceLocator.class$("javax.xml.rpc.Service")) : class$javax$xml$rpc$Service);
            return constructor.newInstance(endpointAddress, this);
        }
        catch (Exception e) {
            throw new GridServiceException(e);
        }
    }

    public Object getServicePort(HandleType handle) throws FaultType, GridServiceException {
        if (!this.enableCacheGSR || this.cachedGSR == null) {
            try {
                URL endpointAddress;
                GSR gsr;
                this.cachedGSR = gsr = HandleHelper.getGSR(handle);
                String endpoint = gsr.getEndpoint();
                this.cachedEndpoint = endpointAddress = new URL(endpoint);
            }
            catch (FaultType fault) {
                throw fault;
            }
            catch (Exception e) {
                throw new GridServiceException(e);
            }
        }
        return this.getServicePort(this.cachedEndpoint);
    }

    public Object getLocal(HandleType targetService) throws GridServiceException {
        String path = null;
        try {
            path = HandleHelper.getServicePath(targetService);
        }
        catch (Exception e) {
            throw new GridServiceException(e);
        }
        locatorLogger.debug((Object)("Using context: " + this.context));
        return ServiceNode.getRootNode().activate(path, this.context);
    }

    public Object getLocal(String path) throws GridServiceException {
        return ServiceNode.getRootNode().activate(path, this.context);
    }

    public Object getServicePort(LocatorType locator) throws FaultType, GridServiceException {
        if (!this.enableCacheGSR || this.cachedGSR == null) {
            try {
                URL endpointAddress;
                GSR gsr;
                this.cachedGSR = gsr = GSR.newInstance(locator);
                String endpoint = gsr.getEndpoint();
                this.cachedEndpoint = endpointAddress = new URL(endpoint);
            }
            catch (FaultType fault) {
                throw fault;
            }
            catch (Exception e) {
                throw new GridServiceException(e);
            }
        }
        return this.getServicePort(this.cachedEndpoint);
    }

    public URL getEndpoint() {
        return this.cachedEndpoint;
    }

    public GSR getGSR() {
        return this.cachedGSR;
    }

    public void setStubClass(Class stubClass) {
        this.stubClass = stubClass;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Util.registerTransport();
    }
}

