/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.ogsi;

import java.rmi.RemoteException;
import javax.xml.namespace.QName;
import org.apache.axis.MessageContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.types.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.GridServiceBase;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.LazyCreationCallback;
import org.globus.ogsa.OperationProvider;
import org.globus.ogsa.ServiceData;
import org.globus.ogsa.ServiceDataSet;
import org.globus.ogsa.ServiceProperties;
import org.globus.ogsa.WSDLGenerator;
import org.globus.ogsa.config.ContainerConfig;
import org.globus.ogsa.impl.core.handle.HandleHelper;
import org.globus.ogsa.repository.ServiceLoader;
import org.globus.ogsa.repository.ServiceNode;
import org.globus.ogsa.router.RedirectException;
import org.globus.ogsa.router.RedirectProvider;
import org.globus.ogsa.utils.FaultHelper;
import org.globus.ogsa.utils.MessageUtils;
import org.gridforum.ogsi.FaultType;
import org.gridforum.ogsi.InvalidHandleFaultType;
import org.gridforum.ogsi.LocatorType;
import org.gridforum.ogsi.NoAdditionalReferencesAvailableFaultType;
import org.gridforum.ogsi.NoReferencesAvailableFaultType;
import org.gridforum.ogsi.NoSuchServiceFaultType;
import org.gridforum.ogsi.NoSuchServiceStartedFaultType;
import org.gridforum.ogsi.RedirectionFaultType;
import org.gridforum.ogsi.ReferenceType;
import org.gridforum.ogsi.ServiceHasTerminatedFaultType;
import org.gridforum.ogsi.TemporarilyUnavailableFaultType;
import org.gridforum.ogsi.WSDLReferenceType;
import org.w3c.dom.Document;

public class HandleResolverProvider
implements OperationProvider {
    private static final QName[] operations = new QName[]{new QName("http://www.gridforum.org/namespaces/2003/03/OGSI", "findByHandle")};
    private static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$impl$ogsi$HandleResolverProvider == null ? (class$org$globus$ogsa$impl$ogsi$HandleResolverProvider = HandleResolverProvider.class$("org.globus.ogsa.impl.ogsi.HandleResolverProvider")) : class$org$globus$ogsa$impl$ogsi$HandleResolverProvider).getName());
    private GridServiceBase serviceBase;
    static /* synthetic */ Class class$org$globus$ogsa$impl$ogsi$HandleResolverProvider;
    static /* synthetic */ Class class$org$gridforum$ogsi$NoSuchServiceFaultType;

    public QName[] getOperations() {
        return operations;
    }

    public void initialize(GridServiceBase serviceBase) throws GridServiceException {
        this.serviceBase = serviceBase;
        ServiceDataSet serviceDataSet = serviceBase.getServiceDataSet();
        ServiceData resolverData = serviceDataSet.create(ServiceData.HANDLE_RESOLVER_SCHEME);
        try {
            resolverData.addValue(new URI("http://"));
            resolverData.addValue(new URI("https://"));
        }
        catch (Exception e) {
            throw new GridServiceException(e);
        }
        serviceDataSet.add(resolverData);
    }

    public LocatorType findByHandle(LocatorType handleSet, LocatorType gsrExclusionSet) throws RemoteException, RedirectionFaultType, ServiceHasTerminatedFaultType, InvalidHandleFaultType, NoAdditionalReferencesAvailableFaultType, FaultType, TemporarilyUnavailableFaultType, NoSuchServiceStartedFaultType, NoReferencesAvailableFaultType, NoSuchServiceFaultType {
        ServiceLoader loader;
        ServiceNode parent;
        LazyCreationCallback callback;
        ServiceProperties parentNode;
        String servicePath;
        MessageContext context = MessageContext.getCurrentContext();
        ServiceNode root = ServiceNode.getRootNode();
        ServiceProperties node = (ServiceProperties)root.resolve(servicePath = HandleHelper.getServicePath(handleSet.getHandle()[0]));
        if (node == null && (parentNode = (ServiceProperties)root.resolve(HandleHelper.getParentID(servicePath))) != null && (callback = (LazyCreationCallback)parentNode.getProperty("lazyCreation")) != null && callback.lazyCreate(handleSet.getHandle()[0])) {
            logger.debug((Object)"succcessful lazy creation of service");
            node = (ServiceProperties)root.resolve(servicePath);
        }
        if (node == null) {
            node = this.resolveWithoutRoute(root, servicePath, context);
        }
        if (node == null) {
            logger.warn((Object)MessageUtils.getMessage("servicePathNotFound", new String[]{servicePath}));
            if (context != null && RedirectProvider.branchExists(servicePath)) {
                throw new RedirectException((String)context.getProperty("redirectResolver"));
            }
        }
        if (node == null && (parent = root.getNode(HandleHelper.getParentID(servicePath))) != null && (loader = parent.getLoader()) != null && loader.load(servicePath)) {
            node = (ServiceProperties)root.activate(servicePath);
        }
        if (node == null) {
            throw FaultHelper.makeFault(class$org$gridforum$ogsi$NoSuchServiceFaultType == null ? (class$org$gridforum$ogsi$NoSuchServiceFaultType = HandleResolverProvider.class$("org.gridforum.ogsi.NoSuchServiceFaultType")) : class$org$gridforum$ogsi$NoSuchServiceFaultType, servicePath);
        }
        try {
            String useCache = (String)this.serviceBase.getProperty("resolverCache");
            if (useCache != null && useCache.equalsIgnoreCase("false")) {
                WSDLGenerator.clearCache(node);
                WSDLGenerator.getWSDL(node);
            }
        }
        catch (Exception e) {
            logger.error((Object)MessageUtils.toString(e));
            throw FaultHelper.makeFault(MessageUtils.getMessage("wsdlGenerationError", new String[]{servicePath}));
        }
        Document wsdl = (Document)node.getProperty("WSDL");
        if (wsdl == null) {
            node = (ServiceProperties)root.activate(servicePath);
            wsdl = (Document)node.getProperty("WSDL");
        }
        LocatorType locator = new LocatorType();
        WSDLReferenceType wsdlReference = new WSDLReferenceType();
        wsdlReference.set_any(new MessageElement[]{new MessageElement(wsdl.getDocumentElement())});
        ReferenceType[] references = new ReferenceType[]{wsdlReference};
        locator.setReference(references);
        context.setProperty("org.globus.ogsa.ContainsReference", (Object)Boolean.TRUE);
        return locator;
    }

    private ServiceProperties resolveWithoutRoute(ServiceNode root, String servicePath, MessageContext context) {
        logger.debug((Object)("Trying to resolve without route: " + servicePath));
        SOAPHeaderElement header = (SOAPHeaderElement)context.getProperty("org.globus.ogsa.RouterHeader");
        if (header == null) {
            return null;
        }
        String via = header.getAttributeValue("via");
        int pathPos = via.indexOf(ContainerConfig.getOgsiLocation());
        String path = via.substring(pathPos + ContainerConfig.getOgsiLocation().length(), via.length());
        logger.debug((Object)("Removing router path: " + path));
        int localPathPos = servicePath.indexOf(path);
        if (localPathPos == -1) {
            return null;
        }
        String localServicePath = servicePath.substring(path.length(), servicePath.length());
        logger.debug((Object)("Trying to resolve routed handle: " + localServicePath));
        return (ServiceProperties)root.resolve(localServicePath);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

