/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.security.authentication;

import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.impl.security.authentication.GssEncryptedSOAPEnvelopeBuilder;
import org.globus.ogsa.impl.security.authentication.SecContext;
import org.globus.ogsa.impl.security.authentication.wssec.WSSecurityFault;

public class EncryptHandler
extends GenericHandler {
    private static Log log = LogFactory.getLog((String)(class$org$globus$ogsa$impl$security$authentication$EncryptHandler == null ? (class$org$globus$ogsa$impl$security$authentication$EncryptHandler = EncryptHandler.class$("org.globus.ogsa.impl.security.authentication.EncryptHandler")) : class$org$globus$ogsa$impl$security$authentication$EncryptHandler).getName());
    static /* synthetic */ Class class$org$globus$ogsa$impl$security$authentication$EncryptHandler;

    public boolean handleRequest(MessageContext context) {
        return this.handleMessage((SOAPMessageContext)context);
    }

    public boolean handleResponse(MessageContext context) {
        return this.handleMessage((SOAPMessageContext)context);
    }

    public boolean handleMessage(SOAPMessageContext ctx) {
        SecContext secContext = (SecContext)ctx.getProperty("org.globus.security.context");
        if (secContext == null) {
            log.debug((Object)"No context - not encrypting.");
            return true;
        }
        log.debug((Object)"Enter: encrypt");
        SOAPMessage msg = ctx.getMessage();
        SOAPMessage encryptedMsg = null;
        try {
            SOAPEnvelope clearEnvelope = msg.getSOAPPart().getEnvelope();
            GssEncryptedSOAPEnvelopeBuilder builder = new GssEncryptedSOAPEnvelopeBuilder((MessageContext)ctx, secContext.getContext(), secContext.getContextId());
            builder.setActor((String)ctx.getProperty("gssActor"));
            encryptedMsg = builder.buildMessage(clearEnvelope);
        }
        catch (Exception e) {
            log.error((Object)"Failed to encrypt message", (Throwable)e);
            throw WSSecurityFault.makeFault(e);
        }
        ctx.setMessage(encryptedMsg);
        log.debug((Object)"Exit: encrypt");
        return true;
    }

    public QName[] getHeaders() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

