/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.security.authentication;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.algorithms.SignatureAlgorithm;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.KeyName;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.utils.Base64;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class GssXMLSignature
extends XMLSignature {
    private static Log log = LogFactory.getLog((String)(class$org$globus$ogsa$impl$security$authentication$GssXMLSignature == null ? (class$org$globus$ogsa$impl$security$authentication$GssXMLSignature = GssXMLSignature.class$("org.globus.ogsa.impl.security.authentication.GssXMLSignature")) : class$org$globus$ogsa$impl$security$authentication$GssXMLSignature).getName());
    static /* synthetic */ Class class$org$globus$ogsa$impl$security$authentication$GssXMLSignature;
    static /* synthetic */ Class class$org$globus$ogsa$impl$security$authentication$SignatureGss;

    public GssXMLSignature(Document doc, String BaseURI) throws XMLSecurityException {
        super(doc, BaseURI, "http://www.globus.org/2002/04/xmlenc#gssapi-sign");
    }

    public GssXMLSignature(Element element, String BaseURI) throws XMLSignatureException, XMLSecurityException, IOException {
        super(element, BaseURI);
    }

    public void sign(GSSContext context) throws XMLSignatureException {
        try {
            SignedInfo si = this.getSignedInfo();
            si.generateDigestValues();
            byte[] signedInfoOctets = si.getCanonicalizedOctetStream();
            byte[] signature = context.getMIC(signedInfoOctets, 0, signedInfoOctets.length, null);
            this.setSignatureValueElement(signature);
        }
        catch (IOException ex) {
            throw new XMLSignatureException("empty", (Exception)ex);
        }
        catch (CanonicalizationException ex) {
            throw new XMLSignatureException("empty", (Exception)((Object)ex));
        }
        catch (InvalidCanonicalizerException ex) {
            throw new XMLSignatureException("empty", (Exception)((Object)ex));
        }
        catch (GSSException ex) {
            throw new XMLSignatureException("empty", (Exception)ex);
        }
        catch (XMLSecurityException ex) {
            throw new XMLSignatureException("empty", (Exception)((Object)ex));
        }
    }

    public void verify(GSSContext context) throws XMLSignatureException {
        SignedInfo si = this.getSignedInfo();
        try {
            if (!si.verify(false)) {
                throw new IOException("Hashes do not verify.");
            }
            byte[] signedInfoOctets = si.getCanonicalizedOctetStream();
            byte[] signature = this.getSignatureValue();
            context.verifyMIC(signature, 0, signature.length, signedInfoOctets, 0, signedInfoOctets.length, null);
        }
        catch (IOException ex) {
            throw new XMLSignatureException("empty", (Exception)ex);
        }
        catch (CanonicalizationException ex) {
            throw new XMLSignatureException("empty", (Exception)((Object)ex));
        }
        catch (InvalidCanonicalizerException ex) {
            throw new XMLSignatureException("empty", (Exception)((Object)ex));
        }
        catch (GSSException ex) {
            throw new XMLSignatureException("empty", (Exception)ex);
        }
        catch (XMLSecurityException ex) {
            throw new XMLSignatureException("empty", (Exception)((Object)ex));
        }
    }

    public void addKeyInfoContextId(String contextID) {
        this.getKeyInfo().addKeyName(contextID);
    }

    public String getKeyInfoContextId() {
        KeyInfo info = this.getKeyInfo();
        if (info.lengthKeyName() > 0) {
            try {
                KeyName nm = info.itemKeyName(0);
                return nm.getKeyName();
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private void setSignatureValueElement(byte[] bytes) throws XMLSignatureException {
        if (this._state == 0) {
            Element signatureValueElem = this.getChildElementLocalName(0, "http://www.w3.org/2000/09/xmldsig#", "SignatureValue");
            while (signatureValueElem.hasChildNodes()) {
                signatureValueElem.removeChild(signatureValueElem.getFirstChild());
            }
            String base64codedValue = Base64.encode((byte[])bytes);
            if (base64codedValue.length() > 76) {
                base64codedValue = "\n" + base64codedValue + "\n";
            }
            Text t = this._doc.createTextNode(base64codedValue);
            signatureValueElem.appendChild(t);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            SignatureAlgorithm.register((String)"http://www.globus.org/2002/04/xmlenc#gssapi-sign", (String)(class$org$globus$ogsa$impl$security$authentication$SignatureGss == null ? (class$org$globus$ogsa$impl$security$authentication$SignatureGss = GssXMLSignature.class$("org.globus.ogsa.impl.security.authentication.SignatureGss")) : class$org$globus$ogsa$impl$security$authentication$SignatureGss).getName());
        }
        catch (Throwable e) {
            log.error((Object)"Failed to install SignatureAlgorithm", e);
            throw new RuntimeException("Failed to install SignatureAlgorithm: " + e.getMessage());
        }
    }
}

