/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.security.authentication.wssec;

import javax.xml.namespace.QName;
import org.apache.axis.utils.XMLUtils;
import org.apache.xml.security.utils.Base64;
import org.globus.ogsa.impl.security.authentication.wssec.WSSecurityException;
import org.globus.ogsa.impl.security.authentication.wssec.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class BinarySecurityToken {
    public static final QName TOKEN = new QName("http://schemas.xmlsoap.org/ws/2002/04/secext", "BinarySecurityToken");
    public static final QName BASE64_ENCODING = new QName("http://schemas.xmlsoap.org/ws/2002/04/secext", "Base64Binary");
    protected static XMLUtils XMLUtil = new XMLUtils();
    protected Element element;

    public BinarySecurityToken(Element elem) throws WSSecurityException {
        this.element = elem;
        QName el = new QName(this.element.getNamespaceURI(), this.element.getLocalName());
        if (!el.equals(TOKEN)) {
            throw new WSSecurityException(4, "badTokenType", new Object[]{el});
        }
        if (!this.getEncodingType().equals(BASE64_ENCODING)) {
            throw new WSSecurityException(4, "badEncoding", new Object[]{this.getEncodingType()});
        }
    }

    public BinarySecurityToken(Document doc) {
        this.element = doc.createElementNS("http://schemas.xmlsoap.org/ws/2002/04/secext", "wsse:BinarySecurityToken");
        WSSecurityUtil.setNamespace(this.element, "http://schemas.xmlsoap.org/ws/2002/04/secext", "wsse");
        this.setEncodingType(BASE64_ENCODING);
        this.element.appendChild(doc.createTextNode(""));
    }

    public QName getValueType() {
        String value = this.element.getAttribute("ValueType");
        return XMLUtils.getQNameFromString((String)value, (Node)this.element);
    }

    protected void setValueType(QName type) {
        this.element.setAttributeNS(null, "ValueType", XMLUtils.getStringForQName((QName)type, (Element)this.element));
    }

    public QName getEncodingType() {
        String value = this.element.getAttribute("EncodingType");
        return XMLUtils.getQNameFromString((String)value, (Node)this.element);
    }

    protected void setEncodingType(QName encoding) {
        this.element.setAttributeNS(null, "EncodingType", XMLUtils.getStringForQName((QName)encoding, (Element)this.element));
    }

    public byte[] getToken() {
        Text node = this.getFirstNode();
        if (node == null) {
            return null;
        }
        try {
            return Base64.decode((String)node.getData());
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void setToken(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data == null");
        }
        Text node = this.getFirstNode();
        node.setData(Base64.encode((byte[])data));
    }

    protected Text getFirstNode() {
        Node node = this.element.getFirstChild();
        return node != null && node instanceof Text ? (Text)node : null;
    }

    public Element getElement() {
        return this.element;
    }

    public String getID() {
        return this.element.getAttributeNS("http://schemas.xmlsoap.org/ws/2002/04/utility", "Id");
    }

    public void setID(String id) {
        String prefix = WSSecurityUtil.setNamespace(this.element, "http://schemas.xmlsoap.org/ws/2002/04/utility", "wsu");
        this.element.setAttributeNS("http://schemas.xmlsoap.org/ws/2002/04/utility", prefix + ":Id", id);
    }

    public String toString() {
        return XMLUtils.ElementToString((Element)this.element);
    }
}

