/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.security.authentication.wssec;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.apache.axis.utils.XMLUtils;
import org.globus.ogsa.impl.security.authentication.wssec.WSSecurityException;

public class WSSecurityFault {
    public static final QName FAILURE = new QName("http://schemas.xmlsoap.org/ws/2002/04/secext", "General");
    public static final QName UNSUPPORTED_SECURITY_TOKEN = new QName("http://schemas.xmlsoap.org/ws/2002/04/secext", "UnsupportedSecurityToken");
    public static final QName UNSUPPORTED_ALGORITHM = new QName("http://schemas.xmlsoap.org/ws/2002/04/secext", "UnsupportedAlgorithm");
    public static final QName INVALID_SECURITY = new QName("http://schemas.xmlsoap.org/ws/2002/04/secext", "InvalidSecurity");
    public static final QName INVALID_SECURITY_TOKEN = new QName("http://schemas.xmlsoap.org/ws/2002/04/secext", "InvalidSecurityToken");
    public static final QName FAILED_AUTHENTICATION = new QName("http://schemas.xmlsoap.org/ws/2002/04/secext", "FailedAuthentication");
    public static final QName FAILED_CHECK = new QName("http://schemas.xmlsoap.org/ws/2002/04/secext", "FailedCheck");
    public static final QName SECURITY_TOKEN_UNAVAILABLE = new QName("http://schemas.xmlsoap.org/ws/2002/04/secext", "SecurityTokenUnavailable");
    private static Properties mapping = new Properties();

    private WSSecurityFault() {
    }

    public static SOAPFaultException makeFault(Exception exception) {
        QName faultCode = null;
        String faultString = exception.getMessage();
        String faultActor = null;
        Detail detail = null;
        if (exception instanceof WSSecurityException) {
            faultCode = WSSecurityFault.getFaultCode(((WSSecurityException)exception).getErrorCode());
        }
        if (faultCode == null) {
            faultCode = FAILURE;
        }
        try {
            SOAPFactory factory = SOAPFactory.newInstance();
            detail = factory.createDetail();
            Name nm = factory.createName("stackTrace", null, "http://xml.apache.org/axis/");
            DetailEntry entry = detail.addDetailEntry(nm);
            entry.addTextNode(WSSecurityFault.getStack(exception));
        }
        catch (SOAPException ee) {
            // empty catch block
        }
        return new SOAPFaultException(faultCode, faultString, faultActor, detail);
    }

    public static QName getFaultCode(int errorCode) {
        return (QName)mapping.get(String.valueOf(errorCode));
    }

    private static void register(int errorCode, QName error) {
        mapping.put(String.valueOf(errorCode), error);
    }

    private static String getStack(Exception e) {
        StringWriter errorWriter = new StringWriter();
        PrintWriter out = new PrintWriter(errorWriter);
        e.printStackTrace(out);
        out.close();
        return XMLUtils.xmlEncodeString((String)errorWriter.toString());
    }

    static {
        WSSecurityFault.register(0, FAILURE);
        WSSecurityFault.register(1, UNSUPPORTED_SECURITY_TOKEN);
        WSSecurityFault.register(2, UNSUPPORTED_ALGORITHM);
        WSSecurityFault.register(3, INVALID_SECURITY);
        WSSecurityFault.register(4, INVALID_SECURITY_TOKEN);
        WSSecurityFault.register(5, FAILED_AUTHENTICATION);
        WSSecurityFault.register(6, FAILED_CHECK);
        WSSecurityFault.register(7, SECURITY_TOKEN_UNAVAILABLE);
    }
}

