/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.security.authorization;

import java.io.IOException;
import java.security.Principal;
import javax.security.auth.Subject;
import javax.xml.rpc.handler.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.jaas.UserNamePrincipal;
import org.globus.ogsa.ServiceProperties;
import org.globus.ogsa.impl.security.authentication.SecureServicePropertiesHelper;
import org.globus.ogsa.impl.security.authorization.AuthorizationException;
import org.globus.ogsa.impl.security.authorization.ServiceAuthorization;
import org.globus.ogsa.impl.security.util.AuthUtil;
import org.globus.security.gridmap.GridMap;
import org.globus.util.I18n;

public class GridMapAuthorization
implements ServiceAuthorization {
    private static I18n i18n = I18n.getI18n((String)"org.globus.ogsa.impl.security.authorization.errors", (ClassLoader)(class$org$globus$ogsa$impl$security$authorization$GridMapAuthorization == null ? (class$org$globus$ogsa$impl$security$authorization$GridMapAuthorization = GridMapAuthorization.class$("org.globus.ogsa.impl.security.authorization.GridMapAuthorization")) : class$org$globus$ogsa$impl$security$authorization$GridMapAuthorization).getClassLoader());
    private static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$impl$security$authorization$GridMapAuthorization == null ? (class$org$globus$ogsa$impl$security$authorization$GridMapAuthorization = GridMapAuthorization.class$("org.globus.ogsa.impl.security.authorization.GridMapAuthorization")) : class$org$globus$ogsa$impl$security$authorization$GridMapAuthorization).getName());
    private static GridMapAuthorization authorization;
    static /* synthetic */ Class class$org$globus$ogsa$impl$security$authorization$GridMapAuthorization;

    public static synchronized GridMapAuthorization getInstance() {
        if (authorization == null) {
            authorization = new GridMapAuthorization();
        }
        return authorization;
    }

    public void authorize(Subject peerSubject, ServiceProperties service, MessageContext context) throws AuthorizationException {
        if (peerSubject == null) {
            throw new IllegalArgumentException(i18n.getMessage("noPeerSubject"));
        }
        if (service == null) {
            throw new IllegalArgumentException(i18n.getMessage("noService"));
        }
        GridMap gridMap = SecureServicePropertiesHelper.getGridMap(service);
        if (gridMap == null) {
            throw new IllegalStateException(i18n.getMessage("noGridmap"));
        }
        try {
            gridMap.refresh();
        }
        catch (IOException e) {
            logger.error((Object)i18n.getMessage("gridmapRefreshFail"), (Throwable)e);
            throw new AuthorizationException(i18n.getMessage("gridmapRefreshFail"), e);
        }
        String peerIdentity = AuthUtil.getIdentity(peerSubject);
        if (peerIdentity == null) {
            logger.error((Object)i18n.getMessage("anonPeer"));
            throw new AuthorizationException(i18n.getMessage("anonPeer"));
        }
        String username = gridMap.getUserID(peerIdentity);
        if (username == null) {
            logger.error((Object)i18n.getMessage("gridmapAuthFailed", (Object)peerIdentity));
            throw new AuthorizationException(i18n.getMessage("gridmapAuthFailed", (Object)peerIdentity));
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)i18n.getMessage("gridmapAuthSuccess", new Object[]{peerIdentity, username}));
        }
        peerSubject.getPrincipals().add((Principal)new UserNamePrincipal(username));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

