/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.security.authorization;

import java.net.MalformedURLException;
import java.net.URL;
import javax.security.auth.Subject;
import javax.xml.rpc.handler.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.impl.security.authorization.Authorization;
import org.globus.ogsa.impl.security.authorization.AuthorizationException;
import org.globus.ogsa.impl.security.util.AuthUtil;
import org.globus.util.I18n;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;

public class HostAuthorization
implements Authorization {
    private static I18n i18n = I18n.getI18n((String)"org.globus.ogsa.impl.security.authorization.errors", (ClassLoader)(class$org$globus$ogsa$impl$security$authorization$HostAuthorization == null ? (class$org$globus$ogsa$impl$security$authorization$HostAuthorization = HostAuthorization.class$("org.globus.ogsa.impl.security.authorization.HostAuthorization")) : class$org$globus$ogsa$impl$security$authorization$HostAuthorization).getClassLoader());
    private static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$impl$security$authorization$HostAuthorization == null ? (class$org$globus$ogsa$impl$security$authorization$HostAuthorization = HostAuthorization.class$("org.globus.ogsa.impl.security.authorization.HostAuthorization")) : class$org$globus$ogsa$impl$security$authorization$HostAuthorization).getName());
    private static HostAuthorization hostAuthorization;
    private String service = null;
    static /* synthetic */ Class class$org$globus$ogsa$impl$security$authorization$HostAuthorization;

    public HostAuthorization(String service) {
        this.service = service == null ? "host" : service;
    }

    public static synchronized HostAuthorization getInstance() {
        if (hostAuthorization == null) {
            hostAuthorization = new HostAuthorization("host");
        }
        return hostAuthorization;
    }

    public void authorize(Subject peerSubject, MessageContext context) throws AuthorizationException {
        String peerIdentity = AuthUtil.getIdentity(peerSubject);
        if (peerIdentity == null) {
            logger.error((Object)i18n.getMessage("anonPeer"));
            throw new AuthorizationException(i18n.getMessage("anonPeer"));
        }
        GSSManager manager = ExtendedGSSManager.getInstance();
        try {
            URL endpoint = AuthUtil.getEndpointAddressURL(context);
            GSSName expected = manager.createName(this.service + "@" + endpoint.getHost(), GSSName.NT_HOSTBASED_SERVICE);
            GSSName target = manager.createName(peerIdentity, null);
            if (!expected.equals(target)) {
                logger.error((Object)i18n.getMessage("hostAuthFail", new Object[]{expected, target}));
                throw new AuthorizationException(i18n.getMessage("hostAuthFail", new Object[]{expected, target}));
            }
            logger.info((Object)i18n.getMessage("hostAuthSuccess"));
        }
        catch (MalformedURLException e) {
            throw new AuthorizationException(i18n.getMessage("authFail"), e);
        }
        catch (GSSException e) {
            throw new AuthorizationException(i18n.getMessage("authFail"), e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

