/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.security.descriptor;

import javax.xml.namespace.QName;
import org.globus.ogsa.impl.security.descriptor.SecurityDescriptorException;
import org.globus.ogsa.impl.security.descriptor.util.ElementHandler;
import org.globus.ogsa.impl.security.descriptor.util.ElementParser;
import org.globus.ogsa.impl.security.descriptor.util.ElementParserException;
import org.globus.util.I18n;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ProtectionLevelParser
implements ElementHandler {
    private static I18n i18n = I18n.getI18n((String)"org.globus.ogsa.impl.security.descriptor.errors");
    public static final QName QNAME = new QName("http://www.globus.org", "protection-level");
    private boolean privacy = false;
    private boolean integrity = false;

    public void parse(Element elem) throws ElementParserException {
        ElementParser.checkElement(elem, QNAME);
        Node currentChild = elem.getFirstChild();
        while (currentChild != null) {
            if (currentChild.getNodeType() == 1) {
                String name = currentChild.getLocalName();
                if (name.equalsIgnoreCase("none")) {
                    throw new SecurityDescriptorException(i18n.getMessage("unsupportedProtLevel", (Object)name));
                }
                if (name.equalsIgnoreCase("integrity")) {
                    this.integrity = true;
                } else if (name.equalsIgnoreCase("privacy")) {
                    this.privacy = true;
                } else {
                    throw new SecurityDescriptorException(i18n.getMessage("badProtLevel", (Object)name));
                }
            }
            currentChild = currentChild.getNextSibling();
        }
    }

    public boolean isIntegrity() {
        return this.integrity;
    }

    public boolean isPrivacy() {
        return this.privacy;
    }
}

