/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.security.descriptor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.globus.ogsa.impl.security.descriptor.AuthMethodParser;
import org.globus.ogsa.impl.security.descriptor.AuthMethodParserCallback;
import org.globus.ogsa.impl.security.descriptor.GSIAuthMethod;
import org.globus.ogsa.impl.security.descriptor.MethodParser;
import org.globus.ogsa.impl.security.descriptor.RunAsParser;
import org.globus.ogsa.impl.security.descriptor.RunAsParserCallback;
import org.globus.ogsa.impl.security.descriptor.SecurityDescriptorException;
import org.globus.ogsa.impl.security.descriptor.util.ElementParser;
import org.globus.util.I18n;

public class SecurityDescriptor
extends ElementParser
implements RunAsParserCallback,
AuthMethodParserCallback {
    public static final String RESOURCE = "org.globus.ogsa.impl.security.descriptor.errors";
    private static I18n i18n = I18n.getI18n((String)"org.globus.ogsa.impl.security.descriptor.errors");
    public static final String NS = "http://www.globus.org";
    private static final QName QNAME = new QName("http://www.globus.org", "securityConfig");
    private int defaultRunAsType = -1;
    private Map methodRunAsTypes;
    private List defaultAuthMethods = null;
    private Map methodAuthMethods;
    private static final List DEFAULT_AUTH_METHODS = new Vector();

    public SecurityDescriptor() {
        super(QNAME);
        this.register(MethodParser.QNAME, new MethodParser(this));
        this.register(RunAsParser.QNAME, new RunAsParser(this));
        this.register(AuthMethodParser.QNAME, new AuthMethodParser(this));
        this.methodRunAsTypes = new HashMap();
        this.methodAuthMethods = new HashMap();
    }

    public void setRunAsType(int runAsType) throws SecurityDescriptorException {
        if (this.defaultRunAsType != -1) {
            throw new SecurityDescriptorException(i18n.getMessage("defaultRunAs"));
        }
        this.defaultRunAsType = runAsType;
    }

    public void setMethodRunAsType(QName method, int identity) throws SecurityDescriptorException {
        if (method == null) {
            throw new IllegalArgumentException("method == null");
        }
        if (this.methodRunAsTypes.put(method, new Integer(identity)) != null) {
            throw new SecurityDescriptorException(i18n.getMessage("methodRunAs", (Object)method));
        }
    }

    public void setAuthMethods(List authMethods) throws SecurityDescriptorException {
        if (this.defaultAuthMethods != null) {
            throw new SecurityDescriptorException(i18n.getMessage("defaultAuthMethods"));
        }
        this.defaultAuthMethods = authMethods;
    }

    public void setMethodAuthMethods(QName method, List authMethods) throws SecurityDescriptorException {
        if (authMethods == null) {
            throw new IllegalArgumentException("authMethods == null");
        }
        if (this.methodAuthMethods.put(method, authMethods) != null) {
            throw new SecurityDescriptorException(i18n.getMessage("methodAuthMethods", (Object)method));
        }
    }

    public int getDefaultRunAsType() {
        return this.defaultRunAsType == -1 ? 3 : this.defaultRunAsType;
    }

    public int getRunAsType(QName method) {
        Integer runAsType = (Integer)this.methodRunAsTypes.get(method);
        return runAsType == null ? this.getDefaultRunAsType() : runAsType.intValue();
    }

    public List getDefaultAuthMethods() {
        return this.defaultAuthMethods == null ? DEFAULT_AUTH_METHODS : this.defaultAuthMethods;
    }

    public List getAuthMethods(QName method) {
        List methods = (List)this.methodAuthMethods.get(method);
        return methods == null ? this.getDefaultAuthMethods() : methods;
    }

    public String getRequiredAuthMethodsErrorMessage(List methods, QName opName) {
        return i18n.getMessage("authRequired", new Object[]{AuthMethodParser.getAuthMethodsAsString(methods), opName});
    }

    static {
        DEFAULT_AUTH_METHODS.add(GSIAuthMethod.BOTH);
    }
}

