/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.security.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.axis.Message;
import org.apache.axis.message.MessageElement;
import org.apache.axis.utils.DOM2Writer;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Util {
    public static String toString(Message msg) {
        return new String(Util.toByteArray(msg));
    }

    public static byte[] toByteArray(Message msg) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(512);
        try {
            msg.writeTo((OutputStream)out);
        }
        catch (Exception e) {}
        return out.toByteArray();
    }

    public static String toString(MessageElement el) throws Exception {
        return Util.toString(el.getAsDOM());
    }

    public static String toString(Node doc) {
        return Util.toString(doc, true);
    }

    public static String toString(Node doc, boolean pretty) {
        StringWriter writer = new StringWriter();
        DOM2Writer.serializeAsXML((Node)doc, (Writer)writer, (boolean)true, (boolean)pretty);
        return writer.toString();
    }

    public static void dump(Node node) {
        System.out.println(node.getNamespaceURI());
        System.out.println(node.getLocalName());
        System.out.println(node.getPrefix());
        System.out.println(node.getChildNodes().getLength());
    }

    public static String toString2(Node node) {
        return Util.toString2(node, "");
    }

    public static String getName(Node node) {
        String ns = node.getNamespaceURI();
        if (ns == null) {
            return node.getLocalName();
        }
        return node.getPrefix() + ":" + node.getLocalName();
    }

    public static String getNameValue(Node node) {
        String ns = node.getNamespaceURI();
        if (ns == null) {
            return node.getLocalName();
        }
        return node.getPrefix() + ":" + node.getLocalName() + "=\"" + node.getNodeValue() + "\"";
    }

    public static String getAttrName(Node node) {
        StringBuffer buf = new StringBuffer();
        buf.append(Util.getName(node));
        NamedNodeMap map = node.getAttributes();
        int len = map.getLength();
        int i = 0;
        while (i < len) {
            buf.append(" ");
            buf.append(Util.getNameValue(map.item(i)));
            ++i;
        }
        return buf.toString();
    }

    public static String toString2(Node node, String tab) {
        StringBuffer buf = new StringBuffer();
        NodeList list = node.getChildNodes();
        int len = list.getLength();
        buf.append(tab);
        if (len <= 0) {
            if (node.getNodeType() == 3) {
                String data = ((Text)node).getData();
                int i = 0;
                while (i < data.length()) {
                    buf.append(" " + data.charAt(i));
                    ++i;
                }
            } else {
                buf.append("<" + Util.getAttrName(node) + "/>");
            }
            buf.append("\r\n");
            return buf.toString();
        }
        buf.append("<" + Util.getAttrName(node) + ">");
        buf.append("\r\n");
        int i = 0;
        while (i < len) {
            Node elem = list.item(i);
            buf.append(Util.toString2(elem, tab + " " + i + ". "));
            ++i;
        }
        buf.append(tab);
        buf.append("</" + Util.getName(node) + ">");
        buf.append("\r\n");
        return buf.toString();
    }
}

