/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.repository;

import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.rpc.handler.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.GridContext;
import org.globus.ogsa.GridServiceBase;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.ServiceProperties;
import org.globus.ogsa.impl.core.handle.HandleHelper;
import org.globus.ogsa.impl.core.service.ServicePropertiesImpl;
import org.globus.ogsa.repository.DefaultServiceActivator;
import org.globus.ogsa.repository.ServiceActivationException;
import org.globus.ogsa.repository.ServiceActivator;
import org.globus.ogsa.repository.ServiceActivatorHolder;
import org.globus.ogsa.repository.ServiceListener;
import org.globus.ogsa.repository.ServiceLoader;
import org.globus.ogsa.repository.ServiceNotificationThread;

public class ServiceNode {
    private static ServiceNode rootNode = null;
    private Hashtable children;
    private Object service;
    private ServiceActivator activator = null;
    private ServiceLoader loader = null;
    protected static Hashtable listeners = new Hashtable();
    boolean isDebug;
    static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$repository$ServiceNode == null ? (class$org$globus$ogsa$repository$ServiceNode = ServiceNode.class$("org.globus.ogsa.repository.ServiceNode")) : class$org$globus$ogsa$repository$ServiceNode).getName());
    static /* synthetic */ Class class$org$globus$ogsa$repository$ServiceNode;

    public ServiceNode(Object service) {
        this.service = service;
        this.isDebug = logger.isDebugEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(ServiceListener listener) {
        Hashtable hashtable = listeners;
        synchronized (hashtable) {
            listeners.put(listener, listener);
        }
    }

    public void setActivator(ServiceActivator activator) {
        this.activator = activator;
    }

    public void setLoader(ServiceLoader loader) {
        this.loader = loader;
    }

    public ServiceLoader getLoader() {
        return this.loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void removeListener(ServiceListener listener) {
        Hashtable hashtable = listeners;
        synchronized (hashtable) {
            listeners.remove(listener);
        }
    }

    private void notifyServiceListeners() {
        if (listeners.size() > 0) {
            ServiceNotificationThread thread = new ServiceNotificationThread();
            thread.start();
        }
    }

    public static synchronized ServiceNode getRootNode() {
        if (rootNode == null) {
            rootNode = new ServiceNode(null);
            rootNode.setActivator(new DefaultServiceActivator());
        }
        return rootNode;
    }

    public Object getService() {
        return this.service;
    }

    public void deactivate(String servicePath) throws GridServiceException {
        Object deactivatedState;
        ServiceProperties properties = (ServiceProperties)this.resolve(servicePath);
        if (properties == null || !(properties instanceof GridServiceBase)) {
            return;
        }
        ServicePropertiesImpl deactivatedService = new ServicePropertiesImpl();
        Calendar timeout = (Calendar)properties.getProperty("timeout");
        String handle = (String)properties.getProperty("Handle");
        if (properties.getProperty("factory") != null) {
            deactivatedService.setProperty("deactivatedTransient", Boolean.TRUE);
            logger.debug((Object)("deactivating transient servicePath: " + servicePath));
        } else {
            deactivatedService.setProperty("deactivatedPersistent", Boolean.TRUE);
            logger.debug((Object)("deactivating persistent servicePath: " + servicePath));
        }
        if (timeout != null) {
            deactivatedService.setProperty("timeout", timeout);
        }
        String fullPath = (String)properties.getProperty("servicePath");
        deactivatedService.setProperty("servicePath", fullPath);
        deactivatedService.setProperty("Handle", handle);
        deactivatedService.setProperty("name", fullPath);
        this.bind(servicePath, (Object)deactivatedService);
        if (properties instanceof GridServiceBase) {
            ((GridServiceBase)properties).deactivate(new GridContext((MessageContext)org.apache.axis.MessageContext.getCurrentContext(), properties));
        }
        if ((deactivatedState = properties.getProperty("deactivatedState")) != null) {
            deactivatedService.setProperty("deactivatedState", deactivatedState);
        }
    }

    public Object activate(String servicePath) throws ServiceActivationException {
        return this.activate(servicePath, null);
    }

    private boolean checkLoader(String servicePath) throws ServiceActivationException {
        try {
            ServiceLoader loader;
            ServiceNode node = rootNode.getNode(HandleHelper.getParentID(servicePath));
            if (node != null && (loader = node.getLoader()) != null) {
                return loader.load(servicePath);
            }
        }
        catch (Exception e) {
            throw new ServiceActivationException(e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object activate(String servicePath, org.apache.axis.MessageContext context) throws ServiceActivationException {
        ServiceActivatorHolder holder = new ServiceActivatorHolder();
        ServiceProperties obj = (ServiceProperties)this.resolve(servicePath, holder);
        if (context == null) {
            context = org.apache.axis.MessageContext.getCurrentContext();
        }
        if (obj == null && this.checkLoader(servicePath)) {
            logger.debug((Object)("loaded servicePath: " + servicePath));
            obj = (ServiceProperties)this.resolve(servicePath, holder);
        }
        if (obj == null) {
            throw new ServiceActivationException(servicePath);
        }
        if (obj instanceof GridServiceBase) {
            return obj;
        }
        ServiceProperties serviceProperties = obj;
        synchronized (serviceProperties) {
            if (holder.activator != null) {
                Boolean persistentDeactivated = (Boolean)obj.getProperty("deactivatedPersistent");
                if (persistentDeactivated != null) {
                    if (persistentDeactivated.booleanValue()) {
                        obj.setProperty("deactivatedPersistent", Boolean.FALSE);
                        return holder.activator.activatePersistent(servicePath, new GridContext((MessageContext)context, obj));
                    }
                    return this.resolve(servicePath);
                }
                Boolean transientDeactivated = (Boolean)obj.getProperty("deactivatedTransient");
                if (transientDeactivated != null) {
                    if (transientDeactivated.booleanValue()) {
                        obj.setProperty("deactivatedTransient", Boolean.FALSE);
                        return holder.activator.activate(servicePath, new GridContext((MessageContext)context, obj));
                    }
                    return this.resolve(servicePath);
                }
            }
        }
        return obj;
    }

    public Object resolve(String servicePath) {
        ServiceNode node = this.getNode(servicePath);
        return node == null ? null : node.getService();
    }

    public Object resolve(String servicePath, ServiceActivatorHolder activatorHolder) {
        StringTokenizer tokenizer = new StringTokenizer(servicePath, "/");
        return this.resolve(tokenizer, activatorHolder);
    }

    private Object resolve(Enumeration enumeration, ServiceActivatorHolder activatorHolder) {
        if (this.activator != null) {
            activatorHolder.activator = this.activator;
        }
        if (enumeration.hasMoreElements()) {
            ServiceNode childNode = this.getChildNode((String)enumeration.nextElement());
            return childNode == null ? null : childNode.resolve(enumeration, activatorHolder);
        }
        return this.service;
    }

    public ServiceNode getNode(String servicePath) {
        StringTokenizer tokenizer = new StringTokenizer(servicePath, "/");
        return this.getNode(tokenizer);
    }

    private ServiceNode getNode(Enumeration enumeration) {
        if (enumeration.hasMoreElements()) {
            ServiceNode childNode = this.getChildNode((String)enumeration.nextElement());
            return childNode == null ? null : childNode.getNode(enumeration);
        }
        return this;
    }

    public ServiceNode bind(String servicePath, Object obj) {
        StringTokenizer tokenizer = new StringTokenizer(servicePath, "/");
        return this.bind(tokenizer, obj);
    }

    private synchronized ServiceNode initChildNode(String localName) {
        ServiceNode childNode;
        if (this.children == null) {
            this.children = new Hashtable();
        }
        if ((childNode = (ServiceNode)this.children.get(localName)) == null) {
            childNode = new ServiceNode(null);
            this.children.put(localName, childNode);
        }
        return childNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceNode bind(Enumeration enumeration, Object obj) {
        if (enumeration.hasMoreElements()) {
            ServiceNode childNode2;
            String localName = (String)enumeration.nextElement();
            if (enumeration.hasMoreElements()) {
                ServiceNode childNode2 = this.initChildNode(localName);
                return childNode2.bind(enumeration, obj);
            }
            if (this.isDebug) {
                logger.debug((Object)("Binding new child element " + localName));
            }
            ServiceNode serviceNode = this;
            synchronized (serviceNode) {
                childNode2 = this.initChildNode(localName);
                childNode2.service = obj;
            }
            this.notifyServiceListeners();
            return childNode2;
        }
        if (this.isDebug) {
            logger.debug((Object)"Binding element to local object");
        }
        this.service = obj;
        return this;
    }

    public ServiceNode unbind(String servicePath) {
        StringTokenizer tokenizer = new StringTokenizer(servicePath, "/");
        return this.unbind(tokenizer);
    }

    private ServiceNode getChildNode(String name) {
        if (this.children == null) {
            return null;
        }
        return (ServiceNode)this.children.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceNode unbind(Enumeration enumeration) {
        if (enumeration.hasMoreElements()) {
            ServiceNode childNode2;
            String localName = (String)enumeration.nextElement();
            if (enumeration.hasMoreElements()) {
                ServiceNode childNode2 = this.getChildNode(localName);
                if (childNode2 == null) {
                    return null;
                }
                return childNode2.unbind(enumeration);
            }
            if (this.isDebug) {
                logger.debug((Object)("Removing child element " + localName));
            }
            ServiceNode serviceNode = this;
            synchronized (serviceNode) {
                if (this.children == null) {
                    return null;
                }
                childNode2 = (ServiceNode)this.children.get(localName);
                if (childNode2 == null) {
                    return null;
                }
                this.children.remove(localName);
            }
            this.notifyServiceListeners();
            return childNode2;
        }
        return null;
    }

    public Vector getAllServices() {
        Vector childServices = new Vector();
        this.getAllServices(childServices, true);
        return childServices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAllServices(Vector childServices, boolean isRoot) {
        if (this.service != null && !isRoot) {
            childServices.addElement(this.service);
        }
        if (this.children != null) {
            if (this.isDebug) {
                logger.debug((Object)("Getting " + this.children.size() + " objects"));
            }
            Hashtable hashtable = this.children;
            synchronized (hashtable) {
                Enumeration e = this.children.elements();
                while (e.hasMoreElements()) {
                    ServiceNode node = (ServiceNode)e.nextElement();
                    node.getAllServices(childServices, false);
                }
            }
        }
    }

    public String toString() {
        return this.toString("");
    }

    private String toString(String tab) {
        if (this.children == null) {
            return "";
        }
        String newTab = tab + " ";
        StringBuffer buf = new StringBuffer();
        Enumeration e = this.children.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            ServiceNode node = (ServiceNode)this.children.get(name);
            buf.append(tab).append(name).append("\n");
            buf.append(node.toString(newTab));
        }
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

