/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.server;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import org.globus.ogsa.ServiceData;
import org.globus.ogsa.config.ContainerConfig;
import org.globus.ogsa.server.ServiceContainer;
import org.globus.ogsa.utils.AnyHelper;
import org.globus.ogsa.utils.MessageUtils;
import org.globus.ogsa.utils.QueryHelper;
import org.globus.security.gridmap.GridMap;
import org.gridforum.ogsi.EntryType;
import org.gridforum.ogsi.ExtensibilityType;
import org.gridforum.ogsi.GridService;
import org.gridforum.ogsi.OGSIServiceGridLocator;
import org.gridforum.ogsi.ServiceDataValuesType;
import org.ietf.jgss.GSSCredential;

class ContainerThread
extends Thread {
    private int port = 0;
    private int securePort = 0;
    private boolean secure = false;
    private boolean lazy = false;
    private GridMap gridMap = null;
    private GSSCredential creds = null;
    static /* synthetic */ Class class$org$gridforum$ogsi$ServiceDataValuesType;
    static /* synthetic */ Class class$org$gridforum$ogsi$EntryType;

    public ContainerThread(int port, int securePort, boolean secure, GridMap gridMap, GSSCredential creds, boolean lazy) {
        this.port = port;
        this.securePort = securePort;
        this.secure = secure;
        this.gridMap = gridMap;
        this.creds = creds;
        this.lazy = lazy;
    }

    public void run() {
        try {
            String shutdown;
            ServiceContainer container = ServiceContainer.createContainer(false, this.port);
            ServiceContainer.logger.debug((Object)("Service container running at : " + container.getURLString()));
            ServiceContainer secureContainer = ServiceContainer.startSecurityContainer(this.secure, this.securePort, this.creds, this.gridMap);
            if (!this.lazy) {
                OGSIServiceGridLocator registryService = new OGSIServiceGridLocator();
                GridService registry = registryService.getGridServicePort(new URL(container.getURLString() + "core/registry/ContainerRegistryService"));
                ExtensibilityType queryResult = registry.findServiceData(QueryHelper.getNamesQuery(ServiceData.ENTRY));
                ServiceDataValuesType serviceDataValues = (ServiceDataValuesType)AnyHelper.getAsSingleObject(queryResult, class$org$gridforum$ogsi$ServiceDataValuesType == null ? (class$org$gridforum$ogsi$ServiceDataValuesType = ContainerThread.class$("org.gridforum.ogsi.ServiceDataValuesType")) : class$org$gridforum$ogsi$ServiceDataValuesType);
                Object[] entries = AnyHelper.getAsObject(serviceDataValues, class$org$gridforum$ogsi$EntryType == null ? (class$org$gridforum$ogsi$EntryType = ContainerThread.class$("org.gridforum.ogsi.EntryType")) : class$org$gridforum$ogsi$EntryType);
                StringWriter list = new StringWriter();
                PrintWriter out = new PrintWriter(list);
                out.println("");
                int i = 0;
                while (i < entries.length) {
                    EntryType entry = (EntryType)entries[i];
                    out.println(entry.getMemberServiceLocator().getHandle()[0].toString());
                    ++i;
                }
                out.flush();
                if (ServiceContainer.logger.isInfoEnabled()) {
                    ServiceContainer.logger.info((Object)MessageUtils.getMessage("startServer", new String[]{container.getURLString(), list.toString()}));
                }
            }
            container.waitForInit();
            container.waitForStop();
            ServiceContainer.logger.info((Object)MessageUtils.getMessage("stopServer", new String[]{container.getURLString()}));
            if (secureContainer != null) {
                secureContainer.waitForStop();
                ServiceContainer.logger.info((Object)MessageUtils.getMessage("stopServer", new String[]{secureContainer.getURLString()}));
            }
            if ((shutdown = ContainerConfig.getConfig().getOption("hardShutdown")) != null && shutdown.equalsIgnoreCase("true")) {
                ServiceContainer.logger.debug((Object)"Hard shutdown");
                System.exit(0);
            }
        }
        catch (Exception e) {
            ServiceContainer.logger.error((Object)MessageUtils.toString(e));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

