/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.server;

import java.lang.reflect.Constructor;
import java.net.ServerSocket;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.apache.axis.AxisEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.net.ServerSocketFactory;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.config.ConfigException;
import org.globus.ogsa.config.ContainerConfig;
import org.globus.ogsa.server.ContainerThread;
import org.globus.ogsa.server.ServiceContainerCollection;
import org.globus.ogsa.server.ServiceDispatcher;
import org.globus.ogsa.server.ServiceHost;
import org.globus.ogsa.utils.MessageUtils;
import org.globus.security.gridmap.GridMap;
import org.ietf.jgss.GSSCredential;

public class ServiceContainer
implements Runnable {
    public static final int DEFAULT_PORT = 8080;
    public static final String CLASS = "container.class";
    public static final String PORT = "container.port";
    public static final String MAIN_THREAD = "container.mainThread";
    public static final String THREADS = "container.threads";
    protected URL url;
    protected ServiceDispatcher dispatcher;
    private static Properties defaultMainThreadProps;
    private static Properties defaultNonMainThreadProps;
    private static Hashtable containers;
    static Log logger;
    static /* synthetic */ Class class$org$globus$ogsa$server$ServiceContainer;
    static /* synthetic */ Class class$java$util$Map;

    public static synchronized ServiceContainer createContainer(boolean isMainThread) throws GridServiceException {
        Properties props = null;
        if (isMainThread) {
            if (defaultMainThreadProps == null) {
                defaultMainThreadProps = new Properties();
                defaultMainThreadProps.put(MAIN_THREAD, Boolean.TRUE);
            }
            props = defaultMainThreadProps;
        } else {
            if (defaultNonMainThreadProps == null) {
                defaultNonMainThreadProps = new Properties();
                defaultNonMainThreadProps.put(MAIN_THREAD, Boolean.FALSE);
            }
            props = defaultNonMainThreadProps;
        }
        return ServiceContainer.createContainer(props);
    }

    public static ServiceContainer createContainer(boolean isMainThread, int port) throws GridServiceException {
        Properties props = new Properties();
        props.put(MAIN_THREAD, new Boolean(isMainThread));
        props.put(PORT, new Integer(port));
        return ServiceContainer.createContainer(props);
    }

    public static synchronized ServiceContainer createContainer(Map properties) throws GridServiceException {
        if (properties == null) {
            throw new IllegalArgumentException(MessageUtils.getMessage("containerPropertiesNotSpecified"));
        }
        ServiceContainer container = null;
        container = (ServiceContainer)containers.get(properties);
        if (container != null) {
            return container;
        }
        Class containerClass = null;
        String prop = (String)properties.get(CLASS);
        if (prop == null) {
            containerClass = class$org$globus$ogsa$server$ServiceContainer == null ? (class$org$globus$ogsa$server$ServiceContainer = ServiceContainer.class$("org.globus.ogsa.server.ServiceContainer")) : class$org$globus$ogsa$server$ServiceContainer;
        } else {
            try {
                containerClass = Class.forName(prop);
            }
            catch (Exception e) {
                throw new GridServiceException(e);
            }
            if (!(class$org$globus$ogsa$server$ServiceContainer == null ? (class$org$globus$ogsa$server$ServiceContainer = ServiceContainer.class$("org.globus.ogsa.server.ServiceContainer")) : class$org$globus$ogsa$server$ServiceContainer).isAssignableFrom(containerClass)) {
                throw new GridServiceException(MessageUtils.getMessage("containerClassError", new String[]{"" + prop}));
            }
        }
        try {
            Constructor con = containerClass.getConstructor(class$java$util$Map == null ? (class$java$util$Map = ServiceContainer.class$("java.util.Map")) : class$java$util$Map);
            container = (ServiceContainer)con.newInstance(properties);
        }
        catch (Exception e) {
            throw new GridServiceException(e);
        }
        containers.put(properties, container);
        ServiceContainerCollection.register(container.getURLString(), container);
        return container;
    }

    protected ServiceContainer() {
    }

    public ServiceContainer(Map properties) throws GridServiceException {
        if (properties == null) {
            throw new IllegalArgumentException(MessageUtils.getMessage("containerPropertiesNotSpecified"));
        }
        int port = 0;
        Integer portProp = (Integer)properties.get(PORT);
        if (portProp != null) {
            port = portProp;
        }
        boolean isMainThread = false;
        Boolean threadProp = (Boolean)properties.get(MAIN_THREAD);
        if (threadProp != null) {
            isMainThread = threadProp;
        }
        int threads = -1;
        Integer threadsProp = (Integer)properties.get(THREADS);
        if (threadsProp != null) {
            threads = threadsProp;
        }
        this.init(isMainThread, port, threads);
    }

    private ServiceContainer(boolean isMainThread, int port) throws GridServiceException {
        this.init(isMainThread, port, -1);
    }

    private void init(boolean isMainThread, int port, int threads) throws GridServiceException {
        ServerSocket socket;
        ServerSocketFactory factory = ServerSocketFactory.getDefault();
        this.dispatcher = new ServiceDispatcher();
        this.dispatcher.setThreads(threads);
        try {
            socket = factory.createServerSocket(port);
        }
        catch (Exception e) {
            throw new GridServiceException(e);
        }
        this.dispatcher.setServerSocket(socket);
        Thread serverThread = new Thread(this.dispatcher);
        serverThread.setDaemon(!isMainThread);
        serverThread.start();
        port = socket.getLocalPort();
        String baseURL = "http://" + ServiceHost.getHost() + ":" + port + "/" + ContainerConfig.getOgsiLocation();
        logger.debug((Object)baseURL);
        try {
            this.url = new URL(baseURL);
        }
        catch (Exception e) {
            throw new GridServiceException(e);
        }
    }

    public int getPort() {
        return this.url.getPort();
    }

    public String getHost() {
        return this.url.getHost();
    }

    public String getURLString() {
        return this.url.toString();
    }

    public URL getURL() {
        return this.url;
    }

    public void stopServer() throws GridServiceException {
        logger.debug((Object)("Stopping server: " + this.getURLString()));
        this.dispatcher.stop();
    }

    public void waitForInit() throws InterruptedException {
        this.dispatcher.waitForInit();
    }

    public void waitForStop() throws InterruptedException {
        this.dispatcher.waitForStop();
    }

    public AxisEngine getEngine() throws ConfigException {
        return ServiceDispatcher.getAxisEngine();
    }

    public void run() {
    }

    public static void main(String[] args) {
        try {
            String usageMsg = "Usage: ServiceContainer [options]\nWhere [options] are:\n -help\t\t\t\tdisplays this message\n -p port\t\t\tcontainer port number\n -lazy\t\t\tinitialize container at first invocation (default at startup)\n -eager\t\t\tinitialize container at startup (default)\n -secure\t\t\tenable secure container\n -sp port\t\t\tsecure container port number\n -gridMap file\t\t\tgridmap file for secure container\n -containerProxy file\t\tproxy credential to use for secure container\n -containerCert file\t\tcertificate to use for secure container (requires -containerKey)\n -containerKey file\t\tkey to use for secure container (requires -containerCert)\n -trustedCertLocations files\tlist of locations (files and directories) of trusted CA certificates\n                           \t(requires -containerProxy or -containerCert/-containerKey)";
            int port = 8080;
            int securePort = 0;
            boolean secure = false;
            GridMap gridMap = null;
            String serverKey = null;
            String serverCert = null;
            String serverProxy = null;
            String trustedCertLocations = null;
            boolean lazy = false;
            int i = 0;
            while (i < args.length) {
                if (args[i].equals("-p")) {
                    if (i + 1 == args.length) {
                        System.err.println("Error: -p requires an argument.");
                        return;
                    }
                    port = Integer.parseInt(args[++i]);
                } else if (args[i].equalsIgnoreCase("-secure")) {
                    secure = true;
                } else if (args[i].equals("-sp")) {
                    if (i + 1 == args.length) {
                        System.err.println("Error: -sp requires an argument.");
                        return;
                    }
                    securePort = Integer.parseInt(args[++i]);
                } else if (args[i].equalsIgnoreCase("-gridMap")) {
                    if (i + 1 == args.length) {
                        System.err.println("Error: -gridMap requires an argument.");
                        return;
                    }
                    gridMap = new GridMap();
                    gridMap.load(args[++i]);
                } else {
                    if (args[i].equalsIgnoreCase("-help")) {
                        System.err.println(usageMsg);
                        return;
                    }
                    if (args[i].equalsIgnoreCase("-containerCert")) {
                        if (i + 1 == args.length) {
                            System.err.println("Error: -containerCert requires an argument.");
                            return;
                        }
                        serverCert = args[++i];
                    } else if (args[i].equalsIgnoreCase("-containerKey")) {
                        if (i + 1 == args.length) {
                            System.err.println("Error: -containerKey requires an argument.");
                            return;
                        }
                        serverKey = args[++i];
                    } else if (args[i].equalsIgnoreCase("-containerProxy")) {
                        if (i + 1 == args.length) {
                            System.err.println("Error: -containerProxy requires an argument.");
                            return;
                        }
                        serverProxy = args[++i];
                    } else if (args[i].equalsIgnoreCase("-trustedCertLocations")) {
                        if (i + 1 == args.length) {
                            System.err.println("Error: -trustedCertLocations requires an argument.");
                            return;
                        }
                        trustedCertLocations = args[++i];
                    } else if (args[i].equalsIgnoreCase("-lazy")) {
                        lazy = true;
                    } else if (args[i].equalsIgnoreCase("-eager")) {
                        lazy = false;
                    } else {
                        System.err.println("Error: argument not recoginized: " + args[i]);
                        return;
                    }
                }
                ++i;
            }
            if (serverProxy != null && (serverCert != null || serverKey != null)) {
                System.err.println("Error: -containerProxy cannot be specified with -containerCert or -containerKey");
                return;
            }
            if (serverCert != null && serverKey == null || serverCert == null && serverKey != null) {
                System.err.println("Error: -containerCert and -containerKey must be specified together.");
                return;
            }
            GlobusCredential creds = null;
            if (serverProxy != null) {
                creds = new GlobusCredential(serverProxy);
            } else if (serverCert != null && serverKey != null) {
                creds = new GlobusCredential(serverCert, serverKey);
            } else if (trustedCertLocations != null) {
                System.err.println("Error: -trustedCertLocations can only be used with -containerProxy  or -containerKey/-containerCert");
                return;
            }
            GlobusGSSCredentialImpl gssCred = null;
            if (creds != null) {
                gssCred = new GlobusGSSCredentialImpl(creds, 2);
            }
            ContainerThread containerThread = new ContainerThread(port, securePort, secure, gridMap, (GSSCredential)gssCred, lazy);
            containerThread.start();
            containerThread.join();
        }
        catch (Exception e) {
            System.err.println(MessageUtils.toString(e));
        }
    }

    public static ServiceContainer startSecurityContainer(boolean secure, int securePort, GSSCredential credential, GridMap gridMap) throws GridServiceException {
        ContainerConfig config = ContainerConfig.getConfig();
        int port = 0;
        String securityPort = config.getOption("httpgPort");
        if (securityPort == null) {
            if (!secure) {
                return null;
            }
            port = securePort;
        } else {
            port = Integer.parseInt(securityPort);
        }
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put(CLASS, "org.globus.ogsa.server.GSIServiceContainer");
        props.put(PORT, new Integer(port));
        if (credential != null) {
            props.put("container.credential", credential);
        }
        if (gridMap != null) {
            props.put("container.gridmap", gridMap);
        }
        props.put(MAIN_THREAD, Boolean.FALSE);
        ServiceContainer container = ServiceContainer.createContainer(props);
        config.setOption("httpgPort", String.valueOf(container.getPort()));
        logger.debug((Object)("Secure service container running at : " + container.getURLString()));
        return container;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        containers = new Hashtable();
        logger = LogFactory.getLog((String)(class$org$globus$ogsa$server$ServiceContainer == null ? (class$org$globus$ogsa$server$ServiceContainer = ServiceContainer.class$("org.globus.ogsa.server.ServiceContainer")) : class$org$globus$ogsa$server$ServiceContainer).getName());
    }
}

