/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.tools.ant;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.axis.utils.XMLUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Environment;
import org.globus.ogsa.tools.ant.StressTest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JavaStress
extends Java
implements Runnable {
    private int numThreads = 1;
    private int repeats = 1;
    private int numProcesses = 1;
    private String procid = null;
    private boolean concurrent = true;
    private Hashtable responseTimes = new Hashtable();
    private Hashtable errors = new Hashtable();
    private String logFileName = "java-stress";
    private String redirectClass;
    private String[] args;
    private long totalTime = -1L;
    private long avgTime = -1L;
    private Method runMethod;
    private StressTest object;

    public JavaStress() {
        this.args = new String[0];
    }

    public JavaStress(String[] args) {
        this.numThreads = Integer.parseInt(System.getProperty("org.globus.ogsa.stress.threads"));
        this.repeats = Integer.parseInt(System.getProperty("org.globus.ogsa.stress.repeats"));
        this.procid = "proc-" + System.currentTimeMillis();
        this.concurrent = "true".equalsIgnoreCase(System.getProperty("org.globus.ogsa.stress.concurrent"));
        this.redirectClass = System.getProperty("org.globus.ogsa.stress.redirectClass");
        this.logFileName = System.getProperty("org.globus.ogsa.stress.logFileName");
        this.args = args;
    }

    public void execute() throws BuildException {
        Environment.Variable env = new Environment.Variable();
        env.setKey("org.globus.ogsa.stress.threads");
        env.setValue(Integer.toString(this.numThreads));
        this.addSysproperty(env);
        env = new Environment.Variable();
        env.setKey("org.globus.ogsa.stress.concurrent");
        env.setValue(this.concurrent ? "true" : "false");
        this.addSysproperty(env);
        env = new Environment.Variable();
        env.setKey("org.globus.ogsa.stress.redirectClass");
        env.setValue(this.redirectClass);
        this.addSysproperty(env);
        env = new Environment.Variable();
        env.setKey("org.globus.ogsa.stress.logFileName");
        env.setValue(this.logFileName);
        this.addSysproperty(env);
        env = new Environment.Variable();
        env.setKey("org.globus.ogsa.stress.repeats");
        env.setValue(Integer.toString(this.repeats));
        this.addSysproperty(env);
        Thread[] procs = new Thread[this.numProcesses];
        int i = 0;
        while (i < this.numProcesses) {
            procs[i] = new Thread(){

                public void run() {
                    JavaStress.this.executeJava();
                }
            };
            procs[i].start();
            ++i;
        }
        int i2 = 0;
        while (i2 < this.numProcesses) {
            try {
                procs[i2].join();
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
            ++i2;
        }
    }

    public void executeJavaStress() throws BuildException {
        try {
            Class<?> javaClass = Class.forName(this.redirectClass);
            this.object = (StressTest)javaClass.newInstance();
            this.object.init(this.args);
        }
        catch (Exception e) {
            StringWriter errorWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(errorWriter));
            throw new BuildException("Failed to initilize:" + errorWriter.toString());
        }
        long startTime = System.currentTimeMillis();
        if (this.concurrent) {
            Thread[] threads = new Thread[this.numThreads];
            int start = 0;
            while (start < this.numThreads) {
                threads[start] = new Thread(this);
                threads[start].start();
                ++start;
            }
            int stop = 0;
            while (stop < this.numThreads) {
                try {
                    threads[stop].join();
                }
                catch (InterruptedException ie) {
                    this.errors.put(threads[stop].getName(), ie);
                }
                ++stop;
            }
        } else {
            int startIndex = 0;
            while (startIndex < this.numThreads) {
                long start;
                long stop = start = System.currentTimeMillis();
                try {
                    int i = 0;
                    while (i < this.repeats) {
                        this.runJavaStress();
                        ++i;
                    }
                    stop = System.currentTimeMillis();
                    this.object.postRun();
                }
                catch (Exception e) {
                    this.errors.put(Integer.toString(startIndex), e);
                }
                this.responseTimes.put(Integer.toString(startIndex), new Long(stop - start));
                ++startIndex;
            }
        }
        this.totalTime = System.currentTimeMillis() - startTime;
        try {
            this.object.shutDown();
        }
        catch (Exception e) {
            StringWriter errorWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(errorWriter));
            throw new BuildException("Failed to shutdown:" + errorWriter.toString());
        }
        this.dumpLog();
        if (!this.errors.isEmpty()) {
            throw new BuildException("Error(s) encountered view log file: " + this.logFileName + " for details");
        }
    }

    public void setThreads(int threads) throws BuildException {
        this.numThreads = threads;
    }

    public void setRepeats(int repeats) throws BuildException {
        this.repeats = repeats;
    }

    public void setProcesses(int processes) throws BuildException {
        this.numProcesses = processes;
    }

    public void setConcurrent(boolean concurrent) throws BuildException {
        this.concurrent = concurrent;
    }

    public void setClassname(String className) throws BuildException {
        this.logFileName = this.logFileName + "-" + className.replace('.', '-') + ".xml";
        this.redirectClass = className;
        super.setClassname(this.getClass().getName());
    }

    public void run() {
        try {
            long start = System.currentTimeMillis();
            int i = 0;
            while (i < this.repeats) {
                this.runJavaStress();
                ++i;
            }
            long stop = System.currentTimeMillis();
            this.responseTimes.put(Thread.currentThread().getName(), new Long(stop - start));
            this.object.postRun();
        }
        catch (Exception e) {
            this.errors.put(Thread.currentThread().getName(), e);
            this.responseTimes.put(Thread.currentThread().getName(), new Long(-1L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpLog() throws BuildException {
        Document doc = null;
        try {
            doc = XMLUtils.newDocument();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException(e.getMessage());
        }
        Element root = doc.createElement("threads");
        doc.appendChild(root);
        long totalCallTime = 0L;
        Enumeration enumeration = this.responseTimes.keys();
        while (enumeration.hasMoreElements()) {
            String thread = (String)enumeration.nextElement();
            Long value = (Long)this.responseTimes.get(thread);
            totalCallTime += value.longValue();
            Element threadElement = doc.createElement("thread");
            threadElement.setAttribute("id", thread);
            threadElement.setAttribute("time", value.toString());
            threadElement.setAttribute("repeats", "" + this.repeats);
            threadElement.setAttribute("runtime", "" + value / (long)this.repeats);
            Exception error = (Exception)this.errors.get(thread);
            if (error != null) {
                Element errorElement = doc.createElement("error");
                StringWriter errorWriter = new StringWriter();
                error.printStackTrace(new PrintWriter(errorWriter));
                errorElement.appendChild(doc.createTextNode(errorWriter.toString()));
                threadElement.appendChild(errorElement);
            }
            root.appendChild(threadElement);
        }
        root.setAttribute("totalTime", Long.toString(this.totalTime));
        if (this.totalTime > 0L) {
            root.setAttribute("totalAverageTime", Long.toString(this.totalTime / (long)this.numThreads));
        }
        root.setAttribute("totalCallTime", Long.toString(totalCallTime));
        if (totalCallTime > 0L) {
            root.setAttribute("totalCallAverageTime", Long.toString(totalCallTime / (long)this.numThreads));
        }
        FileOutputStream file = null;
        try {
            this.logFileName = "" + this.procid + "-" + this.logFileName;
            file = new FileOutputStream(this.logFileName);
            XMLUtils.DocumentToStream((Document)doc, (OutputStream)file);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (Exception ce) {
                    System.err.println(ce);
                }
            }
        }
        System.out.println("Dumped log to: " + this.logFileName);
    }

    public static void main(String[] args) throws Exception {
        JavaStress javaStress = new JavaStress(args);
        javaStress.executeJavaStress();
    }

    private void runJavaStress() throws Exception {
        this.object.run();
    }
}

