/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.tools.utils;

import java.io.File;
import java.io.IOException;
import org.globus.ogsa.tools.utils.SchemaDirectory;

public class RuntimeDirectoryUtil {
    public static final String RUNTIME_DIR = System.getProperty("user.dir") + System.getProperty("file.separator");
    public static final String CODE_GEN_DIR = "generated files";
    private static File codeGenDir = null;
    private static SchemaDirectory schemaDir = null;
    private static final char[] pkgSeparators = new char[]{'.', ':'};
    private static final char javaPkgSeparator = pkgSeparators[0];

    public static void createCodeGenDir(String output_dir_opt) {
        File outputDir;
        codeGenDir = output_dir_opt == null ? new File(RUNTIME_DIR, CODE_GEN_DIR) : ((outputDir = new File(output_dir_opt)).isAbsolute() ? outputDir : new File(RUNTIME_DIR, output_dir_opt));
        if (!codeGenDir.exists()) {
            codeGenDir.mkdirs();
        }
        try {
            String sd = codeGenDir.getCanonicalPath() + System.getProperty("file.separator") + "schema";
            schemaDir = new SchemaDirectory(sd);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void switchToRuntimeDir() {
        System.setProperty("user.dir", RUNTIME_DIR);
    }

    public static void switchToCodeGenDir(String output_dir_opt) throws IOException {
        if (codeGenDir == null || !codeGenDir.exists()) {
            RuntimeDirectoryUtil.createCodeGenDir(output_dir_opt);
        }
        System.setProperty("user.dir", codeGenDir.getCanonicalPath());
    }

    public static String getCodeGenDir() throws IOException {
        return codeGenDir.getCanonicalPath();
    }

    public static String getSchemaDir() throws IOException {
        return schemaDir.getCanonicalPath();
    }

    public static SchemaDirectory getSchemaDirectory() {
        return schemaDir;
    }

    public static String normalizePackageName(String pkg, char separator) {
        int i = 0;
        while (i < pkgSeparators.length) {
            pkg = pkg.replace(pkgSeparators[i], separator);
            ++i;
        }
        return pkg;
    }

    public static String toDir(String pkg) {
        if (pkg != null) {
            pkg = RuntimeDirectoryUtil.normalizePackageName(pkg, File.separatorChar);
        }
        return pkg == null ? "" : pkg + File.separatorChar;
    }
}

