/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.tools.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.wsdl.toJava.Utils;
import org.globus.ogsa.tools.utils.ResourceBundleUtil;
import org.globus.ogsa.tools.utils.RuntimeDirectoryUtil;
import org.globus.ogsa.tools.wsdl.RelativePathUtil;
import org.w3c.dom.Document;

public class SchemaDirectory
extends File {
    public static final String SCHEMA_DIR = "schema";
    public static String DEFAULT_SUBDIR = "services";
    protected String schemaSubDir = DEFAULT_SUBDIR;
    public static final String SCHEMA_ROOT = SchemaDirectory.getSchemaRoot();
    public static final String OGSI_GWSDL_FILE_RELATIVE_PATH = "/ogsi/ogsi.gwsdl";
    public static final String OGSI_GWSDL_FILE = SCHEMA_ROOT + "/ogsi/ogsi.gwsdl";
    public static final String FACTORY_SERVICE_WSDL_FILE_RELATIVE_PATH = "/ogsi/ogsi_factory_service.wsdl";
    public static final String FACTORY_SERVICE_WSDL_FILE = SCHEMA_ROOT + "/ogsi/ogsi_factory_service.wsdl";
    public static final String NOTIFICATION_FACTORY_SERVICE_WSDL_FILE_RELATIVE_PATH = "/ogsi/ogsi_notification_factory_service.wsdl";
    public static final String NOTIFICATION_FACTORY_SERVICE_WSDL_FILE = SCHEMA_ROOT + "/ogsi/ogsi_factory_service.wsdl";

    public static String getSchemaRoot() {
        if (System.getProperty("OGSI_TOOL_BASE") == null) {
            return SCHEMA_DIR;
        }
        String ogsiToolBaseDir = System.getProperty("OGSI_TOOL_BASE").replace(File.separatorChar, '/');
        if (!ogsiToolBaseDir.endsWith("/")) {
            ogsiToolBaseDir = ogsiToolBaseDir + "/";
        }
        return ogsiToolBaseDir + SCHEMA_DIR;
    }

    public SchemaDirectory(String schemaLoc) throws IOException {
        super(schemaLoc);
        if (!super.isAbsolute()) {
            throw new IOException(ResourceBundleUtil.getMessage("slNotAbsolute"));
        }
        if (!super.getName().equals(SCHEMA_DIR)) {
            throw new IOException(ResourceBundleUtil.getMessage("slNotValid"));
        }
        if (!super.exists()) {
            super.mkdirs();
        }
        if (!super.isDirectory()) {
            throw new IOException(ResourceBundleUtil.getMessage("slNotDir"));
        }
    }

    public void setSchemaSubDir(String ssd) {
        this.schemaSubDir = ssd;
    }

    public String getSchemaSubDir() {
        return this.schemaSubDir;
    }

    public String getSchemaPath(File wsdlFile) throws Exception {
        if (!wsdlFile.isFile()) {
            throw new IOException(ResourceBundleUtil.getMessage("notFile", wsdlFile.getCanonicalPath()));
        }
        WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        Definition def = reader.readWSDL(wsdlFile.getCanonicalPath());
        String sourcePkg = Utils.makePackageName((String)def.getTargetNamespace());
        String sourceDir = RuntimeDirectoryUtil.toDir(sourcePkg);
        File candidateFile = new File(this.getCanonicalPath() + File.separator + this.schemaSubDir, sourceDir + wsdlFile.getName());
        return candidateFile.getParent();
    }

    public String getSchemaPath(String pkg, String wsdlFilename) throws Exception {
        File path;
        StringBuffer returnPath = new StringBuffer(this.getCanonicalPath() + File.separator + this.schemaSubDir + File.separator);
        if (pkg != null) {
            returnPath.append(RuntimeDirectoryUtil.toDir(pkg));
        }
        if (!(path = new File(returnPath.toString())).exists()) {
            path.mkdirs();
        }
        returnPath.append(wsdlFilename);
        return returnPath.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addWsdlFile(File sourceFile, boolean includeImports) throws Exception {
        if (!sourceFile.isFile()) {
            throw new IOException(ResourceBundleUtil.getMessage("notFile", sourceFile.getCanonicalPath()));
        }
        FileOutputStream fos = null;
        try {
            Map imports;
            WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
            reader.setFeature("javax.wsdl.verbose", false);
            Definition def = reader.readWSDL(sourceFile.getCanonicalPath());
            String sourcePkg = Utils.makePackageName((String)def.getTargetNamespace());
            String sourceDir = RuntimeDirectoryUtil.toDir(sourcePkg);
            File targetFile = new File(this.getCanonicalPath() + File.separator + this.schemaSubDir, sourceDir + sourceFile.getName());
            if (includeImports && !(imports = def.getImports()).isEmpty()) {
                Iterator iImportLists = imports.values().iterator();
                while (iImportLists.hasNext()) {
                    Collection impList = (Collection)iImportLists.next();
                    Iterator iImport = impList.iterator();
                    while (iImport.hasNext()) {
                        Import imp = (Import)iImport.next();
                        String location = imp.getLocationURI();
                        File importedFile = new File(sourceFile.getParent(), location);
                        this.addWsdlFile(importedFile, true);
                        String newLocation = importedFile.getName();
                        if (newLocation.equals(location)) continue;
                        imp.setLocationURI(newLocation);
                    }
                }
            }
            if (!targetFile.getParentFile().exists()) {
                targetFile.getParentFile().mkdirs();
            }
            if (!targetFile.createNewFile()) {
                // empty if block
            }
            WSDLWriter writer = WSDLFactory.newInstance().newWSDLWriter();
            Document doc = writer.getDocument(def);
            fos = new FileOutputStream(targetFile);
            XMLUtils.PrettyDocumentToStream((Document)doc, (OutputStream)fos);
            Object var18_18 = null;
            if (fos == null) return;
        }
        catch (Throwable throwable) {
            Object var18_19 = null;
            if (fos == null) throw throwable;
            try {
                fos.close();
                throw throwable;
            }
            catch (Exception io) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception io) {}
        fos.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addAndUpdateWsdlFile(File sourceFile, boolean includeImports) throws Exception {
        if (!sourceFile.isFile()) {
            throw new IOException(ResourceBundleUtil.getMessage("notFile", sourceFile.getCanonicalPath()));
        }
        FileOutputStream fos = null;
        try {
            Map imports;
            WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
            reader.setFeature("javax.wsdl.verbose", false);
            Definition def = reader.readWSDL(sourceFile.getCanonicalPath());
            String sourcePkg = Utils.makePackageName((String)def.getTargetNamespace());
            String sourceDir = RuntimeDirectoryUtil.toDir(sourcePkg);
            File targetFile = new File(this.getCanonicalPath() + File.separator + this.schemaSubDir, sourceDir + sourceFile.getName());
            if (includeImports && !(imports = def.getImports()).isEmpty()) {
                Iterator iImportLists = imports.values().iterator();
                while (iImportLists.hasNext()) {
                    Collection impList = (Collection)iImportLists.next();
                    Iterator iImport = impList.iterator();
                    while (iImport.hasNext()) {
                        Import imp = (Import)iImport.next();
                        String location = imp.getLocationURI();
                        File importedFile = new File(sourceFile.getParent(), location);
                        String temp = RelativePathUtil.getRelativeFileName(importedFile, targetFile);
                        imp.setLocationURI(temp);
                    }
                }
            }
            if (!targetFile.getParentFile().exists()) {
                targetFile.getParentFile().mkdirs();
            }
            if (!targetFile.createNewFile()) {
                // empty if block
            }
            WSDLWriter writer = WSDLFactory.newInstance().newWSDLWriter();
            Document doc = writer.getDocument(def);
            fos = new FileOutputStream(targetFile);
            XMLUtils.PrettyDocumentToStream((Document)doc, (OutputStream)fos);
            Object var18_18 = null;
            if (fos == null) return;
        }
        catch (Throwable throwable) {
            Object var18_19 = null;
            if (fos == null) throw throwable;
            try {
                fos.close();
                throw throwable;
            }
            catch (Exception io) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception io) {}
        fos.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateImports(File targetFile, File currentSchemaDirectory) throws Exception {
        if (!targetFile.isFile()) {
            throw new IOException(ResourceBundleUtil.getMessage("notFile", targetFile.getCanonicalPath()));
        }
        if (!currentSchemaDirectory.isDirectory()) {
            throw new IOException(ResourceBundleUtil.getMessage("csdNotDir"));
        }
        if (!currentSchemaDirectory.getName().equals(SCHEMA_DIR)) {
            throw new IOException(ResourceBundleUtil.getMessage("csdNotValid"));
        }
        boolean importChanged = false;
        FileOutputStream fos = null;
        try {
            String relativeCurSchemaDirStr = RelativePathUtil.getRelativeFileName(currentSchemaDirectory, targetFile.getParentFile());
            String relativeCurrSchemaDir = relativeCurSchemaDirStr.substring(0, relativeCurSchemaDirStr.lastIndexOf("/"));
            String relativeNewSchemaDirStr = RelativePathUtil.getRelativeFileName(this, targetFile.getParentFile());
            String relativeNewSchemaDir = relativeNewSchemaDirStr.substring(0, relativeNewSchemaDirStr.lastIndexOf("/"));
            WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
            reader.setFeature("javax.wsdl.verbose", false);
            Definition def = reader.readWSDL(targetFile.getCanonicalPath());
            Map imports = def.getImports();
            if (!imports.isEmpty()) {
                Iterator iImportLists = imports.values().iterator();
                while (iImportLists.hasNext()) {
                    Collection impList = (Collection)iImportLists.next();
                    Iterator iImport = impList.iterator();
                    while (iImport.hasNext()) {
                        Import imp = (Import)iImport.next();
                        String location = imp.getLocationURI();
                        if (!location.startsWith(relativeCurrSchemaDir)) continue;
                        location = relativeNewSchemaDir + location.substring(relativeCurrSchemaDir.length());
                        imp.setLocationURI(location);
                        importChanged = true;
                    }
                }
            }
            if (importChanged) {
                WSDLWriter writer = WSDLFactory.newInstance().newWSDLWriter();
                Document doc = writer.getDocument(def);
                fos = new FileOutputStream(targetFile);
                XMLUtils.PrettyDocumentToStream((Document)doc, (OutputStream)fos);
            }
            Object var18_18 = null;
            if (fos == null) return;
        }
        catch (Throwable throwable) {
            Object var18_19 = null;
            if (fos == null) throw throwable;
            try {
                fos.close();
                throw throwable;
            }
            catch (Exception io) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception io) {}
        fos.close();
        return;
    }

    public String getRelativeSchemaSubDir() {
        return SCHEMA_DIR + System.getProperty("file.separator") + this.schemaSubDir;
    }

    public static File getIntfWsdlFile(File sourceFile) throws Exception {
        if (!sourceFile.isFile()) {
            throw new IOException(ResourceBundleUtil.getMessage("notFile", sourceFile.getCanonicalPath()));
        }
        String portTypeNS = null;
        WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        Definition def = reader.readWSDL(sourceFile.getCanonicalPath());
        Map imports = def.getImports();
        Map portTypes = def.getPortTypes();
        if (!portTypes.isEmpty()) {
            return sourceFile;
        }
        if (imports.isEmpty()) {
            throw new WSDLException("PARSER_ERROR", ResourceBundleUtil.getMessage("noWSDLintf", sourceFile.getCanonicalPath()));
        }
        Import imp = null;
        Map bindings = def.getBindings();
        if (!bindings.isEmpty()) {
            Binding binding = (Binding)bindings.values().iterator().next();
            portTypeNS = binding.getPortType().getQName().getNamespaceURI();
            List importList = (List)imports.get(portTypeNS);
            imp = (Import)importList.get(0);
        } else {
            Map services = def.getServices();
            if (services.isEmpty()) {
                throw new WSDLException("PARSER_ERROR", ResourceBundleUtil.getMessage("noSBPT", sourceFile.getCanonicalPath()));
            }
            Service service = (Service)services.values().iterator().next();
            Map ports = service.getPorts();
            if (ports.isEmpty()) {
                throw new WSDLException("PARSER_ERROR", ResourceBundleUtil.getMessage("noSP", sourceFile.getCanonicalPath()));
            }
            Port port = (Port)ports.values().iterator().next();
            Binding portBinding = port.getBinding();
            portTypeNS = portBinding.getPortType().getQName().getNamespaceURI();
            List importList = (List)imports.get(portTypeNS);
            if (importList != null && !importList.isEmpty()) {
                imp = (Import)importList.get(0);
            } else {
                String bindingNS = portBinding.getQName().getNamespaceURI();
                importList = (List)imports.get(bindingNS);
                if (importList != null && !importList.isEmpty()) {
                    imp = (Import)importList.get(0);
                    return SchemaDirectory.getIntfWsdlFile(new File(sourceFile.getParent(), imp.getLocationURI()));
                }
                throw new WSDLException("PARSER_ERROR", ResourceBundleUtil.getMessage("noWSDLbinding", sourceFile.getCanonicalPath()));
            }
        }
        return new File(sourceFile.getParent(), imp.getLocationURI());
    }
}

