/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.tools.wsdl;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Service;
import org.apache.axis.utils.CLArgsParser;
import org.apache.axis.utils.CLOption;
import org.apache.axis.utils.CLOptionDescriptor;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.gen.Parser;
import org.apache.axis.wsdl.gen.WSDL2;
import org.apache.axis.wsdl.toJava.Emitter;
import org.globus.ogsa.tools.CommandLineTool;
import org.globus.ogsa.tools.utils.MessagePrintingUtil;
import org.globus.ogsa.tools.utils.ResourceBundleUtil;
import org.globus.ogsa.tools.utils.RuntimeDirectoryUtil;
import org.globus.ogsa.tools.utils.SchemaDirectory;
import org.globus.ogsa.tools.utils.wsdl.FlattenedWSDLDefinition;
import org.globus.ogsa.tools.utils.wsdl.FlattenedWSDLReader;
import org.globus.ogsa.tools.wsdl.toJava.JavaGridServiceDeployWriter;

public class FlattenedWSDL2WSDD
extends WSDL2 {
    private HashMap namespaceMap = null;
    private String namespaceFile = null;
    private String namespaceGlobal = null;
    private Emitter m_toJavaEmitter;
    private String m_output_dir = null;
    private boolean m_persistent = false;
    private Properties globalProperties = null;
    private Properties serviceDeployProperties = null;
    private Vector orderedListOfHandlers = null;
    private Map namesapceTbl = null;
    private boolean bGenerateWSDDGlobalInformation = false;
    private boolean m_parserRan = false;
    private static final CLOptionDescriptor[] wsdl2wsddOptions = new CLOptionDescriptor[]{new CLOptionDescriptor("output", 2, 111, Messages.getMessage((String)"optionOutput00")), new CLOptionDescriptor("all", 8, 97, Messages.getMessage((String)"optionAll00")), new CLOptionDescriptor("persistent", 8, 101, ResourceBundleUtil.getMessage("persistent")), new CLOptionDescriptor("namespace file", 2, 102, Messages.getMessage((String)"optionFileNStoPkg00")), new CLOptionDescriptor("namespace override", 34, 78, Messages.getMessage((String)"j2woptnamespaceImpl00")), new CLOptionDescriptor("global namespace", 2, 112, Messages.getMessage((String)"j2woptPkgtoNS00"))};

    public FlattenedWSDL2WSDD(Emitter emit) {
        this.m_toJavaEmitter = emit;
        this.parser = this.m_toJavaEmitter;
        this.m_parserRan = true;
        this.addOptions(wsdl2wsddOptions);
        try {
            this.init();
        }
        catch (Exception e) {
            MessagePrintingUtil.info(this.parser.isVerbose(), e + this.m_toJavaEmitter.getOutputDir());
        }
    }

    public FlattenedWSDL2WSDD() {
        this.m_toJavaEmitter = (Emitter)this.parser;
        this.addOptions(wsdl2wsddOptions);
        if (this.namespaceMap != null) {
            this.m_toJavaEmitter.setNamespaceMap(this.namespaceMap);
        } else if (this.namespaceFile != null) {
            this.m_toJavaEmitter.setNStoPkg(this.namespaceFile);
        } else if (this.namespaceGlobal != null) {
            this.m_toJavaEmitter.setPackageName(this.namespaceGlobal);
        } else {
            String nsToPkgMapFileName = SchemaDirectory.getSchemaRoot() + "/NStoPkg.properties";
            this.m_toJavaEmitter.setNStoPkg(nsToPkgMapFileName);
        }
        try {
            this.init();
        }
        catch (Exception e) {
            MessagePrintingUtil.info(this.parser.isVerbose(), e + this.m_toJavaEmitter.getOutputDir());
        }
    }

    private void init() throws Exception {
        this.globalProperties = new Properties();
        this.globalProperties.put("adminPassword", "admin");
        this.globalProperties.put("sendMultiRefs", "true");
        this.globalProperties.put("sendXsiTypes", "true");
        this.globalProperties.put("sendXMLDeclaration", "true");
        this.globalProperties.put("containerThreads", "5");
        this.globalProperties.put("sweeperThreads", "3");
        this.globalProperties.put("notificationFactory", "ogsi/NotificationSubscriptionFactoryService");
        this.serviceDeployProperties = new Properties();
        this.orderedListOfHandlers = new Vector();
        this.orderedListOfHandlers.addElement("URLMapper");
        this.orderedListOfHandlers.addElement("HandleResolverHandler");
        this.orderedListOfHandlers.addElement("JWSHandler");
        this.orderedListOfHandlers.addElement("PersistentServiceHandler");
        this.orderedListOfHandlers.addElement("OnceInvocationHandler");
        this.namesapceTbl = new HashMap();
        this.namesapceTbl.put("http://ogsa.globus.org/security/authentication/types", "auth-types");
        this.namesapceTbl.put("http://xml.apache.org/axis/wsdd/providers/java", "java");
        this.namesapceTbl.put("http://www.gridforum.org/namespaces/2002/10/gridServices", "gsdl");
        this.namesapceTbl.put("http://ogsa.globus.org/types/notification", "globus-notification");
        this.namesapceTbl.put("http://ogsa.globus.org/types/properties", "globus-properties");
        this.namesapceTbl.put("http://www.w3.org/2001/XMLSchema", "xsd");
        this.m_toJavaEmitter.setServerSide(true);
    }

    protected Parser createParser() {
        return new Emitter();
    }

    public Parser getParser() {
        return this.m_toJavaEmitter;
    }

    protected void parseOption(CLOption option) {
        switch (option.getId()) {
            case 111: {
                this.m_output_dir = option.getArgument();
                break;
            }
            case 97: {
                this.m_toJavaEmitter.setAllWanted(true);
                break;
            }
            case 101: {
                this.m_persistent = true;
                break;
            }
            case 102: {
                this.namespaceFile = option.getArgument();
                break;
            }
            case 78: {
                if (this.namespaceMap == null) {
                    this.namespaceMap = new HashMap();
                }
                String temp = option.getArgument();
                String namespace = temp.substring(0, temp.indexOf(61));
                String packageName = temp.substring(temp.indexOf(61) + 1);
                this.namespaceMap.put(namespace, packageName);
                break;
            }
            case 112: {
                this.namespaceGlobal = option.getArgument();
                break;
            }
            default: {
                super.parseOption(option);
            }
        }
    }

    private void parseArgs(String[] args) throws Exception {
        CLArgsParser argsParser = new CLArgsParser(args, this.options);
        if (null != argsParser.getErrorString()) {
            System.err.println(Messages.getMessage((String)"error01", (String)argsParser.getErrorString()));
            this.printUsage();
        }
        Vector clOptions = argsParser.getArguments();
        int size = clOptions.size();
        int i = 0;
        while (i < size) {
            this.parseOption((CLOption)clOptions.get(i));
            ++i;
        }
        this.validateOptions();
        this.wsdlURI = this.wsdlURI.replace('\\', '/');
    }

    private void writeDeploymentDescriptor() throws Exception {
        boolean bServiceIsPersistent = this.m_persistent;
        boolean bPersistent = true;
        String fullClassName = null;
        String type = null;
        File intfWsdl = SchemaDirectory.getIntfWsdlFile(new File(this.wsdlURI));
        FlattenedWSDLDefinition flatDef = new FlattenedWSDLDefinition(new FlattenedWSDLReader().readWSDL(intfWsdl.getCanonicalPath()));
        if (bServiceIsPersistent) {
            type = "ProviderService";
        } else {
            type = "ProviderFactoryService";
            this.setInstanceProperties(flatDef);
        }
        this.setPersistentProperties(flatDef);
        this.m_toJavaEmitter.setServerSide(true);
        Definition def = this.parser.getCurrentDefinition();
        Collection services = def.getServices().values();
        if (services.isEmpty()) {
            throw new Exception(ResourceBundleUtil.getMessage("noServiceElt"));
        }
        Service service = (Service)services.iterator().next();
        JavaGridServiceDeployWriter jdw = new JavaGridServiceDeployWriter((Emitter)this.parser, def, this.m_toJavaEmitter.getSymbolTable(), fullClassName, type, service, this.globalProperties, this.orderedListOfHandlers, this.serviceDeployProperties, this.namesapceTbl, this.bGenerateWSDDGlobalInformation, false);
        jdw.generate();
        this.globalProperties.clear();
        this.orderedListOfHandlers.clear();
        this.serviceDeployProperties.clear();
        JavaGridServiceDeployWriter jcdw = new JavaGridServiceDeployWriter((Emitter)this.parser, def, this.m_toJavaEmitter.getSymbolTable(), fullClassName, type, service, this.globalProperties, this.orderedListOfHandlers, this.serviceDeployProperties, this.namesapceTbl, this.bGenerateWSDDGlobalInformation, true);
        jcdw.generate();
    }

    public void setInstanceProperties(FlattenedWSDLDefinition def) throws Exception {
        String schemaSubDir = RuntimeDirectoryUtil.getSchemaDirectory().getRelativeSchemaSubDir().replace('\\', '/');
        this.serviceDeployProperties.put("instance-name", def.getGridServiceName() + " Provider");
        this.serviceDeployProperties.put("instance-baseClassName", "org.globus.ogsa.impl.ogsi.GridServiceImpl");
        String nameFromWsdl = def.getRawPortTypeClassName();
        String nameOverride = this.checkForNamespaceOverrides(nameFromWsdl);
        if (nameOverride == nameFromWsdl) {
            this.serviceDeployProperties.put("instance-className", def.getPortTypeClassName());
        } else {
            this.serviceDeployProperties.put("instance-className", nameOverride);
        }
        this.serviceDeployProperties.put("instance-schemaPath", this.wsdlURI.substring(this.wsdlURI.lastIndexOf(schemaSubDir)));
        this.serviceDeployProperties.put("instance-operationProviders", this.getInstanceOperationProviders(def));
    }

    public String checkForNamespaceOverrides(String checkFor) {
        String copy = checkFor;
        String className = copy.substring(copy.lastIndexOf(46) + 1);
        String namespace = copy.substring(0, copy.lastIndexOf(46));
        if (this.m_toJavaEmitter.getNamespaces().containsKey((Object)namespace)) {
            String temp = this.m_toJavaEmitter.getNamespaces().get((Object)namespace).toString();
            return temp + '.' + className;
        }
        if (this.m_toJavaEmitter.getNamespaceMap().containsKey(namespace)) {
            String temp = this.m_toJavaEmitter.getNamespaceMap().get(namespace).toString();
            return temp + '.' + className;
        }
        return checkFor;
    }

    public String getInstanceOperationProviders(FlattenedWSDLDefinition def) throws Exception {
        StringBuffer providers = new StringBuffer();
        String nameFromWsdl = def.getRawDelegatorClassName();
        String nameOverride = this.checkForNamespaceOverrides(nameFromWsdl);
        if (nameOverride == nameFromWsdl) {
            providers.append(def.getDelegatorClassName()).append(" ");
        } else {
            nameOverride = nameOverride + "Provider";
            providers.append(nameOverride).append(" ");
        }
        if (def.hasNotificationSource()) {
            providers.append(System.getProperty("NOTIFICATION_SOURCE_PROVIDER")).append(" ");
        }
        if (def.hasFactory()) {
            providers.append("org.globus.ogsa.impl.ogsi.FactoryProvider ");
        }
        if (def.hasServiceGroup()) {
            providers.append("org.globus.ogsa.impl.ogsi.ServiceGroupProvider ");
        }
        if (def.hasServiceGroupRegistration()) {
            providers.append("org.globus.ogsa.impl.ogsi.ServiceGroupRegistrationProvider ");
        }
        return providers.toString();
    }

    public void setPersistentProperties(FlattenedWSDLDefinition def) throws Exception {
        String schemaSubDir = RuntimeDirectoryUtil.getSchemaDirectory().getRelativeSchemaSubDir().replace('\\', '/');
        if (this.m_persistent) {
            this.serviceDeployProperties.put("name", def.getGridServiceName() + " Provider");
            this.serviceDeployProperties.put("schemaPath", this.wsdlURI.substring(this.wsdlURI.lastIndexOf(schemaSubDir)));
            this.serviceDeployProperties.put("className", def.getPortTypeClassName());
        } else {
            this.serviceDeployProperties.put("name", def.getGridServiceName() + " Provider Factory");
            if (def.hasNotificationSource()) {
                this.serviceDeployProperties.put("schemaPath", "schema/ogsi/ogsi_notification_factory_service.wsdl");
                this.serviceDeployProperties.put("className", "org.gridforum.ogsi.NotificationFactory");
            } else {
                this.serviceDeployProperties.put("schemaPath", "schema/ogsi/ogsi_factory_service.wsdl");
                this.serviceDeployProperties.put("className", "org.gridforum.ogsi.Factory");
            }
        }
        this.serviceDeployProperties.put("operationProviders", this.getOperationProviders(def));
    }

    public String getOperationProviders(FlattenedWSDLDefinition def) throws Exception {
        StringBuffer providers = new StringBuffer();
        if (this.m_persistent) {
            providers.append(def.getDelegatorClassName()).append(" ");
            if (def.hasFactory()) {
                providers.append("org.globus.ogsa.impl.ogsi.FactoryProvider ");
            }
            if (def.hasHandleResolver()) {
                providers.append("org.globus.ogsa.impl.ogsi.HandleResolverProvider ");
            }
            if (def.hasServiceGroup()) {
                providers.append("org.globus.ogsa.impl.ogsi.ServiceGroupProvider ");
            }
            if (def.hasServiceGroupRegistration()) {
                providers.append("org.globus.ogsa.impl.ogsi.ServiceGroupRegistrationProvider ");
            }
        } else {
            providers.append("org.globus.ogsa.impl.ogsi.FactoryProvider ");
        }
        if (def.hasNotificationSource()) {
            providers.append(System.getProperty("NOTIFICATION_SOURCE_PROVIDER")).append(" ");
        }
        return providers.toString().trim();
    }

    public void run(String[] args) {
        try {
            this.parseArgs(args);
            RuntimeDirectoryUtil.createCodeGenDir(this.m_output_dir);
            this.m_toJavaEmitter.setOutputDir(RuntimeDirectoryUtil.getCodeGenDir());
            if (!this.m_parserRan) {
                MessagePrintingUtil.info(this.parser.isVerbose(), ResourceBundleUtil.getMessage("emitting", this.m_toJavaEmitter.getOutputDir()));
                this.parser.run(this.wsdlURI);
            }
            this.writeDeploymentDescriptor();
        }
        catch (Exception e) {
            MessagePrintingUtil.error(e.getMessage());
            e.printStackTrace();
            CommandLineTool.sysExit(1);
        }
    }

    public static void main(String[] args) {
        FlattenedWSDL2WSDD gsdl2Wsdd = new FlattenedWSDL2WSDD();
        gsdl2Wsdd.run(args);
    }
}

