/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.tools.wsdl;

import com.ibm.wsdl.ImportImpl;
import com.ibm.wsdl.xml.WSDLReaderImpl;
import com.ibm.wsdl.xml.WSDLWriterImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.utils.CLArgsParser;
import org.apache.axis.utils.CLOption;
import org.apache.axis.utils.CLOptionDescriptor;
import org.apache.axis.utils.CLUtil;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.wsdl.Java2WSDL;
import org.apache.axis.wsdl.fromJava.Namespaces;
import org.apache.axis.wsdl.toJava.Utils;
import org.globus.ogsa.tools.CommandLineTool;
import org.globus.ogsa.tools.utils.MessagePrintingUtil;
import org.globus.ogsa.tools.utils.ResourceBundleUtil;
import org.globus.ogsa.tools.utils.RuntimeDirectoryUtil;
import org.globus.ogsa.tools.utils.SchemaDirectory;
import org.globus.ogsa.tools.wsdl.GWSDL2WSDL;
import org.globus.ogsa.tools.wsdl.GenerateBinding;
import org.globus.ogsa.tools.wsdl.RelativePathUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Java2FlattenedWSDL
extends Java2WSDL {
    private static final CLOptionDescriptor[] j2wOptions = new CLOptionDescriptor[]{new CLOptionDescriptor("help", 8, 104, Messages.getMessage((String)"j2wopthelp00")), new CLOptionDescriptor("verbose", 8, 118, ResourceBundleUtil.getMessage("verbose")), new CLOptionDescriptor("generatedCodeDir", 2, 111, ResourceBundleUtil.getMessage("generatedCodeDir")), new CLOptionDescriptor("methods", 2, 109, Messages.getMessage((String)"j2woptmethods00")), new CLOptionDescriptor("all", 8, 97, Messages.getMessage((String)"j2woptall00")), new CLOptionDescriptor("exclude", 2, 120, Messages.getMessage((String)"j2woptexclude00")), new CLOptionDescriptor("stopClasses", 2, 99, Messages.getMessage((String)"j2woptstopClass00")), new CLOptionDescriptor("handleResolver", 8, 72, ResourceBundleUtil.getMessage("handleResolver")), new CLOptionDescriptor("notificationSource", 8, 67, ResourceBundleUtil.getMessage("notificationSource")), new CLOptionDescriptor("notificationSink", 8, 75, ResourceBundleUtil.getMessage("notificationSink")), new CLOptionDescriptor("factory", 8, 70, ResourceBundleUtil.getMessage("factory")), new CLOptionDescriptor("serviceGroup", 8, 71, ResourceBundleUtil.getMessage("serviceGroup")), new CLOptionDescriptor("serviceGroupRegistration", 8, 82, ResourceBundleUtil.getMessage("serviceGroupRegistration"))};
    private String m_outputDir = null;
    private boolean m_verbose = false;
    private boolean m_handleResolver = false;
    private boolean m_notificationSource = false;
    private boolean m_notificationSink = false;
    private boolean m_factory = false;
    private boolean m_serviceGroup = false;
    private boolean m_serviceGroupRegistration = false;
    private String m_gwsdlFilename = null;
    static /* synthetic */ Class class$org$globus$ogsa$tools$wsdl$Java2FlattenedWSDL;

    private void createFilenames() throws Exception {
        RuntimeDirectoryUtil.createCodeGenDir(this.m_outputDir);
        SchemaDirectory schemaDir = RuntimeDirectoryUtil.getSchemaDirectory();
        Package pkg = this.emitter.getCls().getPackage();
        String packageName = pkg != null ? pkg.getName() : null;
        this.wsdlFilename = schemaDir.getSchemaPath(packageName, this.className.substring(this.className.lastIndexOf(".") + 1) + ".wsdl");
        this.m_gwsdlFilename = schemaDir.getSchemaPath(packageName, this.className.substring(this.className.lastIndexOf(".") + 1) + ".gwsdl");
        this.wsdlImplFilename = schemaDir.getSchemaPath(packageName, this.className.substring(this.className.lastIndexOf(".") + 1) + "_service.wsdl");
    }

    protected boolean parseOption(CLOption option) {
        int optionVal = option.getId();
        switch (optionVal) {
            case 0: {
                this.className = option.getArgument();
                break;
            }
            case 118: {
                this.m_verbose = true;
                break;
            }
            case 72: {
                this.m_handleResolver = true;
                break;
            }
            case 67: {
                this.m_notificationSource = true;
                break;
            }
            case 75: {
                this.m_notificationSink = true;
                break;
            }
            case 70: {
                this.m_factory = true;
                break;
            }
            case 71: {
                this.m_serviceGroup = true;
                break;
            }
            case 82: {
                this.m_serviceGroupRegistration = true;
                break;
            }
            case 111: {
                this.m_outputDir = option.getArgument();
                break;
            }
            case 109: {
                this.emitter.setAllowedMethods(option.getArgument());
                break;
            }
            case 97: {
                this.emitter.setUseInheritedMethods(true);
                break;
            }
            case 120: {
                this.emitter.setDisallowedMethods(option.getArgument());
                break;
            }
            case 99: {
                this.emitter.setStopClasses(option.getArgument());
                break;
            }
            default: {
                this.usage();
            }
        }
        return true;
    }

    private void parseArgs(String[] args) throws Exception {
        CLArgsParser parser = new CLArgsParser(args, j2wOptions);
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        int i = 0;
        while (i < size) {
            CLOption curOption = (CLOption)clOptions.get(i);
            this.parseOption(curOption);
            ++i;
        }
        try {
            this.emitter.setCls(this.className);
        }
        catch (ClassNotFoundException c) {
            MessagePrintingUtil.error(ResourceBundleUtil.getMessage("noCOPT", c.getMessage()));
            CommandLineTool.sysExit(1);
        }
    }

    private String getExtendsText() {
        StringBuffer extendsBuf = new StringBuffer();
        if (this.m_handleResolver) {
            extendsBuf.append("ogsi:HandleResolver ");
        }
        if (this.m_notificationSource) {
            extendsBuf.append("ogsi:NotificationSource ");
        }
        if (this.m_factory) {
            extendsBuf.append("ogsi:Factory ");
        }
        if (this.m_serviceGroupRegistration) {
            extendsBuf.append("ogsi:ServiceGroupRegistration ");
        } else if (this.m_serviceGroup) {
            extendsBuf.append("ogsi:ServiceGroup ");
        }
        if (extendsBuf.toString().length() == 0) {
            extendsBuf.append("ogsi:GridService ");
        }
        if (this.m_notificationSink) {
            extendsBuf.append("ogsi:NotificationSink");
        }
        return extendsBuf.toString().trim();
    }

    private void createInterfaceWSDL() throws Exception {
        if (!this.namespaceMap.isEmpty()) {
            this.emitter.setNamespaceMap((Map)this.namespaceMap);
        }
        Package pkg = this.emitter.getCls().getPackage();
        String intfNS = new Namespaces().getCreate(pkg == null ? null : pkg.getName());
        this.emitter.setImplNamespace(intfNS);
        this.emitter.setIntfNamespace(intfNS);
        this.emitter.setStyle("wrapped");
        this.emitter.setUse("literal");
        ServiceDesc desc = new ServiceDesc();
        desc.setImplClass(this.emitter.getCls());
        desc.setDefaultNamespace(intfNS);
        desc.setStopClasses(this.emitter.getStopClasses());
        desc.setAllowedMethods((List)this.emitter.getAllowedMethods());
        desc.setDisallowedMethods((List)this.emitter.getDisallowedMethods());
        desc.setStyle(this.emitter.getStyle());
        this.emitter.setServiceDesc(desc);
        this.emitter.emit(this.m_gwsdlFilename, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void manglePortTypeName() {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            String shortClassName = Utils.getJavaLocalName((String)this.className);
            fis = new FileInputStream(this.m_gwsdlFilename);
            WSDLReaderImpl reader = new WSDLReaderImpl();
            reader.setFeature("javax.wsdl.verbose", this.m_verbose);
            Definition def = reader.readWSDL(null, new InputSource(fis));
            fis.close();
            Map portTypes = def.getPortTypes();
            Collection portTypeCollection = portTypes.values();
            Iterator portTypeIterator = portTypeCollection.iterator();
            boolean found = false;
            while (portTypeIterator.hasNext() && !found) {
                PortType curPortType = (PortType)portTypeIterator.next();
                QName curPortTypeName = curPortType.getQName();
                String localPart = curPortTypeName.getLocalPart();
                String uri = curPortTypeName.getNamespaceURI();
                if (!shortClassName.equals(localPart)) continue;
                QName newPortTypeName = new QName(uri, localPart + "PortType");
                curPortType.setQName(newPortTypeName);
                found = true;
            }
            if (found) {
                fos = new FileOutputStream(this.m_gwsdlFilename);
                WSDLWriterImpl writer = new WSDLWriterImpl();
                writer.writeWSDL(def, (OutputStream)fos);
            }
        }
        catch (Exception e) {
            MessagePrintingUtil.error(e.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception io) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception io) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createInterfaceGWSDL() throws Exception {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(this.m_gwsdlFilename);
            WSDLReaderImpl reader = new WSDLReaderImpl();
            reader.setFeature("javax.wsdl.verbose", this.m_verbose);
            Definition def = reader.readWSDL(null, new InputSource(fis));
            fis.close();
            def.addNamespace("ogsi", "http://www.gridforum.org/namespaces/2003/03/OGSI");
            def.addNamespace("gwsdl", "http://www.gridforum.org/namespaces/2003/03/gridWSDLExtensions");
            def.addNamespace("tns", def.getTargetNamespace());
            ImportImpl ogsiImport = new ImportImpl();
            ogsiImport.setLocationURI(RelativePathUtil.getRelativeFileName(new File(SchemaDirectory.OGSI_GWSDL_FILE), new File(this.m_gwsdlFilename)));
            ogsiImport.setNamespaceURI("http://www.gridforum.org/namespaces/2003/03/OGSI");
            def.addImport((Import)ogsiImport);
            Iterator bindingIterator = def.getBindings().values().iterator();
            while (bindingIterator.hasNext()) {
                Binding b = (Binding)bindingIterator.next();
                def.removeBinding(b.getQName());
            }
            fos = new FileOutputStream(this.m_gwsdlFilename);
            WSDLWriterImpl writer = new WSDLWriterImpl();
            writer.writeWSDL(def, (OutputStream)fos);
            fos.close();
            fis = new FileInputStream(this.m_gwsdlFilename);
            Document doc = XMLUtils.newDocument((InputStream)fis);
            fis.close();
            Element definition = doc.getDocumentElement();
            definition.setAttribute("name", this.className.substring(this.className.lastIndexOf(".") + 1));
            NodeList portTypes = doc.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "portType");
            int i = 0;
            while (i < portTypes.getLength()) {
                Node portType = portTypes.item(i);
                String name = ((Element)portType).getAttribute("name");
                Element newPortType = doc.createElementNS("http://www.gridforum.org/namespaces/2003/03/gridWSDLExtensions", "portType");
                newPortType.setPrefix("gwsdl");
                newPortType.setAttribute("name", name);
                newPortType.setAttribute("extends", this.getExtendsText());
                NodeList portTypeChildren = portType.getChildNodes();
                int j = 0;
                while (j < portTypeChildren.getLength()) {
                    Node portTypeChild = portTypeChildren.item(j);
                    Node newPortTypeChild = portTypeChild.cloneNode(true);
                    newPortType.appendChild(newPortTypeChild);
                    ++j;
                }
                definition.appendChild(newPortType);
                definition.removeChild(portType);
                ++i;
            }
            fos = new FileOutputStream(this.m_gwsdlFilename);
            XMLUtils.DocumentToStream((Document)doc, (OutputStream)fos);
        }
        catch (IOException e) {
            MessagePrintingUtil.error(e.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception io) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception io) {}
            }
        }
    }

    public int run(String[] args) {
        try {
            this.parseArgs(args);
            this.createFilenames();
            this.createInterfaceWSDL();
            this.manglePortTypeName();
            this.createInterfaceGWSDL();
            GWSDL2WSDL.main(new String[]{this.m_gwsdlFilename, this.wsdlFilename});
            GenerateBinding.main(new String[]{this.wsdlFilename, this.wsdlFilename.substring(0, this.wsdlFilename.lastIndexOf("."))});
        }
        catch (Exception e) {
            MessagePrintingUtil.error(e.getMessage());
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public String getWsdlFilename() {
        return this.wsdlFilename;
    }

    public String getWsdlImplFilename() {
        return this.wsdlImplFilename;
    }

    public void usage() {
        String ls = System.getProperty("line.separator");
        StringBuffer usage = new StringBuffer();
        usage.append(ResourceBundleUtil.getMessage("usage")).append("java ").append((class$org$globus$ogsa$tools$wsdl$Java2FlattenedWSDL == null ? (class$org$globus$ogsa$tools$wsdl$Java2FlattenedWSDL = Java2FlattenedWSDL.class$("org.globus.ogsa.tools.wsdl.Java2FlattenedWSDL")) : class$org$globus$ogsa$tools$wsdl$Java2FlattenedWSDL).getName()).append(ResourceBundleUtil.getMessage("Java2FlattenedWSDLCl")).append(ls);
        usage.append(CLUtil.describeOptions((CLOptionDescriptor[])j2wOptions).toString());
        System.out.println(usage.toString());
        CommandLineTool.sysExit(0);
    }

    public static void main(String[] args) {
        Java2FlattenedWSDL j2g = new Java2FlattenedWSDL();
        j2g.run(args);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

