/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.tools.wsdl.toJava;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.apache.axis.Constants;
import org.apache.axis.enum.Scope;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.CollectionTE;
import org.apache.axis.wsdl.symbolTable.Element;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.Namespaces;
import org.apache.axis.wsdl.toJava.Utils;
import org.globus.ogsa.tools.utils.RuntimeDirectoryUtil;
import org.globus.ogsa.tools.utils.wsdl.FlattenedWSDLDefinition;
import org.globus.ogsa.tools.wsdl.toJava.JavaGridServiceDeployConstants;
import org.globus.ogsa.tools.wsdl.toJava.JavaGridServiceDeployFragmentWriter;
import org.w3c.dom.Comment;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JavaGridServiceDeployWriter
extends JavaGridServiceDeployFragmentWriter {
    protected Map globalDeployProperties;
    protected Map serviceDeployProperties;
    protected Vector orderedListOfHanders;
    private Map namesapceTbl = null;
    private Map typeMapTbl = null;
    private boolean bGenerateWSDDGlobalInformation = false;
    private boolean bClientSideWsdd = false;

    public JavaGridServiceDeployWriter(Emitter emitter, Definition definition, SymbolTable symbolTable, String fullClassName, String type, Service service, Map globalDeployProperties, Vector orderedListOfHanders, Map serviceDeployProperties, Map namesapceTbl, boolean generateWSDDGlobalInformation, boolean clientSideWsdd) {
        super(emitter, definition, symbolTable, fullClassName, type, service);
        this.globalDeployProperties = globalDeployProperties;
        this.orderedListOfHanders = orderedListOfHanders;
        this.serviceDeployProperties = serviceDeployProperties;
        this.namesapceTbl = namesapceTbl;
        this.bGenerateWSDDGlobalInformation = generateWSDDGlobalInformation;
        this.bClientSideWsdd = clientSideWsdd;
        this.typeMapTbl = new HashMap();
    }

    protected String getFileName() {
        StringBuffer fileName = new StringBuffer();
        fileName.append(this.emitter.getOutputDir()).append(File.separator);
        if (this.bClientSideWsdd) {
            fileName.append("client-deploy.wsdd");
        } else {
            fileName.append("server-deploy.wsdd");
        }
        return fileName.toString();
    }

    protected void writeFileHeader(PrintWriter pw) throws IOException {
        if (!this.m_wsddDoc.hasChildNodes()) {
            Comment c = this.m_wsddDoc.createComment(this.stripComments(Messages.getMessage((String)"deploy00")));
            this.m_wsddDoc.appendChild(c);
            c = this.m_wsddDoc.createComment(this.stripComments(Messages.getMessage((String)"deploy02")));
            this.m_wsddDoc.appendChild(c);
            c = this.m_wsddDoc.createComment(this.stripComments(Messages.getMessage((String)"deploy03")));
            this.m_wsddDoc.appendChild(c);
            c = this.m_wsddDoc.createComment(this.stripComments(Messages.getMessage((String)"deploy05")));
            this.m_wsddDoc.appendChild(c);
            c = this.m_wsddDoc.createComment(this.stripComments(Messages.getMessage((String)"deploy06")));
            this.m_wsddDoc.appendChild(c);
            c = this.m_wsddDoc.createComment(this.stripComments(Messages.getMessage((String)"deploy07")));
            this.m_wsddDoc.appendChild(c);
            c = this.m_wsddDoc.createComment(this.stripComments(Messages.getMessage((String)"deploy09")));
            this.m_wsddDoc.appendChild(c);
            org.w3c.dom.Element deploymentElt = this.m_wsddDoc.createElement("deployment");
            deploymentElt.setAttribute("xmlns", "http://xml.apache.org/axis/wsdd/");
            deploymentElt.setAttribute("xmlns:java", "http://xml.apache.org/axis/wsdd/providers/java");
            this.m_wsddDoc.appendChild(deploymentElt);
        }
        Map serviceMap = this.definition.getServices();
        Iterator mapIterator = serviceMap.values().iterator();
        while (mapIterator.hasNext()) {
            Service myService = (Service)mapIterator.next();
            Iterator portIterator = myService.getPorts().values().iterator();
            while (portIterator.hasNext()) {
                Port myPort = (Port)portIterator.next();
                BindingEntry bEntry = this.symbolTable.getBindingEntry(myPort.getBinding().getQName());
                if (bEntry.getBindingType() != 0) continue;
                Binding binding = myPort.getBinding();
                boolean hasMIME = Utils.hasMIME((BindingEntry)bEntry);
                Vector types = new Vector();
                types.addAll(this.symbolTable.getElementIndex().values());
                types.addAll(this.symbolTable.getTypeIndex().values());
                if (hasMIME) {
                    QName bQName = binding.getQName();
                    String key = bQName.getNamespaceURI();
                    String value = "dataHandler";
                    if (!this.namesapceTbl.containsKey(key)) {
                        this.namesapceTbl.put(key, value);
                    }
                }
                int uniqueNum = 0;
                int i = 0;
                while (i < types.size()) {
                    String key;
                    TypeEntry type = (TypeEntry)types.elementAt(i);
                    boolean process = true;
                    if (type.getBaseType() != null && type.getRefType() == null || type instanceof CollectionTE || type instanceof Element || !type.isReferenced() || type.isOnlyLiteralReferenced()) {
                        process = false;
                    }
                    if (process && !this.namesapceTbl.containsKey(key = type.getQName().getNamespaceURI())) {
                        StringBuffer value = new StringBuffer().append("ogsatype").append(uniqueNum++);
                        this.namesapceTbl.put(key, value.toString());
                    }
                    ++i;
                }
            }
        }
        org.w3c.dom.Element rootElt = this.m_wsddDoc.getDocumentElement();
        if (rootElt.getTagName().equals("deployment")) {
            Iterator mapIterator2 = this.namesapceTbl.keySet().iterator();
            while (mapIterator2.hasNext()) {
                String key = (String)mapIterator2.next();
                String value = (String)this.namesapceTbl.get(key);
                if (rootElt.hasAttribute("xmlns:" + value)) continue;
                rootElt.setAttribute("xmlns:" + value, key);
            }
        }
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        if (this.bGenerateWSDDGlobalInformation) {
            this.writeGlobalConfiguration(pw);
        }
        this.writeDeployServices(pw);
        if (this.bGenerateWSDDGlobalInformation) {
            this.writeDeployTransport(pw);
        }
        this.writeTypeMapping(pw);
    }

    protected void writeGlobalConfiguration(PrintWriter pw) throws IOException {
        org.w3c.dom.Element rootElt = this.m_wsddDoc.getDocumentElement();
        if (rootElt.getElementsByTagName("globalConfiguration").getLength() == 0) {
            org.w3c.dom.Element globalConfigElt = this.m_wsddDoc.createElement("globalConfiguration");
            rootElt.appendChild(globalConfigElt);
            if (this.globalDeployProperties.size() > 0) {
                Iterator mapIterator = this.globalDeployProperties.keySet().iterator();
                while (mapIterator.hasNext()) {
                    String key = (String)mapIterator.next();
                    String value = (String)this.globalDeployProperties.get(key);
                    org.w3c.dom.Element parmElt = this.m_wsddDoc.createElement("parameter");
                    parmElt.setAttribute("name", key);
                    parmElt.setAttribute("value", value);
                    globalConfigElt.appendChild(parmElt);
                }
            }
            org.w3c.dom.Element requestFlowElt = this.m_wsddDoc.createElement("requestFlow");
            globalConfigElt.appendChild(requestFlowElt);
            int maxSize = this.orderedListOfHanders.size();
            int i = 0;
            while (i < maxSize) {
                org.w3c.dom.Element handlerElt = this.m_wsddDoc.createElement("handler");
                handlerElt.setAttribute("type", (String)this.orderedListOfHanders.elementAt(i));
                requestFlowElt.appendChild(handlerElt);
                ++i;
            }
            Iterator mapIterator = JavaGridServiceDeployConstants.getHandleTableIterator();
            while (mapIterator.hasNext()) {
                String key = (String)mapIterator.next();
                String value = JavaGridServiceDeployConstants.getHandler(key);
                org.w3c.dom.Element handlerElt = this.m_wsddDoc.createElement("handler");
                handlerElt.setAttribute("name", key);
                handlerElt.setAttribute("type", value);
                rootElt.appendChild(handlerElt);
            }
        }
    }

    protected void writeDeployServices(PrintWriter pw) throws IOException {
        org.w3c.dom.Element rootElt = this.m_wsddDoc.getDocumentElement();
        Map serviceMap = this.definition.getServices();
        Iterator mapIterator = serviceMap.values().iterator();
        while (mapIterator.hasNext()) {
            Service myService = (Service)mapIterator.next();
            if (this.bClientSideWsdd) continue;
            Iterator portIterator = myService.getPorts().values().iterator();
            while (portIterator.hasNext()) {
                Port myPort = (Port)portIterator.next();
                BindingEntry bEntry = this.symbolTable.getBindingEntry(myPort.getBinding().getQName());
                if (bEntry.getBindingType() != 0) continue;
                this.writeDeployPort(pw, myPort, myService);
            }
        }
    }

    protected void writeTypeMapping(PrintWriter pw) throws IOException {
        this.writeTypeMapping(pw, this.typeMapTbl);
    }

    protected void writeDeployTransport(PrintWriter pw) throws IOException {
        org.w3c.dom.Element rootElt = this.m_wsddDoc.getDocumentElement();
        if (rootElt.getElementsByTagName("transport").getLength() == 0) {
            org.w3c.dom.Element transportElt = this.m_wsddDoc.createElement("transport");
            rootElt.appendChild(transportElt);
            transportElt.setAttribute("name", "http");
            org.w3c.dom.Element requestFlowElt = this.m_wsddDoc.createElement("requestFlow");
            transportElt.appendChild(requestFlowElt);
            org.w3c.dom.Element handlerElt = this.m_wsddDoc.createElement("handler");
            requestFlowElt.appendChild(handlerElt);
            handlerElt.setAttribute("type", "URLMapper");
            handlerElt = this.m_wsddDoc.createElement("handler");
            requestFlowElt.appendChild(handlerElt);
            handlerElt.setAttribute("type", "java:org.apache.axis.handlers.http.HTTPAuthHandler");
            transportElt = this.m_wsddDoc.createElement("transport");
            rootElt.appendChild(transportElt);
            transportElt.setAttribute("name", "SimpleHTTP");
            requestFlowElt = this.m_wsddDoc.createElement("requestFlow");
            transportElt.appendChild(requestFlowElt);
            handlerElt = this.m_wsddDoc.createElement("handler");
            requestFlowElt.appendChild(handlerElt);
            handlerElt.setAttribute("type", "URLMapper");
            transportElt = this.m_wsddDoc.createElement("transport");
            rootElt.appendChild(transportElt);
            transportElt.setAttribute("name", "local");
            requestFlowElt = this.m_wsddDoc.createElement("requestFlow");
            transportElt.appendChild(requestFlowElt);
            handlerElt = this.m_wsddDoc.createElement("handler");
            requestFlowElt.appendChild(handlerElt);
            handlerElt.setAttribute("type", "java:org.apache.axis.transport.local.LocalResponder");
        }
    }

    protected void writeTypeMapping(PrintWriter pw, Map typeMapTbl) throws IOException {
        Iterator mapIterator = typeMapTbl.values().iterator();
        while (mapIterator.hasNext()) {
            TypeMappingInfo typeMap = (TypeMappingInfo)mapIterator.next();
            Namespaces namespaces = this.emitter.getNamespaces();
            if (typeMap.javaType.startsWith("org.gridforum.ogsi")) continue;
            this.writeTypeMapping(pw, typeMap.namespaceURI, typeMap.localPart, typeMap.javaType, typeMap.serializerFactory, typeMap.deserializerFactory, typeMap.encodingStyle);
        }
    }

    protected void writeTypeMapping(PrintWriter pw, String namespaceURI, String localPart, String javaType, String serializerFactory, String deserializerFactory, String encodingStyle) throws IOException {
        org.w3c.dom.Element rootElt = this.m_wsddDoc.getDocumentElement();
        NodeList typeMappingNodes = rootElt.getElementsByTagName("typeMapping");
        int i = 0;
        while (i < typeMappingNodes.getLength()) {
            org.w3c.dom.Element typeMappingElt;
            String type;
            Node typeMappingNode = typeMappingNodes.item(i);
            if (typeMappingNode.getNodeType() == 1 && (type = (typeMappingElt = (org.w3c.dom.Element)typeMappingNode).getAttribute("type")).equals(javaType)) {
                rootElt.removeChild(typeMappingElt);
                break;
            }
            ++i;
        }
        org.w3c.dom.Element typeMappingElt = this.m_wsddDoc.createElement("typeMapping");
        typeMappingElt.setAttribute("qname", namespaceURI + ":" + localPart);
        typeMappingElt.setAttribute("type", "java:" + javaType);
        typeMappingElt.setAttribute("serializer", serializerFactory);
        typeMappingElt.setAttribute("deserializer", deserializerFactory);
        typeMappingElt.setAttribute("encodingStyle", encodingStyle);
        rootElt.appendChild(typeMappingElt);
    }

    protected void writeDeployTypes(Map typeMapTbl, Service service) throws IOException {
        Iterator portIterator = service.getPorts().values().iterator();
        while (portIterator.hasNext()) {
            Port myPort = (Port)portIterator.next();
            BindingEntry bEntry = this.symbolTable.getBindingEntry(myPort.getBinding().getQName());
            if (bEntry.getBindingType() != 0) continue;
            Binding binding = myPort.getBinding();
            boolean hasLiteral = bEntry.hasLiteral();
            boolean hasMIME = Utils.hasMIME((BindingEntry)bEntry);
            this.writeDeployTypes(typeMapTbl, binding, hasLiteral, hasMIME);
        }
    }

    protected void writeDeployTypes(Map typeMapTbl, Binding binding, boolean hasLiteral, boolean hasMIME) throws IOException {
        Vector types = new Vector();
        types.addAll(this.symbolTable.getElementIndex().values());
        types.addAll(this.symbolTable.getTypeIndex().values());
        if (hasMIME) {
            QName bQName = binding.getQName();
            TypeMappingInfo typeMap = new TypeMappingInfo(bQName.getNamespaceURI(), "DataHandler", "javax.activation.DataHandler", "org.apache.axis.encoding.ser.JAFDataHandlerSerializerFactory", "org.apache.axis.encoding.ser.JAFDataHandlerDeserializerFactory", Constants.URI_DEFAULT_SOAP_ENC);
            if (!typeMapTbl.containsKey("javax.activation.DataHandler")) {
                typeMapTbl.put("javax.activation.DataHandler", typeMap);
            }
        }
        int i = 0;
        while (i < types.size()) {
            TypeEntry type = (TypeEntry)types.elementAt(i);
            boolean process = true;
            if (type.getBaseType() != null && type.getRefType() == null || type instanceof CollectionTE || type instanceof Element || !type.isReferenced() || type.isOnlyLiteralReferenced()) {
                process = false;
            }
            if (process) {
                String deserializerFactory;
                String serializerFactory;
                String namespaceURI = type.getQName().getNamespaceURI();
                String localPart = type.getQName().getLocalPart();
                String javaType = type.getName();
                String encodingStyle = "";
                if (!hasLiteral) {
                    encodingStyle = Constants.URI_DEFAULT_SOAP_ENC;
                }
                if (javaType.endsWith("[]")) {
                    serializerFactory = "org.apache.axis.encoding.ser.ArraySerializerFactory";
                    deserializerFactory = "org.apache.axis.encoding.ser.ArrayDeserializerFactory";
                } else if (type.getNode() != null && Utils.getEnumerationBaseAndValues((Node)type.getNode(), (SymbolTable)this.symbolTable) != null) {
                    serializerFactory = "org.apache.axis.encoding.ser.EnumSerializerFactory";
                    deserializerFactory = "org.apache.axis.encoding.ser.EnumDeserializerFactory";
                } else if (type.isSimpleType()) {
                    serializerFactory = "org.apache.axis.encoding.ser.SimpleSerializerFactory";
                    deserializerFactory = "org.apache.axis.encoding.ser.SimpleDeserializerFactory";
                } else if (type.getBaseType() != null) {
                    serializerFactory = "org.apache.axis.encoding.ser.SimpleSerializerFactory";
                    deserializerFactory = "org.apache.axis.encoding.ser.SimpleDeserializerFactory";
                } else {
                    serializerFactory = "org.apache.axis.encoding.ser.BeanSerializerFactory";
                    deserializerFactory = "org.apache.axis.encoding.ser.BeanDeserializerFactory";
                }
                String namespaceUri = namespaceURI;
                if (this.namesapceTbl.containsKey(namespaceURI)) {
                    namespaceUri = (String)this.namesapceTbl.get(namespaceURI);
                }
                TypeMappingInfo typeMap = new TypeMappingInfo(namespaceUri, localPart, javaType, serializerFactory, deserializerFactory, encodingStyle);
                if (!typeMapTbl.containsKey(javaType)) {
                    typeMapTbl.put(javaType, typeMap);
                }
            }
            ++i;
        }
    }

    protected void writeParameterElement(org.w3c.dom.Element serviceElement, org.w3c.dom.Element parameterElement) {
        NamedNodeMap parameterElementAttrs = parameterElement.getAttributes();
        Node parameterNameAttr = parameterElementAttrs.getNamedItem("name");
        String parameterName = parameterNameAttr.getNodeValue();
        NodeList serviceParameters = serviceElement.getElementsByTagName("parameter");
        int i = 0;
        while (i < serviceParameters.getLength()) {
            org.w3c.dom.Element curParmElt;
            String curParameterName;
            Node curParm = serviceParameters.item(i);
            if (curParm.getNodeType() == 1 && (curParameterName = (curParmElt = (org.w3c.dom.Element)curParm).getAttribute("name")).equals(parameterName)) {
                serviceElement.removeChild(curParmElt);
                break;
            }
            ++i;
        }
        serviceElement.appendChild(parameterElement);
    }

    protected void writeDeployPort(PrintWriter pw, Port port, Service service) throws IOException {
        Binding binding = port.getBinding();
        BindingEntry bEntry = this.symbolTable.getBindingEntry(binding.getQName());
        PortType curPortType = binding.getPortType();
        PortType custPortType = FlattenedWSDLDefinition.getCustomerPortType(this.m_service);
        String custNamespaceURI = custPortType.getQName().getNamespaceURI();
        boolean matched = false;
        if (this.emitter.getNamespaces().containsKey((Object)custNamespaceURI)) {
            custNamespaceURI = this.emitter.getNamespaces().get((Object)custNamespaceURI).toString();
            matched = true;
        }
        if (this.emitter.getNamespaceMap().containsKey(custNamespaceURI)) {
            custNamespaceURI = this.emitter.getNamespaceMap().get(custNamespaceURI).toString();
            matched = true;
        }
        String packageName = null;
        packageName = !matched ? Utils.makePackageName((String)custNamespaceURI) : custNamespaceURI;
        Namespaces ns = new Namespaces(RuntimeDirectoryUtil.getSchemaDirectory().getSchemaSubDir());
        String path = ns.toDir(packageName);
        path = path.replace('\\', '/');
        path = path.endsWith("/") ? path : path + "/";
        String serviceName = path + FlattenedWSDLDefinition.getGridServiceName(custPortType) + this.type;
        org.w3c.dom.Element rootElt = this.m_wsddDoc.getDocumentElement();
        NodeList serviceNodes = rootElt.getElementsByTagName("service");
        org.w3c.dom.Element serviceElement = null;
        int i = 0;
        while (i < serviceNodes.getLength() && serviceElement == null) {
            Node curServiceNode = serviceNodes.item(i);
            NamedNodeMap serviceNodeAttrs = curServiceNode.getAttributes();
            Node serviceNameAttr = serviceNodeAttrs.getNamedItem("name");
            if (serviceNameAttr.getNodeValue().equals(serviceName)) {
                serviceElement = (org.w3c.dom.Element)curServiceNode;
            }
            ++i;
        }
        if (serviceElement == null) {
            serviceElement = this.m_wsddDoc.createElement("service");
            rootElt.appendChild(serviceElement);
        }
        boolean hasLiteral = bEntry.hasLiteral();
        boolean hasMIME = Utils.hasMIME((BindingEntry)bEntry);
        String styleStr = "";
        if (hasLiteral) {
            styleStr = "document";
        }
        if (this.symbolTable.isWrapped()) {
            styleStr = "wrapped";
        }
        serviceElement.setAttribute("name", serviceName);
        serviceElement.setAttribute("provider", "Handler");
        serviceElement.setAttribute("style", styleStr);
        if (hasMIME) {
            org.w3c.dom.Element parm = this.m_wsddDoc.createElement("parameter");
            parm.setAttribute("sendMultiRefs", "false");
            this.writeParameterElement(serviceElement, parm);
        }
        this.writeDeployBinding(pw, binding, serviceElement);
    }

    protected void writeDeployBinding(PrintWriter pw, Binding binding, org.w3c.dom.Element serviceElement) throws IOException {
        BindingEntry bEntry = this.symbolTable.getBindingEntry(binding.getQName());
        if (this.serviceDeployProperties.size() > 0) {
            Iterator mapIterator = this.serviceDeployProperties.keySet().iterator();
            while (mapIterator.hasNext()) {
                String key = (String)mapIterator.next();
                String value = (String)this.serviceDeployProperties.get(key);
                org.w3c.dom.Element parm = this.m_wsddDoc.createElement("parameter");
                parm.setAttribute("name", key);
                parm.setAttribute("value", value);
                this.writeParameterElement(serviceElement, parm);
            }
        }
        org.w3c.dom.Element parm = this.m_wsddDoc.createElement("parameter");
        parm.setAttribute("name", "persistent");
        parm.setAttribute("value", "true");
        this.writeParameterElement(serviceElement, parm);
        parm = this.m_wsddDoc.createElement("parameter");
        parm.setAttribute("name", "baseClassName");
        parm.setAttribute("value", "org.globus.ogsa.impl.ogsi.PersistentGridServiceImpl");
        this.writeParameterElement(serviceElement, parm);
        parm = this.m_wsddDoc.createElement("parameter");
        parm.setAttribute("name", "handlerClass");
        parm.setAttribute("value", "org.globus.ogsa.handlers.RPCURIProvider");
        this.writeParameterElement(serviceElement, parm);
        parm = this.m_wsddDoc.createElement("parameter");
        parm.setAttribute("name", "allowedMethods");
        parm.setAttribute("value", "*");
        this.writeParameterElement(serviceElement, parm);
        parm = this.m_wsddDoc.createElement("parameter");
        parm.setAttribute("name", "factoryCallback");
        parm.setAttribute("value", "org.globus.ogsa.impl.ogsi.DynamicFactoryCallbackImpl");
        this.writeParameterElement(serviceElement, parm);
        Scope scope = this.emitter.getScope();
        if (scope != null) {
            parm = this.m_wsddDoc.createElement("parameter");
            parm.setAttribute("name", "scope");
            parm.setAttribute("value", scope.getName());
            this.writeParameterElement(serviceElement, parm);
        }
    }

    public String getModeString(byte mode) {
        if (mode == 1) {
            return "IN";
        }
        if (mode == 3) {
            return "INOUT";
        }
        return "OUT";
    }

    private class TypeMappingInfo {
        String namespaceURI = null;
        String localPart = null;
        String javaType = null;
        String serializerFactory = null;
        String deserializerFactory = null;
        String encodingStyle = null;

        TypeMappingInfo(String namespaceURI, String localPart, String javaType, String serializerFactory, String deserializerFactory, String encodingStyle) {
            this.namespaceURI = namespaceURI;
            this.localPart = localPart;
            this.javaType = javaType;
            this.serializerFactory = serializerFactory;
            this.deserializerFactory = deserializerFactory;
            this.encodingStyle = encodingStyle;
        }
    }
}

