/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.utils;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.RemoteException;
import org.apache.axis.utils.XMLUtils;

public class ChainedRemoteException
extends RemoteException {
    protected Throwable chained;

    public ChainedRemoteException() {
    }

    public ChainedRemoteException(String message) {
        super(message);
    }

    public ChainedRemoteException(String message, Throwable e) {
        this(message);
        this.chained = e;
    }

    public ChainedRemoteException(Exception e) {
        this(e.getMessage());
        this.chained = e;
    }

    public Throwable getChained() {
        return this.chained;
    }

    private String getHeaderString() {
        String exceptionString = "[" + this.getClass().getName() + "] ";
        String msg = super.getMessage();
        if (msg == null) {
            msg = "";
        }
        return XMLUtils.xmlEncodeString((String)(exceptionString + msg));
    }

    public String toString() {
        if (this.chained != null) {
            String msg = this.getHeaderString() + " [chained: " + this.chained.toString() + "]";
            if (this.chained instanceof NullPointerException) {
                StringWriter errorWriter = new StringWriter();
                PrintWriter out = new PrintWriter(errorWriter);
                this.chained.printStackTrace(out);
                out.close();
                msg = msg + "[NullPointer: " + XMLUtils.xmlEncodeString((String)errorWriter.toString()) + " End NullPointer]";
            }
            return msg;
        }
        return this.getHeaderString();
    }

    public String getMessage() {
        String msg = super.getMessage();
        if (this.chained != null && this.chained != this) {
            msg = msg + " [chained: " + this.chained.getMessage() + "]";
        }
        return msg;
    }

    public void printStackTrace() {
        if (this.chained != null) {
            this.chained.printStackTrace();
        } else {
            super.printStackTrace();
        }
    }

    public void printStackTrace(PrintStream stream) {
        if (this.chained != null) {
            this.chained.printStackTrace(stream);
        } else {
            super.printStackTrace(stream);
        }
    }

    public void printStackTrace(PrintWriter writer) {
        if (this.chained != null) {
            this.chained.printStackTrace(writer);
        } else {
            super.printStackTrace(writer);
        }
    }

    public String getStack() {
        StringWriter errorWriter = new StringWriter();
        PrintWriter out = new PrintWriter(errorWriter);
        this.printStackTrace(out);
        out.close();
        return XMLUtils.xmlEncodeString((String)errorWriter.toString());
    }
}

