/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.utilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OrderedMap
extends HashMap {
    private final List ordKeyList;
    private Collection orderedValues = new ArrayList();
    StringBuffer toStringBuff = new StringBuffer();

    public OrderedMap() {
        this.ordKeyList = new ArrayList();
    }

    public Object put(Object key, Object value) throws NullPointerException {
        this.checkNotNull("put()", key);
        if (!this.ordKeyList.contains(key)) {
            this.ordKeyList.add(key);
        }
        return super.put(key, value);
    }

    public Object remove(Object key) throws NullPointerException {
        this.checkNotNull("remove(key): ", key);
        this.ordKeyList.remove(key);
        return super.remove(key);
    }

    public void putAll(Map m) throws UnsupportedOperationException {
        if (m != null && m instanceof OrderedMap) {
            Iterator keysIt = m.keySet().iterator();
            if (keysIt == null) {
                return;
            }
            Object nextKey = null;
            while (keysIt.hasNext()) {
                nextKey = keysIt.next();
                if (nextKey == null) continue;
                this.put((Object)nextKey, m.get(nextKey));
            }
        } else {
            this.throwUnsupportedOperationException("Map object received by putAll() must be an instance of OrderedMap" + (m == null ? " - *NULL* Map received!!" : " - received: " + m));
        }
    }

    public void clear() {
        this.ordKeyList.clear();
        super.clear();
    }

    public Set keySet() {
        return new Set(){

            public int size() {
                return OrderedMap.this.ordKeyList.size();
            }

            public boolean isEmpty() {
                return OrderedMap.this.ordKeyList.isEmpty();
            }

            public boolean contains(Object o) {
                return OrderedMap.this.ordKeyList.contains(o);
            }

            public Iterator iterator() {
                return OrderedMap.this.ordKeyList.iterator();
            }

            public Object[] toArray() {
                return OrderedMap.this.ordKeyList.toArray();
            }

            public Object[] toArray(Object[] a) {
                return OrderedMap.this.ordKeyList.toArray(a);
            }

            public boolean containsAll(Collection c) {
                return OrderedMap.this.ordKeyList.isEmpty();
            }

            public boolean equals(Object o) {
                return OrderedMap.this.ordKeyList.equals(o);
            }

            public int hashCode() {
                return OrderedMap.this.ordKeyList.hashCode();
            }

            public boolean add(Object o) {
                OrderedMap.this.throwUnsupportedOperationException("add() not supported; this Set is immutable");
                return false;
            }

            public boolean remove(Object o) {
                OrderedMap.this.throwUnsupportedOperationException("remove() not supported; this Set is immutable");
                return false;
            }

            public boolean addAll(Collection c) {
                OrderedMap.this.throwUnsupportedOperationException("addAll() not supported; this Set is immutable");
                return false;
            }

            public boolean retainAll(Collection c) {
                OrderedMap.this.throwUnsupportedOperationException("retainAll() not supported; this Set is immutable");
                return false;
            }

            public boolean removeAll(Collection c) {
                OrderedMap.this.throwUnsupportedOperationException("removeAll() not supported; this Set is immutable");
                return false;
            }

            public void clear() {
                OrderedMap.this.throwUnsupportedOperationException("clear() not supported; this Set is immutable");
            }
        };
    }

    public Collection values() {
        this.orderedValues.clear();
        Iterator it = this.ordKeyList.iterator();
        while (it.hasNext()) {
            this.orderedValues.add(super.get(it.next()));
        }
        return this.orderedValues;
    }

    public String toString() {
        Iterator it = this.keySet().iterator();
        if (it == null) {
            return null;
        }
        this.toStringBuff.delete(0, this.toStringBuff.length());
        this.toStringBuff.append("\n\n* * * Begin OrderedMap * * *\n\n");
        Object nextKey = null;
        Object nextVal = null;
        while (it.hasNext()) {
            nextKey = it.next();
            if (nextKey == null) {
                this.toStringBuff.append("**NULL KEY**\n");
                continue;
            }
            this.toStringBuff.append((Object)nextKey);
            this.toStringBuff.append("\t = \t");
            nextVal = this.get(nextKey);
            if (nextVal == null) {
                this.toStringBuff.append("**NULL VALUE**");
            } else {
                this.toStringBuff.append((Object)nextVal);
            }
            this.toStringBuff.append("\n");
        }
        this.toStringBuff.append("\n* * * End OrderedMap * * *\n");
        return this.toStringBuff.toString();
    }

    public Set entrySet() {
        return super.entrySet();
    }

    private void checkNotNull(String origin, Object arg) throws NullPointerException {
        if (arg == null) {
            this.throwNullPointerException(origin + "\n* * * Argument must not be null!\n");
        }
    }

    private void checkNotNull(String origin, Object key, Object value) throws NullPointerException {
        if (key == null || value == null) {
            String keyNull = key == null ? "* * * Key must not be null!\n" : "";
            String valNull = value == null ? "* * * Value must not be null!\n" : "";
            this.throwNullPointerException(origin + " received key=" + key + " & value=" + value + "\n" + keyNull + valNull);
        }
    }

    private void throwNullPointerException(String msg) throws NullPointerException {
        NullPointerException npe = new NullPointerException(msg);
        npe.fillInStackTrace();
        throw npe;
    }

    private void throwUnsupportedOperationException(String msg) throws UnsupportedOperationException {
        UnsupportedOperationException e = new UnsupportedOperationException(msg);
        e.fillInStackTrace();
        throw e;
    }
}

