/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.utilities;

import edu.ucsb.nceas.utilities.IOUtil;
import edu.ucsb.nceas.utilities.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtilities {
    private static String DEFAULT_OUTPUT_FORMAT = "UTF-8";
    private static final String XPATH_SEPARATOR = "/";
    private static final String ATTRIB_XPATH_SYMBOL = "@";
    private static final String PREDICATE_OPEN_SYMBOL = "[";
    private static final String PREDICATE_CLOSE_SYMBOL = "]";
    private static DocumentBuilder domParser = null;
    private static Stack nodesToCreate = new Stack();
    private static final String BLANK = "";
    private static final StringBuffer buff = new StringBuffer();
    private static final StringBuffer predicateBuff = new StringBuffer();
    private static Object lastObj = null;
    private static int lastIndex = 0;
    private static int bracketIndex = 0;
    private static String stringToPush = null;

    public static Node getXMLAsDOMTreeRootNode(String cpRelativeFilename) throws IOException {
        return XMLUtilities.getXMLAsDOMDocument(cpRelativeFilename).getDocumentElement();
    }

    public static Node getXMLReaderAsDOMTreeRootNode(Reader xmlReader) throws IOException {
        return XMLUtilities.getXMLReaderAsDOMDocument(xmlReader).getDocumentElement();
    }

    public static Document getXMLAsDOMDocument(String cpRelativeFilename) throws IOException {
        InputStreamReader isReader = null;
        try {
            isReader = IOUtil.getResourceAsInputStreamReader(cpRelativeFilename);
        }
        catch (Exception e) {
            FileNotFoundException fnfe = new FileNotFoundException("File \"" + cpRelativeFilename + "\" doesn't exist or cannot be read." + "Original exceptions was: " + e);
            fnfe.fillInStackTrace();
            throw fnfe;
        }
        return XMLUtilities.getXMLReaderAsDOMDocument(isReader);
    }

    /*
     * Loose catch block
     */
    public static Document getXMLReaderAsDOMDocument(Reader xmlReader) throws IOException {
        Document doc;
        block12: {
            doc = null;
            if (xmlReader == null) {
                IOException ioe1 = new IOException("getXMLReaderAsDOMDocument received a null Reader");
                ioe1.fillInStackTrace();
                throw ioe1;
            }
            InputSource in = new InputSource(xmlReader);
            doc = XMLUtilities.getDOMParser().parse(in);
            Object var8_4 = null;
            try {
                if (xmlReader != null) {
                    xmlReader.close();
                }
                break block12;
            }
            catch (IOException i) {
                i.printStackTrace();
            }
            break block12;
            {
                catch (SAXException e) {
                    IOException ioe2 = new IOException("getXMLReaderAsDOMDocument: nested SAXException parsing Reader: " + e);
                    ioe2.fillInStackTrace();
                    throw ioe2;
                }
                catch (IOException ie) {
                    IOException ioe3 = new IOException("getXMLReaderAsDOMDocument: IOException parsing Reader: " + ie);
                    ioe3.fillInStackTrace();
                    throw ioe3;
                }
                catch (ParserConfigurationException pe) {
                    IOException ioe4 = new IOException("getXMLReaderAsDOMDocument: nested ParserConfigurationException calling getDOMParser(): " + pe);
                    ioe4.fillInStackTrace();
                    throw ioe4;
                }
            }
            catch (Throwable throwable) {
                Object var8_5 = null;
                try {
                    if (xmlReader != null) {
                        xmlReader.close();
                    }
                }
                catch (IOException i) {
                    i.printStackTrace();
                }
                throw throwable;
            }
        }
        return doc;
    }

    public static void addTextNodeToDOMTree(Node rootNode, String xpath, String textValue) throws DOMException, TransformerException {
        Node lastRealNode = XMLUtilities.getLastExistingNodeInXPath(rootNode, xpath);
        String nextNodeName = null;
        Document doc = rootNode.getOwnerDocument();
        while (!nodesToCreate.isEmpty()) {
            nextNodeName = XMLUtilities.popNextNodeString(nodesToCreate);
            if (nextNodeName == null) {
                DOMException de2 = new DOMException(12, "tried to create a node with null name!\n parent = " + lastRealNode.getNodeName());
                de2.fillInStackTrace();
                throw de2;
            }
            Element newElement = doc.createElement(XMLUtilities.stripXPathIndex(nextNodeName));
            lastRealNode.appendChild(newElement);
            lastRealNode = newElement;
        }
        NodeList nl = lastRealNode.getChildNodes();
        if (nl != null && nl.getLength() > 0) {
            Node[] childArray = XMLUtilities.getNodeListAsNodeArray(nl);
            int i = 0;
            while (i < childArray.length) {
                if (childArray[i].getNodeType() == 3) {
                    childArray[i].setNodeValue(textValue);
                    break;
                }
                ++i;
            }
        } else {
            Text newElement = doc.createTextNode(textValue);
            lastRealNode.appendChild(newElement);
        }
    }

    public static void addAttributeNodeToDOMTree(Node rootNode, String xpath, String attribValue) throws DOMException, TransformerException {
        if (xpath.indexOf(ATTRIB_XPATH_SYMBOL) < 0) {
            DOMException de1 = new DOMException(12, "call to addAttributeNodeToDOMTree() with an xpath that does not contain an attribute  (no @ symbol found in xpath: " + xpath + " )");
            de1.fillInStackTrace();
            throw de1;
        }
        Node lastRealNode = XMLUtilities.getLastExistingNodeInXPath(rootNode, xpath);
        String nextNodeName = null;
        Document doc = rootNode.getOwnerDocument();
        boolean attribExists = false;
        if (nodesToCreate.isEmpty() && lastRealNode != null) {
            if (lastRealNode.getNodeType() != 2) {
                DOMException de2 = new DOMException(3, "xpath defines a node that is *NOT* an attribute node\n xpath = " + xpath + ";\n nodeName = " + lastRealNode.getNodeName() + ";\n nodeType = " + lastRealNode.getNodeType());
                de2.fillInStackTrace();
                throw de2;
            }
            attribExists = true;
            nextNodeName = lastRealNode.getNodeName();
        }
        while (!nodesToCreate.isEmpty()) {
            nextNodeName = XMLUtilities.popNextNodeString(nodesToCreate);
            if (nextNodeName == null) {
                DOMException de3 = new DOMException(12, "tried to create a node with null name!\n parent = " + lastRealNode.getNodeName());
                de3.fillInStackTrace();
                throw de3;
            }
            if (nextNodeName.startsWith(ATTRIB_XPATH_SYMBOL)) break;
            Element newElement = doc.createElement(XMLUtilities.stripXPathIndex(nextNodeName));
            lastRealNode.appendChild(newElement);
            lastRealNode = newElement;
        }
        if (attribExists) {
            Attr attribNode = (Attr)lastRealNode;
            attribNode.setValue(attribValue);
        } else if (nextNodeName != null && nextNodeName.startsWith(ATTRIB_XPATH_SYMBOL)) {
            String attribName = attribExists ? nextNodeName : nextNodeName.substring(1);
            Element lrnElem = (Element)lastRealNode;
            lrnElem.setAttribute(attribName, attribValue);
        } else {
            DOMException de2 = new DOMException(3, "addAttributeNodeToDOMTree() was unable to  create or update attribute at this xpath: " + xpath + " )");
            de2.fillInStackTrace();
            throw de2;
        }
    }

    public static Node getTextNodeWithXPath(Node rootNode, String xpath) throws DOMException, TransformerException {
        Node targetNode = XMLUtilities.getNodeWithXPath(rootNode, xpath);
        if (targetNode == null) {
            return null;
        }
        NodeList targetList = targetNode.getChildNodes();
        if (targetList.getLength() == 0) {
            return null;
        }
        int nodeIndex = 0;
        while (nodeIndex < targetList.getLength()) {
            Node textNode = targetList.item(nodeIndex);
            if (textNode.getNodeType() == 3 || textNode.getNodeType() == 4) {
                return textNode;
            }
            ++nodeIndex;
        }
        return null;
    }

    public static Node getAttributeNodeWithXPath(Node rootNode, String xpath) throws DOMException, TransformerException {
        Node targetNode = XMLUtilities.getNodeWithXPath(rootNode, xpath);
        if (targetNode == null) {
            return null;
        }
        if (targetNode != null && targetNode.getNodeType() != 2) {
            DOMException de = new DOMException(1, "found a node at this xpath: " + xpath + " that is *NOT* an attribute node!");
            de.fillInStackTrace();
            throw de;
        }
        return targetNode;
    }

    public static Node getNodeWithXPath(Node rootNode, String xpath) throws DOMException, TransformerException {
        NodeList nodeList = XMLUtilities.getNodeListWithXPath(rootNode, xpath);
        if (nodeList == null) {
            return null;
        }
        if (nodeList.getLength() > 1) {
            DOMException de = new DOMException(1, "Non-unique XPATH expression: " + xpath + "\n (" + nodeList.getLength() + " nodes match");
            de.fillInStackTrace();
            throw de;
        }
        return nodeList.item(0);
    }

    public static NodeList getNodeListWithXPath(Node rootNode, String xpath) throws TransformerException {
        NodeList nodeList = null;
        if (xpath == null) {
            TransformerException t = new TransformerException("XMLUtilities.getNodeListWithXPath() received NULL xpath");
            t.fillInStackTrace();
            throw t;
        }
        if (rootNode == null) {
            TransformerException t = new TransformerException("XMLUtilities.getNodeListWithXPath() received NULL rootNode");
            t.fillInStackTrace();
            throw t;
        }
        nodeList = XPathAPI.selectNodeList((Node)rootNode, (String)xpath.trim(), (Node)rootNode);
        if (nodeList == null) {
            return null;
        }
        if (nodeList.getLength() < 1) {
            return null;
        }
        return nodeList;
    }

    public static Node[] getNodeListAsNodeArray(NodeList nList) {
        if (nList == null) {
            return null;
        }
        int nListLength = nList.getLength();
        if (nListLength == 0) {
            return null;
        }
        Node[] nodeArray = new Node[nListLength];
        int i = nListLength - 1;
        while (i > -1) {
            nodeArray[i] = nList.item(i);
            --i;
        }
        return nodeArray;
    }

    public static String getDOMTreeAsString(Node node) {
        return XMLUtilities.getDOMTreeAsString(node, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getDOMTreeAsString(Node node, boolean preserveWhitespace) {
        ByteArrayOutputStream baos;
        block9: {
            if (node == null) {
                return null;
            }
            baos = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(baos);
            XMLUtilities.print(node, printWriter, DEFAULT_OUTPUT_FORMAT, preserveWhitespace);
            Object var7_4 = null;
            try {
                printWriter.flush();
                baos.flush();
                baos.close();
                printWriter.close();
            }
            catch (IOException ioe) {}
            break block9;
            {
                catch (Exception e) {
                    String msg = "getDOMTreeAsString() - unexpected Exception: " + e + "\n";
                    printWriter.println(msg);
                    e.printStackTrace(printWriter);
                    Object var7_5 = null;
                    try {
                        printWriter.flush();
                        baos.flush();
                        baos.close();
                        printWriter.close();
                    }
                    catch (IOException ioe) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                try {
                    printWriter.flush();
                    baos.flush();
                    baos.close();
                    printWriter.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return baos.toString();
    }

    public static void print(Node node, PrintWriter printWriter) {
        XMLUtilities.print(node, printWriter, DEFAULT_OUTPUT_FORMAT);
    }

    public static void print(Node node, PrintWriter printWriter, String encoding) {
        XMLUtilities.print(node, printWriter, encoding, false);
    }

    public static void print(Node node, PrintWriter printWriter, String encoding, boolean preserveWhitespace) {
        if (node == null) {
            return;
        }
        if (printWriter == null) {
            return;
        }
        if (encoding == null) {
            return;
        }
        if (encoding.trim().equals(BLANK)) {
            encoding = DEFAULT_OUTPUT_FORMAT;
        }
        try {
            Document document = node.getOwnerDocument();
            if (document == null) {
                return;
            }
            OutputFormat format = new OutputFormat(document, encoding, true);
            format.setLineSeparator(System.getProperty("line.separator"));
            format.setLineWidth(72);
            format.setIndent(2);
            format.setPreserveSpace(preserveWhitespace);
            XMLSerializer serializer = new XMLSerializer((Writer)printWriter, format);
            serializer.serialize(document);
        }
        catch (IOException e) {
            e.printStackTrace(printWriter);
        }
    }

    public static OrderedMap getDOMTreeAsXPathMap(Node rootNode) {
        if (rootNode == null) {
            return null;
        }
        OrderedMap returnMap = new OrderedMap();
        XMLUtilities.getDOMTreeAsXPathMap(rootNode, XPATH_SEPARATOR + rootNode.getNodeName(), returnMap);
        return returnMap;
    }

    /*
     * Unable to fully structure code
     */
    public static void getXPathMapAsDOMTree(Map xpathMap, Node rootNode) throws DOMException, TransformerException {
        if (xpathMap == null || rootNode == null) {
            return;
        }
        nextKey = null;
        nextVal = null;
        it = xpathMap.keySet().iterator();
        if (it != null) ** GOTO lbl23
        return;
lbl-1000:
        // 1 sources

        {
            nextKey = (String)it.next();
            if (nextKey == null || nextKey.trim().equals("")) continue;
            nextVal = (String)xpathMap.get(nextKey);
            if (nextKey.indexOf("@") > 0 && nextKey.indexOf("@") > nextKey.lastIndexOf("/")) {
                attribNode = XMLUtilities.getAttributeNodeWithXPath(rootNode, nextKey);
                if (attribNode == null) {
                    XMLUtilities.addAttributeNodeToDOMTree(rootNode, nextKey, nextVal);
                    continue;
                }
                attribNode.setNodeValue(nextVal);
                continue;
            }
            textNode = XMLUtilities.getTextNodeWithXPath(rootNode, nextKey);
            if (textNode == null) {
                XMLUtilities.addTextNodeToDOMTree(rootNode, nextKey, nextVal);
                continue;
            }
            textNode.setNodeValue(nextVal);
lbl23:
            // 6 sources

            ** while (it.hasNext())
        }
lbl24:
        // 1 sources

    }

    public static String normalize(Object ss) {
        String s = BLANK;
        s = (String)ss;
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    break;
                }
                case '>': {
                    str.append("&gt;");
                    break;
                }
                case '&': {
                    str.append("&amp;");
                    break;
                }
                case '\"': {
                    str.append("&quot;");
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    break;
                }
                default: {
                    if (ch < '\u0080' && ch > '\u001f') {
                        str.append(ch);
                        break;
                    }
                    if (ch < ' ') {
                        if (ch == '\n') {
                            str.append(ch);
                        }
                        if (ch == '\r') {
                            str.append(ch);
                        }
                        if (ch != '\t') break;
                        str.append(ch);
                        break;
                    }
                    str.append("&#");
                    str.append(Integer.toString(ch));
                    str.append(';');
                }
            }
            ++i;
        }
        String temp = str.toString();
        if ((temp = temp.trim()).length() < 1) {
            temp = " ";
        }
        return temp;
    }

    public static boolean isXPathEvalAString(Node contextNode, String XPath) throws TransformerException {
        boolean res = false;
        XObject xobj = XPathAPI.eval((Node)contextNode, (String)XPath);
        if (xobj.getType() == 3) {
            res = true;
        }
        return res;
    }

    public static boolean isXPathEvalABoolean(Node contextNode, String XPath) throws TransformerException {
        boolean res = false;
        XObject xobj = XPathAPI.eval((Node)contextNode, (String)XPath);
        if (xobj.getType() == 1) {
            res = true;
        }
        return res;
    }

    public static boolean isXPathEvalANumber(Node contextNode, String XPath) throws TransformerException {
        boolean res = false;
        XObject xobj = XPathAPI.eval((Node)contextNode, (String)XPath);
        if (xobj.getType() == 2) {
            res = true;
        }
        return res;
    }

    public static boolean isXPathEvalANodeset(Node contextNode, String XPath) throws TransformerException {
        boolean res = false;
        XObject xobj = XPathAPI.eval((Node)contextNode, (String)XPath);
        if (xobj.getType() == 4) {
            res = true;
        }
        return res;
    }

    public static boolean isXPathEvalANull(Node contextNode, String XPath) throws TransformerException {
        boolean res = false;
        XObject xobj = XPathAPI.eval((Node)contextNode, (String)XPath);
        if (xobj.getType() == -1) {
            res = true;
        }
        return res;
    }

    public static void xPathEvalTypeTest(Node contextNode, String xpath) {
        try {
            XObject xobj = XPathAPI.eval((Node)contextNode, (String)xpath);
            if (xobj.getType() == 1) {
                Log.debug(1, "Boolean: " + xobj.bool());
            } else if (xobj.getType() == 3) {
                Log.debug(1, "String: " + xobj.str());
            } else if (xobj.getType() == 2) {
                Log.debug(1, "Number: " + xobj.num());
            }
            if (xobj.getType() == 4) {
                NodeList ns = xobj.nodelist();
                Log.debug(1, "Nodeset: nodeset length: " + ns.getLength());
            }
            if (xobj.getType() == -1) {
                Log.debug(1, "Null: ");
            }
        }
        catch (Exception w) {
            Log.debug(4, "exception in evalXPathTest --- " + w.toString());
        }
    }

    private static void getDOMTreeAsXPathMap(Node startNode, String xpath, Map returnNVPMap) {
        Node next = null;
        String nextAttribVal = null;
        NamedNodeMap attribList = startNode.getAttributes();
        Node[] attribNodeArray = XMLUtilities.getNamedNodeMapAsNodeArray(attribList);
        if (attribNodeArray != null) {
            int attribNodeArrayLength = attribNodeArray.length;
            int i = 0;
            while (i < attribNodeArrayLength) {
                next = attribNodeArray[i];
                if (next != null) {
                    buff.delete(0, buff.length());
                    buff.append(xpath);
                    buff.append(XPATH_SEPARATOR);
                    buff.append(ATTRIB_XPATH_SYMBOL);
                    buff.append(next.getNodeName());
                    nextAttribVal = StringUtil.stripTabsNewLines(next.getNodeValue());
                    returnNVPMap.put(buff.toString(), nextAttribVal);
                }
                ++i;
            }
        }
        NodeList childNodes = startNode.getChildNodes();
        String nextString = null;
        StringBuffer textNodeBuff = new StringBuffer();
        Node[] childNodeArray = XMLUtilities.getNodeListAsNodeArray(childNodes);
        if (childNodeArray != null) {
            int numChildren = childNodeArray.length;
            String[] currentNamesArray = new String[numChildren];
            int i = 0;
            while (i < numChildren) {
                next = childNodeArray[i];
                if (next != null) {
                    switch (next.getNodeType()) {
                        case 3: 
                        case 4: {
                            nextString = next.getNodeValue();
                            if (nextString == null || BLANK.equals(StringUtil.stripAllWhiteSpace(nextString))) break;
                            textNodeBuff.append(nextString);
                            break;
                        }
                        default: {
                            buff.delete(0, buff.length());
                            buff.append(xpath);
                            buff.append(XPATH_SEPARATOR);
                            buff.append(next.getNodeName());
                            buff.append(XMLUtilities.getNextXPathPredicate(next.getNodeName(), currentNamesArray, i));
                            XMLUtilities.getDOMTreeAsXPathMap(next, buff.toString(), returnNVPMap);
                        }
                    }
                }
                ++i;
            }
        }
        if (textNodeBuff.length() > 0) {
            returnNVPMap.put(xpath, textNodeBuff.toString());
        }
    }

    private static Node[] getNamedNodeMapAsNodeArray(NamedNodeMap nMap) {
        if (nMap == null) {
            return null;
        }
        int nMapLength = nMap.getLength();
        if (nMapLength == 0) {
            return null;
        }
        Node[] nodeArray = new Node[nMapLength];
        int i = nMapLength - 1;
        while (i > -1) {
            nodeArray[i] = nMap.item(i);
            --i;
        }
        return nodeArray;
    }

    private static String getNextXPathPredicate(String currentNodeName, String[] currentNamesArray, int currentNamesArrayIndex) {
        if (currentNodeName == null || currentNodeName.equals(BLANK)) {
            return BLANK;
        }
        if (currentNamesArrayIndex > currentNamesArray.length - 1) {
            return BLANK;
        }
        currentNamesArray[currentNamesArrayIndex] = currentNodeName;
        int predicate = 0;
        int i = 0;
        while (i < currentNamesArrayIndex + 1) {
            if (currentNamesArray[i] != null && currentNamesArray[i].equals(currentNodeName)) {
                ++predicate;
            }
            ++i;
        }
        predicateBuff.delete(0, predicateBuff.length());
        predicateBuff.append(PREDICATE_OPEN_SYMBOL);
        predicateBuff.append(String.valueOf(predicate));
        predicateBuff.append(PREDICATE_CLOSE_SYMBOL);
        return predicateBuff.toString();
    }

    private static Attr[] sortAttributes(NamedNodeMap attrs) {
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        int i = 0;
        while (i < len) {
            array[i] = (Attr)attrs.item(i);
            ++i;
        }
        int i2 = 0;
        while (i2 < len - 1) {
            String name = array[i2].getNodeName();
            int index = i2;
            int j = i2 + 1;
            while (j < len) {
                String curName = array[j].getNodeName();
                if (curName.compareTo(name) < 0) {
                    name = curName;
                    index = j;
                }
                ++j;
            }
            if (index != i2) {
                Attr temp = array[i2];
                array[i2] = array[index];
                array[index] = temp;
            }
            ++i2;
        }
        return array;
    }

    private static DocumentBuilder getDOMParser() throws ParserConfigurationException {
        if (domParser == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            factory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", new Boolean(false));
            domParser = factory.newDocumentBuilder();
        }
        return domParser;
    }

    private static String popNextNodeString(Stack nodeStack) {
        lastObj = nodeStack.pop();
        if (lastObj == null || !(lastObj instanceof String)) {
            return null;
        }
        return (String)lastObj;
    }

    private static String stripXPathIndex(String xpathSingleNodeName) {
        bracketIndex = xpathSingleNodeName.indexOf(PREDICATE_OPEN_SYMBOL);
        if (bracketIndex > -1) {
            xpathSingleNodeName = xpathSingleNodeName.substring(0, bracketIndex);
        }
        return xpathSingleNodeName;
    }

    private static Node getLastExistingNodeInXPath(Node rootNode, String xpath) throws DOMException, TransformerException {
        if (rootNode == null || xpath == null || xpath.trim().equals(BLANK) || xpath.indexOf(XPATH_SEPARATOR) < 0 || xpath.indexOf("*") > -1 || xpath.indexOf(rootNode.getNodeName()) < 0) {
            DOMException de1 = new DOMException(12, "XPATH expression does not define a unique node; \n xpath    = " + xpath + "\n rootNode = " + rootNode);
            de1.fillInStackTrace();
            throw de1;
        }
        Node lastRealNode = null;
        nodesToCreate.clear();
        String existingPath = xpath;
        while (lastRealNode == null) {
            lastRealNode = XMLUtilities.getNodeWithXPath(rootNode, existingPath);
            if (existingPath.indexOf(XPATH_SEPARATOR) < 0) break;
            existingPath = XMLUtilities.stepBackUpPath(existingPath, nodesToCreate);
        }
        nodesToCreate.pop();
        if (lastRealNode == null) {
            DOMException de3 = new DOMException(12, "XPATH expression does not contain any existing nodes - not even the root; \n xpath         = " + xpath + "\n rootNode name = " + rootNode.getNodeName());
            de3.fillInStackTrace();
            throw de3;
        }
        return lastRealNode;
    }

    private static String stepBackUpPath(String existingPath, Stack nodesToCreate) {
        stringToPush = existingPath.substring(existingPath.lastIndexOf(XPATH_SEPARATOR) + 1);
        nodesToCreate.push(stringToPush);
        return existingPath.substring(0, existingPath.lastIndexOf(XPATH_SEPARATOR));
    }
}

