/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.cert.CertPath;
import org.bouncycastle.jce.cert.CertPathBuilderException;
import org.bouncycastle.jce.cert.CertPathParameters;
import org.bouncycastle.jce.cert.CertPathValidatorException;
import org.bouncycastle.jce.cert.CertPathValidatorResult;
import org.bouncycastle.jce.cert.CertPathValidatorSpi;
import org.bouncycastle.jce.cert.CertStore;
import org.bouncycastle.jce.cert.PKIXCertPathChecker;
import org.bouncycastle.jce.cert.PKIXCertPathValidatorResult;
import org.bouncycastle.jce.cert.PKIXParameters;
import org.bouncycastle.jce.cert.TrustAnchor;
import org.bouncycastle.jce.cert.X509CRLSelector;
import org.bouncycastle.jce.provider.PKIXCertPathBuilderSpi;

public class PKIXCertPathValidatorSpi
extends CertPathValidatorSpi {
    public CertPathValidatorResult engineValidate(CertPath certPath, CertPathParameters certPathParameters) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        if (!(certPathParameters instanceof PKIXParameters)) {
            throw new InvalidAlgorithmParameterException("params must be a PKIXParameters instance");
        }
        PKIXParameters pKIXParameters = (PKIXParameters)certPathParameters;
        if (pKIXParameters.getTrustAnchors() == null) {
            throw new InvalidAlgorithmParameterException("trustAnchors is null, this is not allowed for path validation");
        }
        List list = certPath.getCertificates();
        int n = 0;
        int n2 = list.size() + 1;
        Certificate certificate = null;
        Certificate certificate2 = null;
        PublicKey publicKey = null;
        X509Name x509Name = null;
        Set set = pKIXParameters.getInitialPolicies();
        if (set.isEmpty()) {
            set = null;
        }
        Object object = null;
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        int n3 = n2 + 1;
        if (pKIXParameters.isExplicitPolicyRequired()) {
            n3 = 1;
        }
        int n4 = n2 + 1;
        TrustAnchor trustAnchor = null;
        Date date = new Date();
        if (pKIXParameters.getDate() != null) {
            date = pKIXParameters.getDate();
        }
        if (list.isEmpty()) {
            throw new CertPathValidatorException("CertPath is empty", null, certPath, 0);
        }
        if (pKIXParameters.getTargetCertConstraints() != null && !pKIXParameters.getTargetCertConstraints().match((X509Certificate)list.get(0))) {
            throw new CertPathValidatorException("target certificate in certpath does not match targetcertconstraints", null, certPath, 0);
        }
        trustAnchor = PKIXCertPathBuilderSpi.findTrustAnchor((X509Certificate)list.get(list.size() - 1), pKIXParameters.getTrustAnchors());
        if (trustAnchor == null) {
            throw new CertPathValidatorException("TrustAnchor for CertPath not found", null, certPath, 0);
        }
        certificate2 = trustAnchor.getTrustedCert();
        try {
            if (certificate2 != null) {
                x509Name = X509Name.getInstance(((X509Certificate)certificate2).getSubjectDN());
                publicKey = certificate2.getPublicKey();
            } else {
                x509Name = X509Name.getInstance(trustAnchor.getCAName());
                publicKey = trustAnchor.getCAPublicKey();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertPathValidatorException("TrustAnchor subjectDN: " + illegalArgumentException.toString());
        }
        Iterator iterator = pKIXParameters.getCertPathCheckers().iterator();
        while (iterator.hasNext()) {
            ((PKIXCertPathChecker)iterator.next()).init(false);
        }
        try {
            n = list.size() - 1;
            while (n >= 0) {
                Set<String> set2;
                Object object2;
                byte[] byArray;
                X509Name x509Name2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                Iterator iterator2;
                int n5 = n2 - n;
                certificate = (X509Certificate)list.get(n);
                certificate.verify(publicKey);
                ((X509Certificate)certificate).checkValidity(date);
                if (pKIXParameters.isRevocationEnabled()) {
                    boolean bl = false;
                    X509CRLSelector x509CRLSelector = new X509CRLSelector();
                    x509CRLSelector.addIssuerName(((X509Principal)((X509Certificate)certificate).getIssuerDN()).getEncoded());
                    x509CRLSelector.setCertificateChecking((X509Certificate)certificate);
                    iterator2 = pKIXParameters.getCertStores().iterator();
                    while (iterator2.hasNext()) {
                        CertStore certStore = (CertStore)iterator2.next();
                        object6 = certStore.getCRLs(x509CRLSelector).iterator();
                        while (object6.hasNext()) {
                            object5 = (X509CRL)object6.next();
                            if (date.before(((X509CRL)object5).getThisUpdate())) continue;
                            if (((X509CRL)object5).getNextUpdate() != null || date.before(((X509CRL)object5).getNextUpdate())) {
                                bl = true;
                            }
                            if (certificate2 != null && (object4 = (Object)((X509Certificate)certificate2).getKeyUsage()) != null && (((Object)object4).length < 7 || object4[6] == false)) {
                                throw new CertPathValidatorException("Issuer certificate keyusage extension does not permit crl signing.\n" + certificate2, null, certPath, n);
                            }
                            ((X509CRL)object5).verify(publicKey);
                            object3 = ((X509CRL)object5).getRevokedCertificate(((X509Certificate)certificate).getSerialNumber());
                            if (object3 == null || date.before(((X509CRLEntry)object3).getRevocationDate())) continue;
                            throw new CertPathValidatorException("Certificate revokation after " + ((X509CRLEntry)object3).getRevocationDate(), null, certPath, n);
                        }
                    }
                    if (!bl) {
                        throw new CertPathValidatorException("no valid CRL found", null, certPath, n);
                    }
                }
                try {
                    x509Name2 = X509Name.getInstance(((X509Certificate)certificate).getIssuerDN());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new CertPathBuilderException(((X509Certificate)certificate).getIssuerDN().getName() + " :" + illegalArgumentException.toString());
                }
                if (!x509Name2.equals(x509Name)) {
                    throw new CertPathValidatorException("IssuerName(" + x509Name2 + ") does not match SubjectName(" + x509Name + ") of signing certificate", null, certPath, n);
                }
                object6 = null;
                try {
                    byArray = certificate.getExtensionValue(X509Extensions.CertificatePolicies.getId());
                    if (byArray != null) {
                        object6 = new HashSet();
                        object5 = new ByteArrayInputStream(byArray);
                        object3 = new DERInputStream((InputStream)object5);
                        object5 = new ByteArrayInputStream(((ASN1OctetString)((DERInputStream)object3).readObject()).getOctets());
                        object3 = new DERInputStream((InputStream)object5);
                        object4 = ((ASN1Sequence)((DERInputStream)object3).readObject()).getObjects();
                        boolean bl = false;
                        while (object4.hasMoreElements() && !bl) {
                            object2 = (ASN1Sequence)object4.nextElement();
                            object6.add(((DERObjectIdentifier)((ASN1Sequence)object2).getObjectAt(0)).getId());
                        }
                    }
                }
                catch (Exception exception) {
                    throw new CertPathValidatorException("exception throw while parsing policy extension: ", (Throwable)exception, certPath, n);
                }
                if (n3 <= n5 && set != null && object6 != null) {
                    iterator2 = object6.iterator();
                    boolean bl = false;
                    while (iterator2.hasNext() && !bl) {
                        if (set.contains(iterator2.next())) continue;
                        bl = true;
                    }
                    if (bl) {
                        throw new CertPathValidatorException("policy OID not in initialPolicies and requiredExplictPolicy", null, certPath, n);
                    }
                }
                if ((object5 = certificate.getCriticalExtensionOIDs()) != null && object5.contains(X509Extensions.CertificatePolicies.getId())) {
                    if (object == null) {
                        object = object6;
                    } else {
                        object.retainAll((Collection<?>)object6);
                    }
                    if (object != null && object.isEmpty()) {
                        throw new CertPathValidatorException("intersection of acceptablePolicies and certificate policies is empty: ", null, certPath, n);
                    }
                }
                object3 = null;
                if (set != null) {
                    object3 = new HashSet(set);
                }
                if (object != null) {
                    if (object3 == null) {
                        object3 = object;
                    } else {
                        object3.retainAll((Collection<?>)object);
                    }
                }
                if (object3 != null && object3.isEmpty()) {
                    throw new CertPathValidatorException("intersection of acceptablePolicies and initial policies is empty: ", null, certPath, n);
                }
                if (certificate.hasUnsupportedCriticalExtension()) {
                    object4 = new HashSet<String>(certificate.getCriticalExtensionOIDs());
                    object4.remove(X509Extensions.CertificatePolicies.getId());
                    object4.remove(X509Extensions.PolicyConstraints.getId());
                    object4.remove(X509Extensions.KeyUsage.getId());
                    object4.remove(X509Extensions.BasicConstraints.getId());
                    iterator2 = pKIXParameters.getCertPathCheckers().iterator();
                    while (iterator2.hasNext()) {
                        ((PKIXCertPathChecker)iterator2.next()).check(certificate, (Collection)object4);
                    }
                    if (!object4.isEmpty()) {
                        throw new CertPathValidatorException("Certificate has unsupported critical extension", null, certPath, n);
                    }
                }
                if (certificate2 != null) {
                    int n6 = ((X509Certificate)certificate2).getBasicConstraints();
                    if (n6 < 0) {
                        throw new CertPathValidatorException("Issuer certificate isn't a CA one", null, certPath, n);
                    }
                    if (n6 < Integer.MAX_VALUE && n > n6) {
                        throw new CertPathValidatorException("Issuer certificate is a CA one but does only allow pathlength < " + n6 + " and pathlength is " + n, null, certPath, n);
                    }
                }
                if ((byArray = certificate.getExtensionValue(X509Extensions.PolicyConstraints.getId())) != null) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    object2 = new DERInputStream(byteArrayInputStream);
                    byteArrayInputStream = new ByteArrayInputStream(((ASN1OctetString)((DERInputStream)object2).readObject()).getOctets());
                    object2 = new DERInputStream(byteArrayInputStream);
                    Enumeration enumeration = ((ASN1Sequence)((DERInputStream)object2).readObject()).getObjects();
                    while (enumeration.hasMoreElements()) {
                        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
                        switch (aSN1TaggedObject.getTagNo()) {
                            case 0: {
                                int n7 = DERInteger.getInstance(aSN1TaggedObject).getValue().intValue();
                                if (n5 + n7 >= n3) break;
                                n3 = n5 + n7;
                                break;
                            }
                            case 1: {
                                int n7 = DERInteger.getInstance(aSN1TaggedObject).getValue().intValue();
                                if (n5 + n7 >= n4) break;
                                n4 = n5 + n7;
                            }
                        }
                    }
                }
                if (certificate2 != null && (set2 = certificate2.getCriticalExtensionOIDs()) != null && set2.contains(X509Extensions.KeyUsage.getId()) && (object2 = (Object)((X509Certificate)certificate2).getKeyUsage())[5] == false) {
                    throw new CertPathValidatorException("Issuer certificate keyusage extension is critical an does not permit key signing.\n" + certificate2, null, certPath, n);
                }
                certificate2 = certificate;
                publicKey = certificate2.getPublicKey();
                try {
                    x509Name = X509Name.getInstance(((X509Certificate)certificate2).getSubjectDN());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new CertPathBuilderException(((X509Certificate)certificate2).getSubjectDN().getName() + " :" + illegalArgumentException.toString());
                }
                --n;
            }
        }
        catch (CertPathValidatorException certPathValidatorException) {
            throw certPathValidatorException;
        }
        catch (Exception exception) {
            throw new CertPathValidatorException("Exception thrown while doing CertPath validation", (Throwable)exception, certPath, n);
        }
        return new PKIXCertPathValidatorResult(trustAnchor, null, certificate.getPublicKey());
    }
}

