/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.ecogrid.client;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.Reader;
import java.net.URL;
import java.util.Iterator;
import javax.xml.rpc.Stub;
import org.apache.axis.message.MessageElement;
import org.ecoinformatics.ecogrid.ANDType;
import org.ecoinformatics.ecogrid.ConditionType;
import org.ecoinformatics.ecogrid.EcogridQueryParser;
import org.ecoinformatics.ecogrid.EcogridResultsetTransformer;
import org.ecoinformatics.ecogrid.EcogridUtils;
import org.ecoinformatics.ecogrid.GridProxy;
import org.ecoinformatics.ecogrid.ORType;
import org.ecoinformatics.ecogrid.QueryType;
import org.ecoinformatics.ecogrid.ResultsetType;
import org.ecoinformatics.ecogrid.stub.EcoGridQueryInterfaceLevelOnePortType;
import org.ecoinformatics.ecogrid.stub.service.EcoGridQueryLevelOneServiceGridLocator;
import org.globus.gsi.proxy.IgnoreProxyPolicyHandler;
import org.globus.ogsa.impl.security.Constants;
import org.globus.ogsa.impl.security.authorization.NoAuthorization;
import org.globus.ogsa.utils.GridServiceFactory;
import org.gridforum.ogsi.Factory;
import org.gridforum.ogsi.LocatorType;
import org.gridforum.ogsi.OGSIServiceGridLocator;
import org.gridforum.ogsi.WSDLReferenceType;

public class EcogridQueryClient {
    private URL serviceURL = null;
    private EcoGridQueryInterfaceLevelOnePortType ecogrid = null;

    public static void main(String[] args) {
        block9: {
            if (args.length < 1) {
                System.out.println("Usage: java [-DFACTORY=no] EcogridQueryClient query local_filename GSH");
                System.out.println("Usage: java [-DFACTORY=no] EcogridQueryClient get ecogri_filename local_filename GSH");
                System.exit(0);
            }
            String myOperation = args[0];
            URL GSH = null;
            try {
                String localFileName = "";
                GSH = new URL(args[2]);
                EcogridQueryClient client = new EcogridQueryClient(GSH);
                if (myOperation.compareToIgnoreCase("query") == 0) {
                    if (args.length != 3) {
                        System.out.println("Usage: java [-DFACTORY=no] EcogridQueryClient query local_filename GSH");
                        System.exit(0);
                    }
                    client.createEcoGridQueryLevelOnePortType();
                    localFileName = args[1];
                    File queryXMLFile = new File(localFileName);
                    FileReader xmlReader = new FileReader(queryXMLFile);
                    ResultsetType result = client.query(xmlReader);
                    String resultXML = EcogridResultsetTransformer.toXMLString((ResultsetType)result);
                    System.out.println(resultXML);
                } else if (myOperation.compareToIgnoreCase("get") == 0) {
                    if (args.length != 4) {
                        System.out.println("Usage: java [-DFACTORY=no] EcogridQueryClient get ecogri_filename local_filename GSH");
                        System.exit(0);
                    }
                    GSH = new URL(args[3]);
                    client.setGSH(GSH);
                    client.createEcoGridQueryLevelOnePortType();
                    localFileName = args[2];
                    String ecogridFileName = args[1];
                    byte[] content = client.get(ecogridFileName);
                    FileOutputStream fOutStream = new FileOutputStream(localFileName);
                    fOutStream.write(content);
                    fOutStream.close();
                } else {
                    System.out.println("Unknow operation: " + myOperation);
                }
            }
            catch (Exception e) {
                System.out.println("Exception in main : " + e.getMessage());
                if (!EcogridUtils.printStackTraceByEnv()) break block9;
                e.printStackTrace();
            }
        }
    }

    public EcogridQueryClient(URL gsh) {
        this.serviceURL = gsh;
    }

    void setGSH(URL gsh) {
        this.serviceURL = gsh;
    }

    public LocatorType createServiceInstance() throws Exception {
        OGSIServiceGridLocator factoryService = new OGSIServiceGridLocator();
        Factory factory = factoryService.getFactoryPort(this.serviceURL);
        GridServiceFactory gridFactory = new GridServiceFactory(factory);
        LocatorType locator = gridFactory.createService();
        return locator;
    }

    public void destroyServiceInstance() throws Exception {
        if (this.ecogrid != null) {
            this.ecogrid.destroy();
        }
    }

    public int createUserProxy(String password) throws Exception {
        GridProxy proxy = new GridProxy();
        int success = proxy.createProxy(password);
        return success;
    }

    public void createEcoGridQueryLevelOnePortType(LocatorType locator, String tcpMonURL) throws Exception {
    }

    public void createEcoGridQueryLevelOnePortType() throws Exception {
        if (EcogridUtils.isaFcatoryServiceByEnv()) {
            LocatorType locator = this.createServiceInstance();
            EcoGridQueryLevelOneServiceGridLocator queryLocator = new EcoGridQueryLevelOneServiceGridLocator();
            this.ecogrid = queryLocator.getEcoGridQueryLevelOneServicePort(locator);
        } else {
            EcoGridQueryLevelOneServiceGridLocator loc = new EcoGridQueryLevelOneServiceGridLocator();
            this.ecogrid = loc.getEcoGridQueryLevelOneServicePort(this.serviceURL);
        }
        org.apache.axis.client.Stub stub = (org.apache.axis.client.Stub)this.ecogrid;
        stub.setTimeout(10000000);
    }

    public ResultsetType query(Reader queryText) {
        ResultsetType result = null;
        try {
            EcogridQueryParser parser = new EcogridQueryParser(queryText);
            parser.parseXML();
            QueryType query = parser.getEcogridQuery();
            result = this.query(query);
        }
        catch (Exception e) {
            System.out.println("ERROR!");
            e.printStackTrace();
        }
        return result;
    }

    public ResultsetType query(QueryType queryObject) {
        ResultsetType result = null;
        if (queryObject == null) {
            return result;
        }
        try {
            result = this.ecogrid.query(queryObject);
        }
        catch (Exception e) {
            System.out.println("ERROR!");
            e.printStackTrace();
        }
        return result;
    }

    public byte[] get(String identifier) {
        byte[] content = null;
        try {
            content = this.ecogrid.get(identifier);
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
        }
        return content;
    }

    private void viewQuery(QueryType query) {
        if (query == null) {
            System.out.println("start to check the query");
            System.out.println("  query is null");
            System.out.println("end to check the query");
            return;
        }
        if (query.getAND() != null) {
            System.out.println("start to check the query");
            System.out.println("start first level of AND");
            ANDType and1 = query.getAND();
            ORType[] orList = and1.getOR();
            if (orList != null) {
                for (int i = 0; i < orList.length; ++i) {
                    ORType or = orList[i];
                    System.out.println("  child " + i + "ORType start");
                    ConditionType[] conditionList = or.getCondition();
                    if (conditionList != null) {
                        for (int j = 0; j < conditionList.length; ++j) {
                            ConditionType condition = conditionList[j];
                            System.out.println("    condtion kid " + j + " of ORType " + i + " start");
                            if (condition != null) {
                                System.out.println("      expresspath is " + condition.getConcept().getValue());
                                System.out.println("      operator is " + condition.getOperator().getValue());
                                System.out.println("      value is " + condition.getValue());
                            }
                            System.out.println("    condtion kid " + j + " of ORType " + i + " end");
                        }
                    }
                    System.out.println("  child " + i + " ORType end");
                }
            }
            System.out.println("end first level of AND");
            System.out.println("end to check the query");
        }
    }

    private EcoGridQueryInterfaceLevelOnePortType setAuthorizationConatant(EcoGridQueryInterfaceLevelOnePortType ecogrid) {
        if (ecogrid == null) {
            return null;
        }
        ((Stub)ecogrid)._setProperty("org.globus.ogsa.security.authorization", (Object)NoAuthorization.getInstance());
        ((Stub)ecogrid)._setProperty("org.globus.gsi.mode", (Object)"gsifull");
        ((Stub)ecogrid)._setProperty("org.globus.security.msg.type", (Object)Constants.SIGNATURE);
        ((Stub)ecogrid)._setProperty("org.globus.ogsa.security.grim.policy.handler", (Object)new IgnoreProxyPolicyHandler());
        ((Stub)ecogrid)._setProperty("org.globus.ogsa.security.sign.msg", (Object)Boolean.FALSE);
        return ecogrid;
    }

    private String getHandlerString(LocatorType locator) {
        if (locator == null) {
            return null;
        }
        WSDLReferenceType ref = (WSDLReferenceType)locator.getReference()[0];
        MessageElement[] me = ref.get_any();
        String handleURLString = null;
        Iterator iter1 = me[0].getChildElements();
        while (iter1.hasNext()) {
            MessageElement elem1 = (MessageElement)iter1.next();
            if (!elem1.getName().equals("service")) continue;
            Iterator iter2 = elem1.getChildElements();
            while (iter2.hasNext()) {
                MessageElement elem2 = (MessageElement)iter2.next();
                if (!elem2.getName().equals("port")) continue;
                Iterator iter3 = elem2.getChildElements();
                while (iter3.hasNext()) {
                    MessageElement elem3 = (MessageElement)iter3.next();
                    if (!elem3.getName().equals("address")) continue;
                    handleURLString = elem3.getAttributeValue("location");
                }
            }
        }
        return handleURLString;
    }

    private String getHashFromHandle(String handle) {
        String hash = null;
        String slash = "/";
        if (handle == null) {
            return hash;
        }
        int lastSlath = handle.lastIndexOf(slash);
        hash = handle.substring(lastSlath);
        System.out.println("The hash code is " + hash);
        return hash;
    }
}

