/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.ecogrid.digir.impl;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.axis.types.URI;
import org.ecoinformatics.ecogrid.ANDType;
import org.ecoinformatics.ecogrid.ConditionType;
import org.ecoinformatics.ecogrid.EcogridUtils;
import org.ecoinformatics.ecogrid.LimitedXPathExpression;
import org.ecoinformatics.ecogrid.ORType;
import org.ecoinformatics.ecogrid.OperatorType;
import org.ecoinformatics.ecogrid.QueryType;
import org.ecoinformatics.ecogrid.QueryType_namespace;
import org.ecoinformatics.ecogrid.digir.impl.DateUtil;
import org.ecoinformatics.ecogrid.digir.impl.DigirProviderInfo;

public class EcogridJavaToDigirJavaQueryTransformer {
    private Hashtable operatorNameMatch = null;
    public static final String DARWINSCHEMA1 = "http://digir.sourceforge.net/schema/conceptual/darwin/2003/1.0/darwin2.xsd";
    public static final String DARWINSCHEMA2 = "http://kuecogrid.ittc.ku.edu:8080/portal/darwin2jrw030315.xsd";
    private int mDarwinCoreVersion = 2;

    public EcogridJavaToDigirJavaQueryTransformer() {
        this.setupOperatorMatchTable();
    }

    public int getDarwinCoreVersion() {
        return this.mDarwinCoreVersion;
    }

    public void setDarwinCoreVersion(int aVersion) {
        this.mDarwinCoreVersion = aVersion;
    }

    protected void transform(QueryType ecogridQuery, StringBuffer digirQuery) throws Exception {
        String[] titleList = ecogridQuery.getTitle();
        String title = titleList[0];
        EcogridUtils.debugMessage((String)("query title - " + title), (int)30);
        Vector returnDocTypeList = this.namespaceToDocList(ecogridQuery.getNamespace());
        try {
            this.transferCore(ecogridQuery, digirQuery);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
        digirQuery.append("</request>\n");
        EcogridUtils.debugMessage((String)("The digir query is: " + digirQuery), (int)30);
        EcogridUtils.debugMessage((String)"---- in the end of transform ----", (int)30);
    }

    public String transform(QueryType ecogridQuery, String aResource, String aURL) throws Exception {
        EcogridUtils.debugMessage((String)"---- in the begin of transform ----", (int)30);
        StringBuffer digirQuery = new StringBuffer();
        digirQuery.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        digirQuery.append("<request xmlns=\"http://digir.net/schema/protocol/2003/1.0\"\n");
        digirQuery.append("   xmlns:darwin=\"http://digir.net/schema/conceptual/darwin/2003/1.0\"\n");
        digirQuery.append("   xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
        digirQuery.append("   xsi:schemaLocation=\"http://digir.net/schema/protocol/2003/1.0\n");
        digirQuery.append("   http://digir.sourceforge.net/schema/protocol/2003/1.0/digir.xsd\n");
        digirQuery.append("   http://digir.net/schema/conceptual/darwin/2003/1.0 ");
        digirQuery.append("   " + (this.mDarwinCoreVersion == 2 ? DARWINSCHEMA2 : DARWINSCHEMA1) + "\">\n");
        digirQuery.append("   <header>\n");
        digirQuery.append("      <version>0.92</version>\n");
        digirQuery.append("      <sendTime>" + DateUtil.formatNow() + "</sendTime>\n");
        digirQuery.append("      <source>127.0.0.1</source>\n");
        digirQuery.append("      <destination resource=\"" + aResource + "\">" + aURL + "</destination>\n");
        digirQuery.append("      <type>search</type>\n");
        digirQuery.append("   </header>\n");
        this.transform(ecogridQuery, digirQuery);
        return digirQuery.toString();
    }

    public String transform(QueryType ecogridQuery, Vector aProvidersInfo) throws Exception {
        EcogridUtils.debugMessage((String)"---- in the begin of transform ----", (int)30);
        StringBuffer digirQuery = new StringBuffer();
        digirQuery.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        digirQuery.append("<request xmlns=\"http://digir.net/schema/protocol/2003/1.0\"\n");
        digirQuery.append("   xmlns:darwin=\"http://digir.net/schema/conceptual/darwin/2003/1.0\"\n");
        digirQuery.append("   xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
        digirQuery.append("   xsi:schemaLocation=\"http://digir.net/schema/protocol/2003/1.0\n");
        digirQuery.append("   http://digir.sourceforge.net/schema/protocol/2003/1.0/digir.xsd\n");
        digirQuery.append("   http://digir.net/schema/conceptual/darwin/2003/1.0\n");
        digirQuery.append("   " + (this.mDarwinCoreVersion == 2 ? DARWINSCHEMA2 : DARWINSCHEMA1) + "\">\n");
        digirQuery.append("   <header>\n");
        digirQuery.append("      <version>0.92</version>\n");
        digirQuery.append("      <sendTime>" + DateUtil.formatNow() + "</sendTime>\n");
        digirQuery.append("      <source>127.0.0.1</source>\n");
        Enumeration e = aProvidersInfo.elements();
        while (e.hasMoreElements()) {
            DigirProviderInfo providerInfo = (DigirProviderInfo)e.nextElement();
            digirQuery.append("      <destination resource=\"" + providerInfo.getResource() + "\">" + providerInfo.getUrl() + "</destination>\n");
        }
        digirQuery.append("      <type>search</type>\n");
        digirQuery.append("   </header>\n");
        this.transform(ecogridQuery, digirQuery);
        return digirQuery.toString();
    }

    private Vector namespaceToDocList(QueryType_namespace[] nameSpaceList) {
        EcogridUtils.debugMessage((String)"start of namespaceToDocList()", (int)30);
        Vector<String> returnList = new Vector<String>();
        if (nameSpaceList == null) {
            return returnList;
        }
        for (int i = 0; i < nameSpaceList.length; ++i) {
            QueryType_namespace nameSpace = nameSpaceList[i];
            URI uri = nameSpace.getValue();
            String docType = uri.toString();
            EcogridUtils.debugMessage((String)("the return doc list(namespace) is " + docType), (int)30);
            returnList.add(docType);
        }
        EcogridUtils.debugMessage((String)"end of namespaceToDocList()", (int)30);
        return returnList;
    }

    private boolean isInList(Vector aFieldList, String aFieldName) {
        Enumeration e = aFieldList.elements();
        while (e.hasMoreElements()) {
            if (!((String)e.nextElement()).equals(aFieldName)) continue;
            return true;
        }
        return false;
    }

    private void transferReturnField(QueryType ecogridQuery, StringBuffer digirQuery) {
        digirQuery.append("<records start=\"0\">\n");
        digirQuery.append("    <structure>\n");
        digirQuery.append("       <xsd:element name=\"record\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\n");
        digirQuery.append("          <xsd:complexType>\n");
        digirQuery.append("             <xsd:sequence>\n");
        EcogridUtils.debugMessage((String)"start of transferReturnField", (int)30);
        String[] returnFieldList = ecogridQuery.getReturnfield();
        if (returnFieldList != null) {
            Vector<String> fieldList = new Vector<String>(Arrays.asList(returnFieldList));
            if (this.mDarwinCoreVersion == 2) {
                for (int i = 0; i < returnFieldList.length; ++i) {
                    if (returnFieldList[i].equals("Latitude")) {
                        returnFieldList[i] = "DecimalLatitude";
                        continue;
                    }
                    if (!returnFieldList[i].equals("Longitude")) continue;
                    returnFieldList[i] = "DecimalLongitude";
                }
            }
            String[] requiredIdentifierNames = new String[]{"InstitutionCode", "CollectionCode", "CatalogNumber", "CatalogNumberText"};
            for (int i = 0; i < requiredIdentifierNames.length; ++i) {
                if (this.isInList(fieldList, requiredIdentifierNames[i])) continue;
                fieldList.addElement(requiredIdentifierNames[i]);
            }
            Enumeration<String> e = fieldList.elements();
            while (e.hasMoreElements()) {
                String returnField = e.nextElement();
                if (returnField.charAt(0) == '/') {
                    returnField = returnField.substring(1);
                }
                digirQuery.append("               <xsd:element ref=\"darwin:" + returnField + "\"/>\n");
                EcogridUtils.debugMessage((String)("returnfield is " + returnField), (int)30);
            }
        }
        digirQuery.append("            </xsd:sequence>\n");
        digirQuery.append("         </xsd:complexType>\n");
        digirQuery.append("      </xsd:element>\n");
        digirQuery.append("   </structure>\n");
        digirQuery.append("</records>\n");
        EcogridUtils.debugMessage((String)"end of transferReturnField", (int)30);
    }

    private void transferCore(QueryType ecogridQuery, StringBuffer digirQuery) throws Exception {
        digirQuery.append("<search>\n<filter>\n");
        EcogridUtils.debugMessage((String)"start of transferQueryGroup()", (int)30);
        if (ecogridQuery.getAND() != null) {
            EcogridUtils.debugMessage((String)"first level is AND", (int)30);
            digirQuery.append("<and>\n");
            this.handleANDChildren(digirQuery, ecogridQuery.getAND());
            digirQuery.append("</and>\n");
        } else if (ecogridQuery.getOR() != null) {
            EcogridUtils.debugMessage((String)"first level is OR", (int)30);
            digirQuery.append("<or>\n");
            this.handleORChildren(digirQuery, ecogridQuery.getOR());
            digirQuery.append("</or>\n");
        } else if (ecogridQuery.getCondition() != null) {
            EcogridUtils.debugMessage((String)"first level is Condition", (int)30);
            this.handleConditionType(digirQuery, ecogridQuery.getCondition());
        } else {
            EcogridUtils.debugMessage((String)"Wrong format of query", (int)30);
            throw new Exception("Wrong Ecogrid Query Format");
        }
        EcogridUtils.debugMessage((String)"end of transferQueryGroup()", (int)30);
        digirQuery.append("</filter>\n");
        this.transferReturnField(ecogridQuery, digirQuery);
        digirQuery.append("      <count>true</count>\n</search>\n");
    }

    private void handleANDChildren(StringBuffer digirQuery, ANDType andParent) {
        int i;
        EcogridUtils.debugMessage((String)"start of handleANDChildren()(parent is AND)", (int)30);
        if (digirQuery == null || andParent == null) {
            EcogridUtils.debugMessage((String)"query group is null or andparent is null", (int)30);
            return;
        }
        if (andParent.getAND() != null) {
            for (i = 0; i < andParent.getAND().length; ++i) {
                EcogridUtils.debugMessage((String)"add AND childen to parent AND", (int)30);
                this.handleANDType(digirQuery, andParent.getAND(i));
            }
        }
        if (andParent.getOR() != null) {
            for (i = 0; i < andParent.getOR().length; ++i) {
                EcogridUtils.debugMessage((String)"add OR childen to parent AND", (int)30);
                this.handleORType(digirQuery, andParent.getOR(i));
            }
        }
        if (andParent.getCondition() != null) {
            for (i = 0; i < andParent.getCondition().length; ++i) {
                EcogridUtils.debugMessage((String)"add Condition childen to parent AND", (int)30);
                this.handleConditionType(digirQuery, andParent.getCondition(i));
            }
        }
        EcogridUtils.debugMessage((String)"end of handleANDChildren()(parent is AND)", (int)30);
    }

    private void handleORChildren(StringBuffer digirQuery, ORType orParent) {
        int i;
        EcogridUtils.debugMessage((String)"start of handleORChildren()(parent is OR)", (int)30);
        if (digirQuery == null || orParent == null) {
            return;
        }
        if (orParent.getAND() != null) {
            for (i = 0; i < orParent.getAND().length; ++i) {
                EcogridUtils.debugMessage((String)"add AND childen to parent OR", (int)30);
                this.handleANDType(digirQuery, orParent.getAND(i));
            }
        }
        if (orParent.getOR() != null) {
            for (i = 0; i < orParent.getOR().length; ++i) {
                EcogridUtils.debugMessage((String)"add OR childen to parent OR", (int)30);
                this.handleORType(digirQuery, orParent.getOR(i));
            }
        }
        if (orParent.getCondition() != null) {
            for (i = 0; i < orParent.getCondition().length; ++i) {
                EcogridUtils.debugMessage((String)"add Condtion childen to parent OR", (int)30);
                this.handleConditionType(digirQuery, orParent.getCondition(i));
            }
        }
        EcogridUtils.debugMessage((String)"end of handleORChildren()(parent is OR)", (int)30);
    }

    private void handleANDType(StringBuffer digirQuery, ANDType and) {
        EcogridUtils.debugMessage((String)"start handleANDType()", (int)30);
        if (digirQuery == null || and == null) {
            return;
        }
        digirQuery.append("<and>\n");
        this.handleANDChildren(digirQuery, and);
        digirQuery.append("</and>\n");
        EcogridUtils.debugMessage((String)"end handleANDType()", (int)30);
    }

    private void handleORType(StringBuffer digirQuery, ORType or) {
        EcogridUtils.debugMessage((String)"start handleORType()", (int)30);
        if (or == null) {
            return;
        }
        digirQuery.append("<or>\n");
        this.handleORChildren(digirQuery, or);
        EcogridUtils.debugMessage((String)"end handleORType()", (int)30);
        digirQuery.append("</or>\n");
    }

    private void handleConditionType(StringBuffer digirQuery, ConditionType condition) {
        EcogridUtils.debugMessage((String)"start of handleConditionType()", (int)30);
        if (condition == null) {
            return;
        }
        LimitedXPathExpression xpath = condition.getConcept();
        String pathString = xpath.getValue();
        EcogridUtils.debugMessage((String)("path express is " + pathString), (int)30);
        OperatorType operator = condition.getOperator();
        String operatorString = operator.getValue();
        String digirOperator = this.lookupDigirOperator(operatorString);
        String value = condition.getValue();
        EcogridUtils.debugMessage((String)("value for path is " + value), (int)30);
        digirQuery.append("  <" + digirOperator + ">\n    <darwin:" + pathString + ">" + value + "</darwin:" + pathString + ">\n  </" + digirOperator + ">\n");
        EcogridUtils.debugMessage((String)"end of handleConditionType()", (int)30);
    }

    private String lookupDigirOperator(String input) {
        EcogridUtils.debugMessage((String)("operator in ecogrid(input) is " + input), (int)30);
        String operator = null;
        operator = (String)this.operatorNameMatch.get(input);
        EcogridUtils.debugMessage((String)("operator in digir(output) is " + operator), (int)30);
        return operator;
    }

    private void setupOperatorMatchTable() {
        this.operatorNameMatch = new Hashtable();
        this.operatorNameMatch.put("LIKE", "like");
        this.operatorNameMatch.put("NOT LIKE", "notLike");
        this.operatorNameMatch.put("EQUALS", "equals");
        this.operatorNameMatch.put("NOT EQUALS", "notEquals");
        this.operatorNameMatch.put("LESS THAN", "lessThan");
        this.operatorNameMatch.put("LESS THAN OR EQUALS", "lessThanEquals");
        this.operatorNameMatch.put("GREATER THAN", "greaterThan");
        this.operatorNameMatch.put("GREATER THAN OR EQUALS", "greaterThanEquals");
    }
}

