/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.utilities;

import edu.ucsb.nceas.utilities.UtilException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    private DateUtil() {
    }

    public static String getHumanReadable(Calendar cal) throws UtilException {
        return DateUtil.getHumanReadable(cal, "mm/dd/yy HH:mm:ss z");
    }

    public static String getHumanReadable(Calendar cal, String format) throws UtilException {
        SimpleDateFormat sdf = null;
        if (cal == null) {
            throw new UtilException("DateUtil.getHumanReadable -  cannot have a null calendar object");
        }
        try {
            sdf = new SimpleDateFormat(format);
        }
        catch (IllegalArgumentException iae) {
            throw new UtilException("DateUtil.getHumanReadable - illegal date format: " + format + " : " + iae.getMessage());
        }
        return sdf.format(cal.getTime());
    }

    public static String getHumanReadable(Timestamp timestamp) throws UtilException {
        return DateUtil.getHumanReadable(timestamp, "mm/dd/yy HH:mm:ss z");
    }

    public static String getHumanReadable(Timestamp timestamp, String format) throws UtilException {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timestamp.getTime());
        return DateUtil.getHumanReadable(cal, format);
    }

    public static Calendar humanReadableToCalendar(String dateString, String format) throws UtilException {
        Calendar startCal = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            dateFormat.setLenient(false);
            Date startDate = dateFormat.parse(dateString);
            startCal = Calendar.getInstance();
            startCal.setTime(startDate);
        }
        catch (ParseException pe) {
            throw new UtilException("DateUtil.humanReadableToCalendar - parsing error when parsing date: " + dateString + " with format : " + format + " : " + pe.getMessage());
        }
        return startCal;
    }
}

