/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.ecogrid.metacat.impl;

import edu.ucsb.nceas.metacat.DBQuery;
import edu.ucsb.nceas.metacat.DocumentImpl;
import edu.ucsb.nceas.metacat.QuerySpecification;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import java.io.File;
import java.io.FileInputStream;
import java.io.StringReader;
import java.io.Writer;
import java.rmi.RemoteException;
import org.apache.log4j.Logger;
import org.ecoinformatics.ecogrid.metacat.impl.EcogridJavaToMetacatJavaQueryTransformer;
import org.ecoinformatics.ecogrid.metacat.impl.MetacatResultsetParser;
import org.ecoinformatics.ecogrid.queryservice.query.QueryType;
import org.ecoinformatics.ecogrid.queryservice.query.QueryTypeNamespace;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetType;
import org.ecoinformatics.ecogrid.queryservice.stub.QueryServicePortType;

public class MetacatImpl
implements QueryServicePortType {
    private static final String XMLFILEPATH = "@xml.file.path@";
    private static final String DATAFILEPATH = "@data.file.path@";
    private static Logger logMetacat = Logger.getLogger((Class)MetacatImpl.class);

    public ResultsetType query(QueryType queryType) throws RemoteException {
        logMetacat.warn((Object)"start query method in grid service");
        ResultsetType resultsetType = new ResultsetType();
        try {
            EcogridJavaToMetacatJavaQueryTransformer ecogridJavaToMetacatJavaQueryTransformer = new EcogridJavaToMetacatJavaQueryTransformer();
            logMetacat.warn((Object)"before transforming query");
            QuerySpecification querySpecification = ecogridJavaToMetacatJavaQueryTransformer.transform(queryType);
            logMetacat.warn((Object)"after transforming query");
            logMetacat.warn((Object)"before creating a DBQuery object");
            DBQuery dBQuery = new DBQuery();
            logMetacat.warn((Object)"before DBQuery object searching metacat");
            boolean bl = new Boolean(PropertyService.getProperty((String)"database.usexmlindex"));
            String string = "query";
            Writer writer = null;
            String string2 = "public";
            String[] stringArray = null;
            StringBuffer stringBuffer = dBQuery.createResultDocument(string, querySpecification, writer, string2, stringArray, bl);
            logMetacat.warn((Object)"after DBQuery object searching meatacat");
            String string3 = PropertyService.getProperty((String)"xml.saxparser");
            QueryTypeNamespace[] queryTypeNamespaceArray = queryType.getNamespace();
            String[] stringArray2 = new String[queryTypeNamespaceArray.length];
            for (int i = 0; i < queryTypeNamespaceArray.length; ++i) {
                stringArray2[i] = queryTypeNamespaceArray[i].get_value();
            }
            MetacatResultsetParser metacatResultsetParser = new MetacatResultsetParser(new StringReader(stringBuffer.toString()), string3, stringArray2);
            resultsetType = metacatResultsetParser.getEcogridResult();
            logMetacat.warn((Object)"after searching result transforming to ecogrid result java object");
        }
        catch (Exception exception) {
            logMetacat.warn((Object)("The exception is: " + exception.getMessage()));
            throw new RemoteException(exception.getMessage());
        }
        return resultsetType;
    }

    public byte[] get(String string) throws RemoteException {
        byte[] byArray;
        if (string == null) {
            throw new RemoteException("Please sepcify the identifier");
        }
        logMetacat.warn((Object)"in get method");
        logMetacat.warn((Object)("identifier is " + string));
        try {
            String string2 = "public";
            String[] stringArray = null;
            byArray = this.getOuputArrayFromMetacat(string, string2, stringArray);
            logMetacat.warn((Object)"after get output array");
        }
        catch (Exception exception) {
            logMetacat.warn((Object)("in exception e" + exception.getMessage()));
            throw new RemoteException(exception.getMessage());
        }
        return byArray;
    }

    private byte[] getOuputArrayFromMetacat(String string, String string2, String[] stringArray) throws Exception {
        byte[] byArray = null;
        DocumentImpl documentImpl = new DocumentImpl(string);
        if (!DocumentImpl.hasReadPermission((String)string2, (String[])stringArray, (String)string)) {
            Exception exception = new Exception("User " + string2 + " does not have permission" + " to read the document with the docid " + string);
            throw exception;
        }
        if (documentImpl.getRootNodeID() == 0L) {
            logMetacat.warn((Object)"In data file path");
            String string3 = PropertyService.getProperty((String)"application.datafilepath");
            if (!string3.endsWith("/")) {
                string3 = string3 + "/";
            }
            String string4 = string3 + string;
            File file = new File(string4);
            int n = new Long(file.length()).intValue();
            logMetacat.warn((Object)("The size of file is: " + n));
            byArray = new byte[n];
            FileInputStream fileInputStream = null;
            fileInputStream = new FileInputStream(file);
            fileInputStream.read(byArray);
        } else {
            logMetacat.warn((Object)"In xml path");
            boolean bl = true;
            String string5 = documentImpl.toString(string2, stringArray, bl);
            byArray = string5.getBytes();
        }
        return byArray;
    }
}

