/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.ecogrid.metacat.impl;

import java.io.Reader;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.axis.types.URI;
import org.ecoinformatics.ecogrid.EcogridUtils;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetType;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetTypeRecord;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetTypeRecordReturnField;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetTypeResultsetMetadata;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetTypeResultsetMetadataNamespace;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetTypeResultsetMetadataRecordStructure;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetTypeResultsetMetadataRecordStructureReturnField;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetTypeResultsetMetadataSystem;
import org.ecoinformatics.ecogrid.queryservice.util.EcogridResultsetFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class MetacatResultsetParser
extends DefaultHandler {
    private String _parserName = null;
    private ResultsetType _ecogridResult = new ResultsetType();
    private ResultsetTypeResultsetMetadata _metadata = new ResultsetTypeResultsetMetadata();
    private ResultsetTypeRecord[] _recordList = null;
    private ResultsetTypeRecord _currentRecord = new ResultsetTypeRecord();
    private StringBuffer _textBuffer = new StringBuffer();
    private StringBuffer _namespace = new StringBuffer();
    private Vector _tmpRecordList = new Vector();
    private Vector _tmpReturnFieldList = new Vector();
    private long _number = 0L;
    private String _currentTag = null;
    private boolean _inTriple = false;
    private StringBuffer _name = new StringBuffer();
    private long _fieldCounter = 0L;
    private Hashtable _recStructIdHastable = new Hashtable();
    private String[] searchNamespace = null;
    private static final String PARAM = "param";
    private static final String TRIPLE = "triple";

    public MetacatResultsetParser(Reader reader, String string, String[] stringArray) throws Exception {
        EcogridUtils.setDebug((boolean)true);
        if (reader == null) {
            throw new Exception("couldn't find metacat resultset source");
        }
        if (string == null) {
            throw new Exception("couldn't find parsername in MetacatREsultsetParse");
        }
        this._parserName = string;
        this._ecogridResult.setSystem(new URI("http://knb.ecoinformatics.org"));
        this._ecogridResult.setResultsetId("eml.001");
        this.searchNamespace = stringArray;
        TimeZone timeZone = TimeZone.getTimeZone(System.getProperty("user.timezone"));
        Calendar calendar = Calendar.getInstance(timeZone);
        Date date = new Date();
        calendar.setTime(date);
        this._metadata.setSendTime(calendar);
        ResultsetTypeResultsetMetadataSystem[] resultsetTypeResultsetMetadataSystemArray = new ResultsetTypeResultsetMetadataSystem[]{EcogridResultsetFactory.createSystem((String)"http://ecogrid.ecoinformatics.org", (String)"0")};
        this._metadata.setSystem(resultsetTypeResultsetMetadataSystemArray);
        ResultsetTypeResultsetMetadataNamespace[] resultsetTypeResultsetMetadataNamespaceArray = new ResultsetTypeResultsetMetadataNamespace[this.searchNamespace.length];
        for (int i = 0; i < stringArray.length; ++i) {
            resultsetTypeResultsetMetadataNamespaceArray[i] = new ResultsetTypeResultsetMetadataNamespace(this.searchNamespace[i]);
        }
        this._metadata.setNamespace(resultsetTypeResultsetMetadataNamespaceArray);
        XMLReader xMLReader = this.initializeParser();
        xMLReader.parse(new InputSource(reader));
        boolean bl = false;
        ResultsetTypeResultsetMetadataRecordStructure resultsetTypeResultsetMetadataRecordStructure = new ResultsetTypeResultsetMetadataRecordStructure();
        Vector<ResultsetTypeResultsetMetadataRecordStructureReturnField> vector = new Vector<ResultsetTypeResultsetMetadataRecordStructureReturnField>();
        ResultsetTypeResultsetMetadataRecordStructureReturnField[] resultsetTypeResultsetMetadataRecordStructureReturnFieldArray = this._recStructIdHastable.keys();
        while (resultsetTypeResultsetMetadataRecordStructureReturnFieldArray.hasMoreElements()) {
            String string2 = (String)resultsetTypeResultsetMetadataRecordStructureReturnFieldArray.nextElement();
            Hashtable hashtable = (Hashtable)this._recStructIdHastable.get(string2);
            boolean bl2 = false;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                String string4 = (String)hashtable.get(string3);
                ResultsetTypeResultsetMetadataRecordStructureReturnField resultsetTypeResultsetMetadataRecordStructureReturnField = EcogridResultsetFactory.createRecordStructReturnField((String)string4, (String)string2, (String)string3);
                vector.addElement(resultsetTypeResultsetMetadataRecordStructureReturnField);
            }
        }
        resultsetTypeResultsetMetadataRecordStructureReturnFieldArray = new ResultsetTypeResultsetMetadataRecordStructureReturnField[vector.size()];
        resultsetTypeResultsetMetadataRecordStructureReturnFieldArray = vector.toArray(resultsetTypeResultsetMetadataRecordStructureReturnFieldArray);
        resultsetTypeResultsetMetadataRecordStructure.setReturnField(resultsetTypeResultsetMetadataRecordStructureReturnFieldArray);
        this._metadata.setRecordStructure(resultsetTypeResultsetMetadataRecordStructure);
    }

    private XMLReader initializeParser() throws Exception {
        XMLReader xMLReader = null;
        try {
            xMLReader = XMLReaderFactory.createXMLReader(this._parserName);
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
        }
        catch (Exception exception) {
            System.err.println("Error in QuerySpcecification.initializeParser " + exception.toString());
            throw exception;
        }
        return xMLReader;
    }

    public ResultsetType getEcogridResult() {
        return this._ecogridResult;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this._currentTag = string2;
        if (string2.equals("document")) {
            this._currentRecord = new ResultsetTypeRecord();
            ++this._number;
            this._currentRecord.setNumber(this._number);
            this._currentRecord.setSystem("0");
        } else if (string2.equals(PARAM)) {
            this.getValueOfNamedAttr(attributes, "name", this._name);
        } else if (string2.equals(TRIPLE)) {
            this._inTriple = false;
        }
        if (this._inTriple) {
            // empty if block
        }
    }

    public String getFieldId(String string, String string2) {
        String string3;
        Hashtable<String, String> hashtable = (Hashtable<String, String>)this._recStructIdHastable.get(string2);
        if (hashtable == null) {
            hashtable = new Hashtable<String, String>();
            this._recStructIdHastable.put(string2, hashtable);
        }
        if ((string3 = (String)hashtable.get(string)) == null) {
            string3 = "f" + this._fieldCounter;
            hashtable.put(string, string3);
            ++this._fieldCounter;
        }
        return string3;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string2.equals("docid")) {
            String string4 = this._textBuffer.toString();
            if (string4 != null) {
                string4 = string4.trim();
            }
            this._currentRecord.setIdentifier(string4);
        } else if (string2.equals("doctype")) {
            this._namespace.setLength(0);
            this._namespace.append(this._textBuffer.toString());
            EcogridUtils.debugMessage((String)("**** namespace[" + this._namespace + "]"));
        } else if (string2.equals("createdate")) {
            String string5 = this._textBuffer.toString();
            Calendar calendar = this.transformStringToTimestamp(string5);
            this._currentRecord.setCreationDate(calendar);
        } else if (string2.equals("updatedate")) {
            String string6 = this._textBuffer.toString();
            Calendar calendar = this.transformStringToTimestamp(string6);
            this._currentRecord.setLastModifiedDate(calendar);
        } else if (string2.equals(PARAM)) {
            String string7 = this.getFieldId(this._name.toString(), this._namespace.toString());
            ResultsetTypeRecordReturnField resultsetTypeRecordReturnField = EcogridResultsetFactory.createRecordReturnField((String)string7, (String)this._textBuffer.toString());
            this._tmpReturnFieldList.add(resultsetTypeRecordReturnField);
        } else if (string2.equals(TRIPLE)) {
            this._inTriple = false;
        } else if (string2.equals("document")) {
            ResultsetTypeRecordReturnField[] resultsetTypeRecordReturnFieldArray = new ResultsetTypeRecordReturnField[this._tmpReturnFieldList.size()];
            for (int i = 0; i < this._tmpReturnFieldList.size(); ++i) {
                resultsetTypeRecordReturnFieldArray[i] = (ResultsetTypeRecordReturnField)this._tmpReturnFieldList.elementAt(i);
            }
            this._tmpReturnFieldList.clear();
            this._currentRecord.setReturnField(resultsetTypeRecordReturnFieldArray);
            this._tmpRecordList.add(this._currentRecord);
        }
        if (this._inTriple) {
            // empty if block
        }
        this._textBuffer.setLength(0);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        while (n2 > 0 && (cArray[n] == '\n' || cArray[n] == '\r')) {
            ++n;
            --n2;
        }
        if (n2 > 0) {
            this._textBuffer.append(new String(cArray, n, n2));
        }
    }

    public void endDocument() {
        int n = this._tmpRecordList.size();
        if (n == 0) {
            this._metadata.setStartRecord((long)n);
        } else {
            this._metadata.setStartRecord(1L);
        }
        this._metadata.setEndRecord((long)n);
        this._metadata.setRecordCount((long)n);
        this._ecogridResult.setResultsetMetadata(this._metadata);
        this._recordList = new ResultsetTypeRecord[n];
        for (int i = 0; i < n; ++i) {
            ResultsetTypeRecord resultsetTypeRecord;
            this._recordList[i] = resultsetTypeRecord = (ResultsetTypeRecord)this._tmpRecordList.elementAt(i);
        }
        this._ecogridResult.setRecord(this._recordList);
    }

    private Calendar transformStringToTimestamp(String string) {
        if (string.indexOf(":") == -1) {
            string = string + " 00:00:00";
        }
        Timestamp timestamp = Timestamp.valueOf(string);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(timestamp);
        return calendar;
    }

    private boolean getValueOfNamedAttr(Attributes attributes, String string, StringBuffer stringBuffer) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string2 = attributes.getQName(i);
            String string3 = attributes.getValue(i);
            if (!string2.equals(string)) continue;
            stringBuffer.setLength(0);
            stringBuffer.append(string3);
            return true;
        }
        return false;
    }

    private boolean isNameAlreadyThere(String string, ResultsetTypeResultsetMetadataRecordStructureReturnField[] resultsetTypeResultsetMetadataRecordStructureReturnFieldArray) {
        if (string == null) {
            EcogridUtils.debugMessage((String)"isNameAlreadyThere - aName is null!");
            return false;
        }
        if (resultsetTypeResultsetMetadataRecordStructureReturnFieldArray == null) {
            EcogridUtils.debugMessage((String)"isNameAlreadyThere - aFields is null!");
            return false;
        }
        for (int i = 0; i < resultsetTypeResultsetMetadataRecordStructureReturnFieldArray.length; ++i) {
            if (!string.equals(resultsetTypeResultsetMetadataRecordStructureReturnFieldArray[i].getName())) continue;
            return true;
        }
        return false;
    }
}

