/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.AuthInterface;
import edu.ucsb.nceas.metacat.AuthTLSException;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.AuthenticationException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.ReferralException;
import javax.naming.SizeLimitExceededException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.SSLSession;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;

public class AuthLdap
implements AuthInterface {
    private String ldapUrl;
    private String ldapsUrl;
    private String ldapBase;
    private String referral;
    private String ldapConnectTimeLimit;
    private int ldapSearchTimeLimit;
    private int ldapSearchCountLimit;
    private String currentReferralInfo;
    Hashtable<String, String> env = new Hashtable(11);
    private Context rContext;
    private String userName;
    private String userPassword;
    ReferralException refExc;
    private static Logger logMetacat = Logger.getLogger(AuthLdap.class);

    public AuthLdap() throws InstantiationException {
        try {
            this.ldapUrl = PropertyService.getProperty("auth.url");
            this.ldapsUrl = PropertyService.getProperty("auth.surl");
            this.ldapBase = PropertyService.getProperty("auth.base");
            this.referral = PropertyService.getProperty("ldap.referral");
            this.ldapConnectTimeLimit = PropertyService.getProperty("ldap.connectTimeLimit");
            this.ldapSearchTimeLimit = Integer.parseInt(PropertyService.getProperty("ldap.searchTimeLimit"));
            this.ldapSearchCountLimit = Integer.parseInt(PropertyService.getProperty("ldap.searchCountLimit"));
        }
        catch (PropertyNotFoundException pnfe) {
            throw new InstantiationException("Could not instantiate AuthLdap.  Property not found: " + pnfe.getMessage());
        }
        catch (NumberFormatException nfe) {
            throw new InstantiationException("Could not instantiate AuthLdap.  Bad number format when converting properties: " + nfe.getMessage());
        }
        this.currentReferralInfo = "";
    }

    @Override
    public boolean authenticate(String user, String password) throws ConnectException {
        String ldapUrl = this.ldapUrl;
        String ldapsUrl = this.ldapsUrl;
        String ldapBase = this.ldapBase;
        boolean authenticated = false;
        String identifier = user;
        if (user.indexOf(",") == -1) {
            throw new ConnectException("Invalid LDAP user credential: " + user + ".  Missing ','");
        }
        String uid = user.substring(0, user.indexOf(","));
        user = user.substring(user.indexOf(","), user.length());
        logMetacat.debug((Object)("AuthLdap.authenticate - identifier: " + identifier + ", uid: " + uid + ", user: " + user));
        try {
            logMetacat.info((Object)("AuthLdap.authenticate - Calling ldapAuthenticate with user as identifier: " + identifier));
            authenticated = this.ldapAuthenticate(identifier, password, new Boolean(PropertyService.getProperty("ldap.onlySecureConnection")));
            if (!authenticated) {
                logMetacat.info((Object)"AuthLdap.authenticate - Not Authenticated");
                logMetacat.info((Object)("AuthLdap.authenticate - Looking up DN for: " + identifier));
                identifier = this.getIdentifyingName(identifier, ldapUrl, ldapBase);
                if (identifier == null) {
                    logMetacat.info((Object)"AuthLdap.authenticate - No DN found from getIdentifyingName");
                    return authenticated;
                }
                logMetacat.info((Object)("AuthLdap.authenticate - DN found from getIdentifyingName: " + identifier));
                String decoded = URLDecoder.decode(identifier);
                logMetacat.info((Object)("AuthLdap.authenticate - DN decoded: " + decoded));
                identifier = decoded;
                String refUrl = "";
                String refBase = "";
                if (identifier.startsWith("ldap")) {
                    logMetacat.debug((Object)"AuthLdap.authenticate - identifier starts with \"ldap\"");
                    refUrl = identifier.substring(0, identifier.lastIndexOf("/") + 1);
                    int position = identifier.indexOf(",");
                    int position2 = identifier.indexOf(",", position + 1);
                    refBase = identifier.substring(position2 + 1);
                    identifier = identifier.substring(identifier.lastIndexOf("/") + 1);
                    logMetacat.info((Object)("AuthLdap.authenticate - Calling ldapAuthenticate: with user as identifier: " + identifier + " and refUrl as: " + refUrl + " and refBase as: " + refBase));
                    authenticated = this.ldapAuthenticate(identifier, password, refUrl, refBase, new Boolean(PropertyService.getProperty("ldap.onlySecureReferalsConnection")));
                } else {
                    logMetacat.info((Object)"AuthLdap.authenticate - identifier doesnt start with ldap");
                    identifier = identifier + "," + ldapBase;
                    logMetacat.info((Object)("AuthLdap.authenticate - Calling ldapAuthenticatewith user as identifier: " + identifier));
                    authenticated = this.ldapAuthenticate(identifier, password, new Boolean(PropertyService.getProperty("ldap.onlySecureConnection")));
                }
            }
        }
        catch (NullPointerException npe) {
            logMetacat.error((Object)("AuthLdap.authenticate - NullPointerException while authenticating in AuthLdap.authenticate: " + npe));
            npe.printStackTrace();
            throw new ConnectException("AuthLdap.authenticate - NullPointerException while authenticating in AuthLdap.authenticate: " + npe);
        }
        catch (NamingException ne) {
            logMetacat.error((Object)("AuthLdap.authenticate - Naming exception while authenticating in AuthLdap.authenticate: " + ne));
            ne.printStackTrace();
        }
        catch (PropertyNotFoundException pnfe) {
            logMetacat.error((Object)("AuthLdap.authenticate - Property exception while authenticating in AuthLdap.authenticate: " + pnfe.getMessage()));
        }
        return authenticated;
    }

    private boolean ldapAuthenticate(String identifier, String password, boolean secureConnectionOnly) throws ConnectException, NamingException, NullPointerException {
        return this.ldapAuthenticate(identifier, password, this.ldapsUrl, this.ldapBase, secureConnectionOnly);
    }

    private boolean ldapAuthenticate(String dn, String password, String rootServer, String rootBase, boolean secureConnectionOnly) {
        boolean authenticated = false;
        String server = "";
        String userDN = "";
        logMetacat.info((Object)("AuthLdap.ldapAuthenticate - dn is: " + dn));
        int position = dn.lastIndexOf("/");
        logMetacat.debug((Object)("AuthLdap.ldapAuthenticate - position is: " + position));
        if (position == -1) {
            server = rootServer;
            userDN = dn.indexOf(userDN) < 0 ? dn + "," + rootBase : dn;
            logMetacat.info((Object)("AuthLdap.ldapAuthenticate - userDN is: " + userDN));
        } else {
            server = dn.substring(0, position + 1);
            userDN = dn.substring(position + 1);
            logMetacat.info((Object)("AuthLdap.ldapAuthenticate - server is: " + server));
            logMetacat.info((Object)("AuthLdap.ldapAuthenticate - userDN is: " + userDN));
        }
        logMetacat.warn((Object)("AuthLdap.ldapAuthenticate - Trying to authenticate: " + userDN + " Using server: " + server));
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", server);
            env.put("java.naming.referral", "throw");
            try {
                authenticated = this.authenticateTLS(env, userDN, password);
            }
            catch (AuthenticationException ee) {
                logMetacat.info((Object)("AuthLdap.ldapAuthenticate - failed to login : " + ee.getMessage()));
                String aliasedDn = null;
                try {
                    aliasedDn = this.getAliasedDnTLS(userDN, env);
                    if (aliasedDn != null) {
                        logMetacat.warn((Object)("AuthLdap.ldapAuthenticate - an aliased object " + aliasedDn + " was found for the DN " + userDN + ". We will try to authenticate this new DN " + aliasedDn + "."));
                        authenticated = this.authenticateTLS(env, aliasedDn, password);
                    }
                }
                catch (NamingException e) {
                    logMetacat.error((Object)("AuthLdap.ldapAuthenticate - NamingException " + e.getMessage() + " happend when the ldap server authenticated the aliased object " + aliasedDn));
                }
                catch (IOException e) {
                    logMetacat.error((Object)("AuthLdap.ldapAuthenticate - IOException " + e.getMessage() + " happend when the ldap server authenticated the aliased object " + aliasedDn));
                }
                catch (AuthTLSException e) {
                    logMetacat.error((Object)("AuthLdap.ldapAuthenticate - AuthTLSException " + e.getMessage() + " happend when the ldap server authenticated the aliased object " + aliasedDn));
                }
            }
            catch (AuthTLSException ate) {
                logMetacat.info((Object)("AuthLdap.ldapAuthenticate - error while negotiating TLS: " + ate.getMessage()));
                if (secureConnectionOnly) {
                    return authenticated;
                }
                try {
                    authenticated = this.authenticateNonTLS(env, userDN, password);
                }
                catch (AuthenticationException ae) {
                    logMetacat.warn((Object)("Authentication exception for (nonTLS): " + ae.getMessage()));
                    String aliasedDn = null;
                    try {
                        aliasedDn = this.getAliasedDnNonTLS(userDN, env);
                        if (aliasedDn != null) {
                            logMetacat.warn((Object)("AuthLdap.ldapAuthenticate(NonTLS) - an aliased object " + aliasedDn + " was found for the DN " + userDN + ". We will try to authenticate this new DN " + aliasedDn + " again."));
                            authenticated = this.authenticateNonTLS(env, aliasedDn, password);
                        }
                    }
                    catch (NamingException e) {
                        logMetacat.error((Object)("AuthLdap.ldapAuthenticate(NonTLS) - NamingException " + e.getMessage() + " happend when the ldap server authenticated the aliased object " + aliasedDn));
                    }
                    catch (IOException e) {
                        logMetacat.error((Object)("AuthLdap.ldapAuthenticate(NonTLS) - IOException " + e.getMessage() + " happend when the ldap server authenticated the aliased object " + aliasedDn));
                    }
                }
            }
        }
        catch (AuthenticationException ae) {
            logMetacat.warn((Object)("Authentication exception: " + ae.getMessage()));
            authenticated = false;
        }
        catch (InvalidNameException ine) {
            logMetacat.error((Object)("AuthLdap.ldapAuthenticate - An invalid DN was provided: " + ine.getMessage()));
        }
        catch (NamingException ne) {
            logMetacat.warn((Object)("AuthLdap.ldapAuthenticate - Caught NamingException in login: " + ne.getClass().getName()));
            logMetacat.info((Object)(ne.toString() + "  " + ne.getRootCause()));
        }
        return authenticated;
    }

    private String getAliasedDnTLS(String alias, Hashtable<String, String> env) throws NamingException, IOException {
        boolean useTLS = true;
        return this.getAliasedDn(alias, env, useTLS);
    }

    private String getAliasedDnNonTLS(String alias, Hashtable<String, String> env) throws NamingException, IOException {
        boolean useTLS = false;
        return this.getAliasedDn(alias, env, useTLS);
    }

    private String getAliasedDn(String alias, Hashtable<String, String> env, boolean useTLS) throws NamingException, IOException {
        String aliasedDn = null;
        if (env != null) {
            env.put("java.naming.referral", "ignore");
        }
        InitialLdapContext sctx = new InitialLdapContext(env, null);
        StartTlsResponse tls = null;
        if (useTLS) {
            tls = (StartTlsResponse)sctx.extendedOperation(new StartTlsRequest());
            SSLSession sSLSession = tls.negotiate();
        }
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        String filter = "(objectClass=*)";
        NamingEnumeration<SearchResult> answer = sctx.search(alias, filter, ctls);
        while (answer.hasMore()) {
            SearchResult result = answer.next();
            if (result.isRelative()) continue;
            aliasedDn = result.getNameInNamespace();
            break;
        }
        if (useTLS && tls != null) {
            tls.close();
        }
        sctx.close();
        return aliasedDn;
    }

    private boolean authenticateTLS(Hashtable<String, String> env, String userDN, String password) throws AuthTLSException, AuthenticationException {
        logMetacat.info((Object)"AuthLdap.authenticateTLS - Trying to authenticate with TLS");
        try {
            InitialLdapContext ctx = null;
            double startTime = System.currentTimeMillis();
            ctx = new InitialLdapContext(env, null);
            StartTlsResponse tls = (StartTlsResponse)ctx.extendedOperation(new StartTlsRequest());
            SSLSession sess = tls.negotiate();
            ctx.addToEnvironment("java.naming.security.authentication", "simple");
            ctx.addToEnvironment("java.naming.security.principal", userDN);
            ctx.addToEnvironment("java.naming.security.credentials", password);
            ctx.reconnect(null);
            double stopTime = System.currentTimeMillis();
            logMetacat.info((Object)("AuthLdap.authenticateTLS - Connection time thru " + this.ldapsUrl + " was: " + (stopTime - startTime) / 1000.0 + " seconds."));
        }
        catch (AuthenticationException ae) {
            logMetacat.warn((Object)("AuthLdap.authenticateTLS - Authentication exception: " + ae.getMessage()));
            throw ae;
        }
        catch (NamingException ne) {
            throw new AuthTLSException("AuthLdap.authenticateTLS - Naming error when athenticating via TLS: " + ne.getMessage());
        }
        catch (IOException ioe) {
            throw new AuthTLSException("AuthLdap.authenticateTLS - I/O error when athenticating via TLS: " + ioe.getMessage());
        }
        return true;
    }

    private boolean authenticateNonTLS(Hashtable<String, String> env, String userDN, String password) throws NamingException {
        InitialLdapContext ctx = null;
        logMetacat.info((Object)"AuthLdap.authenticateNonTLS - Trying to authenticate without TLS");
        double startTime = System.currentTimeMillis();
        ctx = new InitialLdapContext(env, null);
        ctx.addToEnvironment("java.naming.security.authentication", "simple");
        ctx.addToEnvironment("java.naming.security.principal", userDN);
        ctx.addToEnvironment("java.naming.security.credentials", password);
        ctx.reconnect(null);
        double stopTime = System.currentTimeMillis();
        logMetacat.info((Object)("AuthLdap.authenticateNonTLS - Connection time thru " + this.ldapsUrl + " was: " + (stopTime - startTime) / 1000.0 + " seconds."));
        return true;
    }

    private String getIdentifyingName(String user, String ldapUrl, String ldapBase) throws NamingException {
        String identifier = null;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.referral", "throw");
        env.put("java.naming.provider.url", ldapUrl + ldapBase);
        try {
            int position = user.indexOf(",");
            String uid = user.substring(user.indexOf("=") + 1, position);
            logMetacat.info((Object)("AuthLdap.getIdentifyingName - uid is: " + uid));
            String org = user.substring(user.indexOf("=", position + 1) + 1, user.indexOf(",", position + 1));
            logMetacat.info((Object)("AuthLdap.getIdentifyingName - org is: " + org));
            DirContext sctx = new InitialDirContext(env);
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            String filter = "(&(uid=" + uid + ")(o=" + org + "))";
            logMetacat.warn((Object)("AuthLdap.getIdentifyingName - Searching for DNs with following filter: " + filter));
            boolean moreReferrals = true;
            while (moreReferrals) {
                try {
                    NamingEnumeration<SearchResult> answer = sctx.search("", filter, ctls);
                    if (answer.hasMore()) {
                        SearchResult sr = answer.next();
                        identifier = sr.getName();
                        return identifier;
                    }
                    moreReferrals = false;
                }
                catch (ReferralException e) {
                    logMetacat.info((Object)("AuthLdap.getIdentifyingName - Got referral: " + e.getReferralInfo()));
                    if (!moreReferrals) continue;
                    boolean referralError = true;
                    while (referralError) {
                        try {
                            sctx = (DirContext)e.getReferralContext();
                            referralError = false;
                        }
                        catch (NamingException ne) {
                            logMetacat.error((Object)("NamingException when getting referral contex. Skipping this referral. " + ne.getMessage()));
                            e.skipReferral();
                            referralError = true;
                        }
                    }
                }
            }
        }
        catch (NamingException e) {
            logMetacat.error((Object)("AuthLdap.getIdentifyingName - Naming exception while getting dn: " + e));
            throw new NamingException("Naming exception in AuthLdap.getIdentifyingName: " + e);
        }
        return identifier;
    }

    @Override
    public String[][] getUsers(String user, String password) throws ConnectException {
        String[][] users = null;
        Hashtable<String, String> env = new Hashtable<String, String>(11);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.referral", this.referral);
        env.put("java.naming.provider.url", this.ldapUrl);
        env.put("com.sun.jndi.ldap.connect.timeout", this.ldapConnectTimeLimit);
        try {
            InitialDirContext ctx = new InitialDirContext(env);
            SearchControls ctls = new SearchControls();
            String[] attrIDs = new String[]{"dn", "cn", "o", "ou", "mail"};
            ctls.setReturningAttributes(attrIDs);
            ctls.setSearchScope(2);
            ctls.setTimeLimit(this.ldapSearchTimeLimit);
            String filter = "(objectClass=inetOrgPerson)";
            NamingEnumeration<SearchResult> namingEnum = ctx.search(this.ldapBase, filter, ctls);
            Vector<String> uvec = new Vector<String>();
            Vector<String> uname = new Vector<String>();
            Vector<String> uorg = new Vector<String>();
            Vector<String> uou = new Vector<String>();
            Vector<String> umail = new Vector<String>();
            Attributes tempAttr = null;
            try {
                while (namingEnum.hasMore()) {
                    SearchResult sr = namingEnum.next();
                    tempAttr = sr.getAttributes();
                    if ((tempAttr.get("cn") + "").startsWith("cn: ")) {
                        uname.add((tempAttr.get("cn") + "").substring(4));
                    } else {
                        uname.add(tempAttr.get("cn") + "");
                    }
                    if ((tempAttr.get("o") + "").startsWith("o: ")) {
                        uorg.add((tempAttr.get("o") + "").substring(3));
                    } else {
                        uorg.add(tempAttr.get("o") + "");
                    }
                    if ((tempAttr.get("ou") + "").startsWith("ou: ")) {
                        uou.add((tempAttr.get("ou") + "").substring(4));
                    } else {
                        uou.add(tempAttr.get("ou") + "");
                    }
                    if ((tempAttr.get("mail") + "").startsWith("mail: ")) {
                        umail.add((tempAttr.get("mail") + "").substring(6));
                    } else {
                        umail.add(tempAttr.get("mail") + "");
                    }
                    uvec.add(sr.getName() + "," + this.ldapBase);
                }
            }
            catch (SizeLimitExceededException slee) {
                logMetacat.error((Object)"AuthLdap.getUsers - LDAP Server size limit exceeded. Returning incomplete record set.");
            }
            users = new String[uvec.size()][5];
            for (int i = 0; i < uvec.size(); ++i) {
                users[i][0] = (String)uvec.elementAt(i);
                users[i][1] = (String)uname.elementAt(i);
                users[i][2] = (String)uorg.elementAt(i);
                users[i][3] = (String)uorg.elementAt(i);
                users[i][4] = (String)umail.elementAt(i);
            }
            ctx.close();
        }
        catch (NamingException e) {
            logMetacat.error((Object)("AuthLdap.getUsers - Problem getting users in AuthLdap.getUsers:" + e));
        }
        return users;
    }

    @Override
    public String[] getUserInfo(String user, String password) throws ConnectException {
        String[] userinfo = new String[3];
        logMetacat.info((Object)("AuthLdap.getUserInfo - get the user info for user  " + user));
        Hashtable<String, String> env = new Hashtable<String, String>(11);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.ldapUrl);
        String realName = null;
        try {
            realName = this.getAliasedDnNonTLS(user, env);
        }
        catch (Exception e) {
            logMetacat.warn((Object)("AuthLdap.getUserInfo - can't get the alias name for the user " + user + " since " + e.getMessage()));
        }
        logMetacat.info((Object)("AuthLdap.getUserInfo - the aliased dn for " + user + " is " + realName));
        if (realName != null) {
            user = realName;
        }
        try {
            env.put("java.naming.referral", this.referral);
            InitialDirContext ctx = new InitialDirContext(env);
            SearchControls ctls = new SearchControls();
            String[] attrIDs = new String[]{"cn", "o", "mail"};
            ctls.setReturningAttributes(attrIDs);
            ctls.setSearchScope(2);
            String filter = null;
            filter = "(&(" + user.substring(0, user.indexOf(",")) + "))";
            NamingEnumeration<SearchResult> namingEnum = ctx.search(user, filter, ctls);
            Attributes tempAttr = null;
            try {
                while (namingEnum.hasMore()) {
                    SearchResult sr = namingEnum.next();
                    tempAttr = sr.getAttributes();
                    userinfo[0] = (tempAttr.get("cn") + "").startsWith("cn: ") ? (tempAttr.get("cn") + "").substring(4) : tempAttr.get("cn") + "";
                    userinfo[1] = (tempAttr.get("o") + "").startsWith("o: ") ? (tempAttr.get("o") + "").substring(3) : tempAttr.get("o") + "";
                    if ((tempAttr.get("mail") + "").startsWith("mail: ")) {
                        userinfo[2] = (tempAttr.get("mail") + "").substring(6);
                        continue;
                    }
                    userinfo[2] = tempAttr.get("mail") + "";
                }
            }
            catch (SizeLimitExceededException slee) {
                logMetacat.error((Object)"AuthLdap.getUserInfo - LDAP Server size limit exceeded. Returning incomplete record set.");
            }
            ctx.close();
        }
        catch (NamingException e) {
            logMetacat.error((Object)("AuthLdap.getUserInfo - Problem getting users:" + e));
            throw new ConnectException("Problem getting users in AuthLdap.getUsers:" + e);
        }
        return userinfo;
    }

    @Override
    public String[] getUsers(String user, String password, String group) throws ConnectException {
        String[] users = null;
        Hashtable<String, String> env = new Hashtable<String, String>(11);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.referral", this.referral);
        env.put("java.naming.provider.url", this.ldapUrl);
        try {
            InitialDirContext ctx = new InitialDirContext(env);
            String[] attrIDs = new String[]{"uniqueMember"};
            Attributes answer = ctx.getAttributes(group, attrIDs);
            Vector uvec = new Vector();
            try {
                NamingEnumeration<? extends Attribute> ae = answer.getAll();
                while (ae.hasMore()) {
                    Attribute attr = ae.next();
                    NamingEnumeration<?> e = attr.getAll();
                    while (e.hasMore()) {
                        uvec.add(e.next());
                    }
                }
            }
            catch (SizeLimitExceededException slee) {
                logMetacat.error((Object)"AuthLdap.getUsers - LDAP Server size limit exceeded. Returning incomplete record set.");
            }
            users = new String[uvec.size()];
            for (int i = 0; i < uvec.size(); ++i) {
                users[i] = (String)uvec.elementAt(i);
            }
            ctx.close();
        }
        catch (NamingException e) {
            logMetacat.error((Object)("AuthLdap.getUsers - Problem getting users for a group in AuthLdap.getUsers:" + e));
        }
        return users;
    }

    @Override
    public String[][] getGroups(String user, String password) throws ConnectException {
        return this.getGroups(user, password, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[][] getGroups(String user, String password, String foruser) throws ConnectException {
        logMetacat.debug((Object)"AuthLdap.getGroups - getGroups() called.");
        Vector<String> gvec = new Vector<String>();
        Vector<String> desc = new Vector<String>();
        Attributes tempAttr = null;
        Attributes rsrAttr = null;
        this.userName = user;
        this.userPassword = password;
        this.env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        this.env.put("java.naming.referral", "throw");
        this.env.put("java.naming.provider.url", this.ldapUrl);
        this.env.put("com.sun.jndi.ldap.connect.timeout", this.ldapConnectTimeLimit);
        try {
            DirContext ctx = new InitialDirContext(this.env);
            SearchControls ctls = new SearchControls();
            String[] attrIDs = new String[]{"cn", "o", "description"};
            ctls.setReturningAttributes(attrIDs);
            ctls.setSearchScope(2);
            ctls.setTimeLimit(this.ldapSearchTimeLimit);
            ctls.setCountLimit(this.ldapSearchCountLimit);
            String filter = null;
            String gfilter = "(objectClass=groupOfUniqueNames)";
            filter = null == foruser ? gfilter : "(& " + gfilter + "(uniqueMember=" + foruser + "))";
            logMetacat.info((Object)("AuthLdap.getGroups - group filter is: " + filter));
            boolean moreReferrals = true;
            while (moreReferrals) {
                try {
                    NamingEnumeration<SearchResult> namingEnum = ctx.search(this.ldapBase, filter, ctls);
                    while (namingEnum.hasMore()) {
                        SearchResult sr = namingEnum.next();
                        tempAttr = sr.getAttributes();
                        if ((tempAttr.get("description") + "").startsWith("description: ")) {
                            desc.add((tempAttr.get("description") + "").substring(13));
                        } else {
                            desc.add(tempAttr.get("description") + "");
                        }
                        if (!sr.getName().startsWith("ldap") && sr.isRelative()) {
                            logMetacat.debug((Object)"AuthLdap.getGroups - Search result entry is relative ...");
                            gvec.add(sr.getName() + "," + this.ldapBase);
                            logMetacat.info((Object)("AuthLdap.getGroups - group " + sr.getName() + "," + this.ldapBase + " added to the group vector"));
                            continue;
                        }
                        logMetacat.debug((Object)"AuthLdap.getGroups - Search result entry is absolute ...");
                        Hashtable<String, String> envHash = new Hashtable<String, String>(11);
                        envHash.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                        envHash.put("java.naming.referral", "ignore");
                        envHash.put("java.naming.provider.url", this.ldapUrl);
                        envHash.put("com.sun.jndi.ldap.connect.timeout", this.ldapConnectTimeLimit);
                        try {
                            InitialDirContext DirCtx = new InitialDirContext(envHash);
                            SearchControls searchCtls = new SearchControls();
                            String[] attrNames = new String[]{"o"};
                            searchCtls.setReturningAttributes(attrNames);
                            searchCtls.setSearchScope(1);
                            searchCtls.setTimeLimit(this.ldapSearchTimeLimit);
                            searchCtls.setCountLimit(this.ldapSearchCountLimit);
                            String rFilter = "(&(objectClass=referral)(ref=" + this.currentReferralInfo.substring(0, this.currentReferralInfo.indexOf("?")) + "))";
                            logMetacat.debug((Object)("AuthLdap.getGroups - rFilter is: " + rFilter));
                            NamingEnumeration<SearchResult> rNamingEnum = DirCtx.search(this.ldapBase, rFilter, searchCtls);
                            while (rNamingEnum.hasMore()) {
                                SearchResult rsr = rNamingEnum.next();
                                rsrAttr = rsr.getAttributes();
                                logMetacat.debug((Object)("AuthLdap.getGroups - referral search result is: " + rsr.toString()));
                                if ((tempAttr.get("cn") + "").startsWith("cn: ")) {
                                    gvec.add("cn=" + (tempAttr.get("cn") + "").substring(4) + "," + "o=" + (rsrAttr.get("o") + "").substring(3) + "," + this.ldapBase);
                                    logMetacat.info((Object)("AuthLdap.getGroups - group " + (tempAttr.get("cn") + "").substring(4) + "," + "o=" + (rsrAttr.get("o") + "").substring(3) + "," + this.ldapBase + " added to the group vector"));
                                    continue;
                                }
                                gvec.add("cn=" + tempAttr.get("cn") + "," + "o=" + rsrAttr.get("o") + "," + this.ldapBase);
                                logMetacat.info((Object)("AuthLdap.getGroups - group cn=" + tempAttr.get("cn") + "," + "o=" + rsrAttr.get("o") + "," + this.ldapBase + " added to the group vector"));
                            }
                        }
                        catch (NamingException nameEx) {
                            logMetacat.debug((Object)"AuthLdap.getGroups - Caught naming exception: ");
                            nameEx.printStackTrace(System.err);
                        }
                    }
                    moreReferrals = false;
                }
                catch (ReferralException re) {
                    logMetacat.info((Object)("AuthLdap.getGroups -  caught referral exception: " + re.getReferralInfo()));
                    this.currentReferralInfo = (String)re.getReferralInfo();
                    moreReferrals = true;
                    boolean referralError = true;
                    while (referralError) {
                        try {
                            ctx = (DirContext)re.getReferralContext();
                            referralError = false;
                        }
                        catch (NamingException ne) {
                            logMetacat.error((Object)("NamingException when getting referral contex. Skipping this referral. " + ne.getMessage()));
                            re.skipReferral();
                            referralError = true;
                        }
                    }
                }
            }
            ctx.close();
        }
        catch (NamingException e) {
            try {
                logMetacat.info((Object)"AuthLdap.getGroups - caught naming exception: ");
                e.printStackTrace(System.err);
            }
            catch (Throwable throwable) {
                logMetacat.warn((Object)("AuthLdap.getGroups - The user is in the following groups: " + gvec.toString()));
                String[][] groups = new String[gvec.size()][2];
                for (int i = 0; i < gvec.size(); ++i) {
                    groups[i][0] = (String)gvec.elementAt(i);
                    groups[i][1] = (String)desc.elementAt(i);
                }
                return groups;
            }
            logMetacat.warn((Object)("AuthLdap.getGroups - The user is in the following groups: " + gvec.toString()));
            String[][] groups = new String[gvec.size()][2];
            for (int i = 0; i < gvec.size(); ++i) {
                groups[i][0] = (String)gvec.elementAt(i);
                groups[i][1] = (String)desc.elementAt(i);
            }
            return groups;
        }
        logMetacat.warn((Object)("AuthLdap.getGroups - The user is in the following groups: " + gvec.toString()));
        String[][] groups = new String[gvec.size()][2];
        for (int i = 0; i < gvec.size(); ++i) {
            groups[i][0] = (String)gvec.elementAt(i);
            groups[i][1] = (String)desc.elementAt(i);
        }
        return groups;
    }

    @Override
    public HashMap<String, Vector<String>> getAttributes(String foruser) throws ConnectException {
        return this.getAttributes(null, null, foruser);
    }

    @Override
    public HashMap<String, Vector<String>> getAttributes(String user, String password, String foruser) throws ConnectException {
        HashMap<String, Vector<String>> attributes = new HashMap<String, Vector<String>>();
        String ldapUrl = this.ldapUrl;
        String ldapBase = this.ldapBase;
        String userident = foruser;
        Hashtable<String, String> env = new Hashtable<String, String>(11);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.referral", this.referral);
        env.put("java.naming.provider.url", ldapUrl);
        try {
            InitialDirContext ctx = new InitialDirContext(env);
            Attributes attrs = ctx.getAttributes(foruser);
            NamingEnumeration<? extends Attribute> en = attrs.getAll();
            while (en.hasMore()) {
                Attribute att = en.next();
                Vector<String> values = new Vector<String>();
                String attName = att.getID();
                NamingEnumeration<?> attvalues = att.getAll();
                while (attvalues.hasMore()) {
                    try {
                        String value = (String)attvalues.next();
                        values.add(value);
                    }
                    catch (ClassCastException cce) {
                        logMetacat.debug((Object)("Could not cast LDAP attribute (" + attName + ") to a String value, so skipping."));
                    }
                }
                attributes.put(attName, values);
            }
            ctx.close();
        }
        catch (NamingException e) {
            logMetacat.error((Object)("AuthLdap.getAttributes - Problem getting attributes:" + e));
            throw new ConnectException("Problem getting attributes in AuthLdap.getAttributes:" + e);
        }
        return attributes;
    }

    private Hashtable getSubtrees(String user, String password, String ldapUrl, String ldapBase) throws ConnectException {
        logMetacat.debug((Object)("AuthLdap.getSubtrees - getting subtrees for user: " + user + ", ldapUrl: " + ldapUrl + ", ldapBase: " + ldapBase));
        Hashtable<String, String> trees = new Hashtable<String, String>();
        Hashtable<String, String> env = new Hashtable<String, String>(11);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.referral", "ignore");
        env.put("java.naming.provider.url", ldapUrl + ldapBase);
        try {
            InitialDirContext ctx = new InitialDirContext(env);
            String[] attrIDs = new String[]{"o", "ref"};
            SearchControls ctls = new SearchControls();
            ctls.setReturningAttributes(attrIDs);
            ctls.setSearchScope(2);
            String filter = "(|(objectclass=organization)(objectclass=referral))";
            NamingEnumeration<SearchResult> namingEnum = ctx.search("", filter, ctls);
            while (namingEnum.hasMore()) {
                SearchResult sr = namingEnum.next();
                logMetacat.debug((Object)("AuthLdap.getSubtrees - search result: " + sr.toString()));
                Attributes attrs = sr.getAttributes();
                NamingEnumeration<? extends Attribute> enum1 = attrs.getAll();
                if (!enum1.hasMore()) continue;
                Attribute attr = enum1.next();
                String attrValue = (String)attr.get();
                String attrName = attr.getID();
                if (enum1.hasMore()) {
                    attr = enum1.next();
                    String refValue = (String)attr.get();
                    String refName = attr.getID();
                    if (ldapBase.startsWith(refName + "=" + refValue)) {
                        trees.put(ldapBase, attrValue.substring(0, attrValue.lastIndexOf("/") + 1));
                        continue;
                    }
                    trees.put("[" + refName + "=" + refValue + "]" + attrValue.substring(attrValue.lastIndexOf("/") + 1, attrValue.length()), attrValue.substring(0, attrValue.lastIndexOf("/") + 1));
                    continue;
                }
                if (ldapBase.startsWith(attrName + "=" + attrValue)) {
                    trees.put(ldapBase, ldapUrl);
                    continue;
                }
                if (sr.isRelative()) {
                    trees.put(attrName + "=" + attrValue + "," + ldapBase, ldapUrl);
                    continue;
                }
                String referenceURL = sr.getName();
                referenceURL = referenceURL.substring(0, referenceURL.lastIndexOf("/") + 1);
                trees.put(attrName + "=" + attrValue + "," + ldapBase, referenceURL);
            }
            ctx.close();
        }
        catch (NamingException e) {
            logMetacat.error((Object)("AuthLdap.getSubtrees - Problem getting subtrees in AuthLdap.getSubtrees:" + e));
            throw new ConnectException("Problem getting subtrees in AuthLdap.getSubtrees:" + e);
        }
        return trees;
    }

    @Override
    public String getPrincipals(String user, String password) throws ConnectException {
        StringBuffer out = new StringBuffer();
        out.append("<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>\n");
        out.append("<principals>\n");
        Hashtable subtrees = this.getSubtrees(user, password, this.ldapUrl, this.ldapBase);
        Enumeration keyEnum = subtrees.keys();
        while (keyEnum.hasMoreElements()) {
            this.ldapBase = (String)keyEnum.nextElement();
            this.ldapUrl = (String)subtrees.get(this.ldapBase);
            logMetacat.info((Object)("AuthLdap.getPrincipals - ldapBase: " + this.ldapBase + ", ldapUrl: " + this.ldapUrl));
            String orgName = this.ldapBase;
            if (orgName.startsWith("[")) {
                this.ldapBase = orgName.substring(orgName.indexOf("]") + 1);
                if (orgName != null && orgName.indexOf("o=") > -1) {
                    orgName = orgName.substring(orgName.indexOf("o=") + 2);
                    orgName = orgName.substring(0, orgName.indexOf("]"));
                }
            } else if (orgName != null && orgName.indexOf("o=") > -1 && (orgName = orgName.substring(orgName.indexOf("o=") + 2)).indexOf(",") > -1) {
                orgName = orgName.substring(0, orgName.indexOf(","));
            }
            logMetacat.info((Object)("AuthLdap.getPrincipals - org name is  " + orgName));
            orgName = StringEscapeUtils.escapeXml((String)orgName);
            logMetacat.info((Object)("AuthLdap.getPrincipals - org name (after the xml escaping) is  " + orgName));
            out.append("  <authSystem URI=\"" + this.ldapUrl + this.ldapBase + "\" organization=\"" + orgName + "\">\n");
            String[][] groups = this.getGroups(user, password);
            logMetacat.debug((Object)("AuthLdap.getPrincipals - after getting groups " + groups));
            String[][] users = this.getUsers(user, password);
            logMetacat.debug((Object)("AuthLdap.getPrincipals - after getting users " + users));
            int userIndex = 0;
            if (groups != null && users != null && groups.length > 0) {
                for (int i = 0; i < groups.length; ++i) {
                    out.append("    <group>\n");
                    out.append("      <groupname>" + StringEscapeUtils.escapeXml((String)groups[i][0]) + "</groupname>\n");
                    out.append("      <description>" + StringEscapeUtils.escapeXml((String)groups[i][1]) + "</description>\n");
                    String[] usersForGroup = this.getUsers(user, password, groups[i][0]);
                    for (int j = 0; j < usersForGroup.length; ++j) {
                        userIndex = AuthLdap.searchUser(usersForGroup[j], users);
                        out.append("      <user>\n");
                        if (userIndex < 0) {
                            out.append("        <username>" + StringEscapeUtils.escapeXml((String)usersForGroup[j]) + "</username>\n");
                        } else {
                            out.append("        <username>" + StringEscapeUtils.escapeXml((String)users[userIndex][0]) + "</username>\n");
                            out.append("        <name>" + StringEscapeUtils.escapeXml((String)users[userIndex][1]) + "</name>\n");
                            out.append("        <organization>" + StringEscapeUtils.escapeXml((String)users[userIndex][2]) + "</organization>\n");
                            if (users[userIndex][3].compareTo("null") != 0) {
                                out.append("      <organizationUnitName>" + StringEscapeUtils.escapeXml((String)users[userIndex][3]) + "</organizationUnitName>\n");
                            }
                            out.append("        <email>" + StringEscapeUtils.escapeXml((String)users[userIndex][4]) + "</email>\n");
                        }
                        out.append("      </user>\n");
                    }
                    out.append("    </group>\n");
                }
            }
            if (users != null) {
                for (int j = 0; j < users.length; ++j) {
                    out.append("    <user>\n");
                    out.append("      <username>" + StringEscapeUtils.escapeXml((String)users[j][0]) + "</username>\n");
                    out.append("      <name>" + StringEscapeUtils.escapeXml((String)users[j][1]) + "</name>\n");
                    out.append("      <organization>" + StringEscapeUtils.escapeXml((String)users[j][2]) + "</organization>\n");
                    if (users[j][3].compareTo("null") != 0) {
                        out.append("      <organizationUnitName>" + StringEscapeUtils.escapeXml((String)users[j][3]) + "</organizationUnitName>\n");
                    }
                    out.append("      <email>" + StringEscapeUtils.escapeXml((String)users[j][4]) + "</email>\n");
                    out.append("    </user>\n");
                }
            }
            out.append("  </authSystem>\n");
        }
        out.append("</principals>");
        return out.toString();
    }

    public static int searchUser(String user, String[][] userGroup) {
        for (int j = 0; j < userGroup.length; ++j) {
            if (user.compareTo(userGroup[j][0]) != 0) continue;
            return j;
        }
        return -1;
    }

    public void testCredentials(String dn, String password, String rootServer, String rootBase) throws NamingException {
        String server = "";
        String userDN = "";
        logMetacat.debug((Object)("dn is: " + dn));
        int position = dn.lastIndexOf("/");
        logMetacat.debug((Object)("AuthLdap.testCredentials - position is: " + position));
        if (position == -1) {
            server = rootServer;
            userDN = dn.indexOf(userDN) < 0 ? dn + "," + rootBase : dn;
            logMetacat.debug((Object)("AuthLdap.testCredentials - userDN is: " + userDN));
        } else {
            server = dn.substring(0, position + 1);
            userDN = dn.substring(position + 1);
            logMetacat.debug((Object)("AuthLdap.testCredentials - server is: " + server));
            logMetacat.debug((Object)("AuthLdap.testCredentials - userDN is: " + userDN));
        }
        logMetacat.debug((Object)("AuthLdap.testCredentials - Trying to authenticate: " + userDN + " using server: " + server));
        InitialLdapContext ctx = null;
        this.env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        this.env.put("java.naming.referral", "follow");
        this.env.put("java.naming.security.authentication", "simple");
        this.env.put("java.naming.security.principal", userDN);
        this.env.put("java.naming.security.credentials", password);
        this.env.put("java.naming.provider.url", rootServer);
        ctx = new InitialLdapContext(this.env, null);
    }

    public static void main(String[] args) {
        String user = args[0];
        String password = args[1];
        String org = args[2];
        logMetacat.warn((Object)"AuthLdap.main - Creating session...");
        AuthLdap authservice = null;
        try {
            authservice = new AuthLdap();
        }
        catch (Exception e) {
            logMetacat.error((Object)("AuthLdap.main - Could not instantiate AuthLdap: " + e.getMessage()));
            return;
        }
        logMetacat.warn((Object)"AuthLdap.main - Session exists...");
        boolean isValid = false;
        try {
            String[][] users;
            logMetacat.warn((Object)"AuthLdap.main - Authenticating...");
            isValid = authservice.authenticate(user, password);
            if (isValid) {
                logMetacat.warn((Object)("AuthLdap.main - Authentication successful for: " + user));
            } else {
                logMetacat.warn((Object)("AuthLdap.main - Authentication failed for: " + user));
            }
            if (isValid) {
                logMetacat.info((Object)"AuthLdap.main - Getting attributes for user....");
                HashMap<String, Vector<String>> userInfo = authservice.getAttributes(user, password, user);
                for (String att : userInfo.keySet()) {
                    Vector<String> values = userInfo.get(att);
                    for (String value : values) {
                        logMetacat.warn((Object)("AuthLdap.main - " + att + ": " + value));
                    }
                }
            }
            if (isValid) {
                logMetacat.warn((Object)"AuthLdap.main - Getting all groups....");
                String[][] groups = authservice.getGroups(user, password);
                logMetacat.info((Object)("AuthLdap.main - Groups found: " + groups.length));
                for (int i = 0; i < groups.length; ++i) {
                    logMetacat.info((Object)("AuthLdap.main - Group " + i + ": " + groups[i][0]));
                }
            }
            String savedGroup = null;
            if (isValid) {
                logMetacat.warn((Object)"AuthLdap.main - Getting groups for user....");
                String[][] groups = authservice.getGroups(user, password, user);
                logMetacat.info((Object)("AuthLdap.main - Groups found: " + groups.length));
                for (int i = 0; i < groups.length; ++i) {
                    logMetacat.info((Object)("AuthLdap.main - Group " + i + ": " + groups[i][0]));
                    savedGroup = groups[i][0];
                }
            }
            if (isValid) {
                logMetacat.warn((Object)"AuthLdap.main - Getting users for group....");
                logMetacat.info((Object)("AuthLdap.main - Group: " + savedGroup));
                users = authservice.getUsers(user, password, savedGroup);
                logMetacat.info((Object)("AuthLdap.main - Users found: " + users.length));
                for (int i = 0; i < users.length; ++i) {
                    logMetacat.warn((Object)("AuthLdap.main - User " + i + ": " + (String)users[i]));
                }
            }
            if (isValid) {
                logMetacat.warn((Object)"AuthLdap.main - Getting all users ....");
                users = authservice.getUsers(user, password);
                logMetacat.info((Object)("AuthLdap.main - Users found: " + users.length));
            }
            if (isValid) {
                logMetacat.warn((Object)"AuthLdap.main - Trying principals....");
                authservice = new AuthLdap();
                String out = authservice.getPrincipals(user, password);
                File f = new File("principals.xml");
                FileWriter fw = new FileWriter(f);
                BufferedWriter buff = new BufferedWriter(fw);
                buff.write(out);
                buff.flush();
                buff.close();
                fw.close();
                logMetacat.warn((Object)"AuthLdap.main - Finished getting principals.");
            }
        }
        catch (ConnectException ce) {
            logMetacat.error((Object)("AuthLdap.main - " + ce.getMessage()));
        }
        catch (IOException ioe) {
            logMetacat.error((Object)("AuthLdap.main - I/O Error writing to file principals.txt: " + ioe.getMessage()));
        }
        catch (InstantiationException ie) {
            logMetacat.error((Object)("AuthLdap.main - Instantiation error writing to file principals.txt: " + ie.getMessage()));
        }
    }
}

