/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.database;

import edu.ucsb.nceas.dbadapter.AbstractDatabase;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.shared.BaseService;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import org.apache.log4j.Logger;

public class DatabaseService
extends BaseService {
    private static DatabaseService databaseService = null;
    private static AbstractDatabase dbAdapter;
    private static Logger logMetacat;

    private DatabaseService() {
        try {
            dbAdapter = (AbstractDatabase)DatabaseService.createObject(PropertyService.getProperty("database.adapter"));
        }
        catch (Exception e) {
            logMetacat.error((Object)("Could not create dbAdaptor" + e.getMessage()));
            e.printStackTrace();
        }
    }

    public static DatabaseService getInstance() {
        if (databaseService == null) {
            databaseService = new DatabaseService();
        }
        return databaseService;
    }

    @Override
    public boolean refreshable() {
        return false;
    }

    @Override
    public void doRefresh() throws ServiceException {
    }

    @Override
    public void stop() throws ServiceException {
    }

    public static Object createObject(String className) throws Exception {
        Object object = null;
        try {
            Class<?> classDefinition = Class.forName(className);
            object = classDefinition.newInstance();
        }
        catch (InstantiationException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        return object;
    }

    public AbstractDatabase getDBAdapter() {
        return dbAdapter;
    }

    static {
        logMetacat = Logger.getLogger(DatabaseService.class);
    }
}

