/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.dataone;

import edu.ucsb.nceas.ezid.EZIDClient;
import edu.ucsb.nceas.ezid.EZIDException;
import edu.ucsb.nceas.ezid.profile.DataCiteProfile;
import edu.ucsb.nceas.ezid.profile.DataCiteProfileResourceTypeValues;
import edu.ucsb.nceas.ezid.profile.ErcMissingValueCode;
import edu.ucsb.nceas.ezid.profile.InternalProfile;
import edu.ucsb.nceas.ezid.profile.InternalProfileValues;
import edu.ucsb.nceas.metacat.dataone.MNodeService;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.apache.wicket.protocol.http.mock.MockHttpServletRequest;
import org.dataone.client.v2.itk.D1Client;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.Permission;
import org.dataone.service.types.v1.Person;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.SubjectInfo;
import org.dataone.service.types.v1.util.AuthUtils;
import org.dataone.service.types.v2.Node;
import org.dataone.service.types.v2.ObjectFormat;
import org.dataone.service.types.v2.SystemMetadata;
import org.ecoinformatics.datamanager.parser.DataPackage;
import org.ecoinformatics.datamanager.parser.generic.Eml200DataPackageParser;

public class DOIService {
    private Logger logMetacat = Logger.getLogger(DOIService.class);
    private boolean doiEnabled = false;
    private String shoulder = null;
    private String ezidUsername = null;
    private String ezidPassword = null;
    private EZIDClient ezid = null;
    private Date lastLogin = null;
    private long loginPeriod = 86400000L;
    private static DOIService instance = null;

    public static DOIService getInstance() {
        if (instance == null) {
            instance = new DOIService();
        }
        return instance;
    }

    private DOIService() {
        String ezidServiceBaseUrl = null;
        try {
            this.doiEnabled = new Boolean(PropertyService.getProperty("guid.ezid.enabled"));
            this.shoulder = PropertyService.getProperty("guid.ezid.doishoulder.1");
            ezidServiceBaseUrl = PropertyService.getProperty("guid.ezid.baseurl");
            this.ezidUsername = PropertyService.getProperty("guid.ezid.username");
            this.ezidPassword = PropertyService.getProperty("guid.ezid.password");
        }
        catch (PropertyNotFoundException e) {
            this.logMetacat.warn((Object)"DOI support is not configured at this node.", (Throwable)e);
            return;
        }
        this.ezid = new EZIDClient(ezidServiceBaseUrl);
    }

    private void refreshLogin() throws EZIDException {
        Date now = Calendar.getInstance().getTime();
        if (this.lastLogin == null || now.getTime() - this.lastLogin.getTime() > this.loginPeriod) {
            this.ezid.login(this.ezidUsername, this.ezidPassword);
            this.lastLogin = now;
        }
    }

    public boolean registerDOI(SystemMetadata sysMeta) throws EZIDException, NotImplemented, ServiceFailure, InterruptedException {
        String identifier;
        if (this.doiEnabled && (identifier = sysMeta.getIdentifier().getValue()).startsWith(this.shoulder)) {
            HashMap<String, String> metadata = new HashMap<String, String>();
            String title = ErcMissingValueCode.UNKNOWN.toString();
            try {
                title = this.lookupTitle(sysMeta);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String creator = sysMeta.getRightsHolder().getValue();
            try {
                creator = this.lookupCreator(sysMeta.getRightsHolder());
            }
            catch (Exception exception) {
                // empty catch block
            }
            String publisher = ErcMissingValueCode.UNKNOWN.toString();
            Node node = MNodeService.getInstance(null).getCapabilities();
            publisher = node.getName();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
            String year = sdf.format(sysMeta.getDateUploaded());
            String resourceType = this.lookupResourceType(sysMeta);
            String format = sysMeta.getFormatId().getValue();
            String size = sysMeta.getSize().toString();
            String target = node.getBaseURL() + "/v1/object/" + identifier;
            String uriTemplate = null;
            String uriTemplateKey = "guid.ezid.uritemplate.data";
            ObjectFormat objectFormat = null;
            try {
                objectFormat = D1Client.getCN().getFormat(sysMeta.getFormatId());
            }
            catch (BaseException e1) {
                this.logMetacat.warn((Object)("Could not check format type for: " + sysMeta.getFormatId()));
            }
            if (objectFormat != null && objectFormat.getFormatType().equals("METADATA")) {
                uriTemplateKey = "guid.ezid.uritemplate.metadata";
            }
            try {
                uriTemplate = PropertyService.getProperty(uriTemplateKey);
                target = SystemUtil.getSecureServerURL() + uriTemplate.replaceAll("<IDENTIFIER>", identifier);
            }
            catch (PropertyNotFoundException e) {
                this.logMetacat.warn((Object)("No target URI template found in the configuration for: " + uriTemplateKey));
            }
            String status = InternalProfileValues.UNAVAILABLE.toString();
            String export = InternalProfileValues.NO.toString();
            Subject publicSubject = new Subject();
            publicSubject.setValue("public");
            if (AuthUtils.isAuthorized(Arrays.asList(publicSubject), (Permission)Permission.READ, (org.dataone.service.types.v1.SystemMetadata)sysMeta)) {
                status = InternalProfileValues.PUBLIC.toString();
                export = InternalProfileValues.YES.toString();
            }
            metadata.put(DataCiteProfile.TITLE.toString(), title);
            metadata.put(DataCiteProfile.CREATOR.toString(), creator);
            metadata.put(DataCiteProfile.PUBLISHER.toString(), publisher);
            metadata.put(DataCiteProfile.PUBLICATION_YEAR.toString(), year);
            metadata.put(DataCiteProfile.RESOURCE_TYPE.toString(), resourceType);
            metadata.put(DataCiteProfile.FORMAT.toString(), format);
            metadata.put(DataCiteProfile.SIZE.toString(), size);
            metadata.put(InternalProfile.TARGET.toString(), target);
            metadata.put(InternalProfile.STATUS.toString(), status);
            metadata.put(InternalProfile.EXPORT.toString(), export);
            this.refreshLogin();
            this.ezid.createOrUpdate(identifier, metadata);
        }
        return true;
    }

    public Identifier generateDOI() throws EZIDException, InvalidRequest {
        if (!this.doiEnabled) {
            throw new InvalidRequest("2193", "DOI scheme is not enabled at this node.");
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put(DataCiteProfile.TITLE.toString(), ErcMissingValueCode.UNKNOWN.toString());
        metadata.put(DataCiteProfile.CREATOR.toString(), ErcMissingValueCode.UNKNOWN.toString());
        metadata.put(DataCiteProfile.PUBLISHER.toString(), ErcMissingValueCode.UNKNOWN.toString());
        metadata.put(DataCiteProfile.PUBLICATION_YEAR.toString(), ErcMissingValueCode.UNKNOWN.toString());
        metadata.put(InternalProfile.STATUS.toString(), InternalProfileValues.RESERVED.toString());
        metadata.put(InternalProfile.EXPORT.toString(), InternalProfileValues.NO.toString());
        this.refreshLogin();
        String doi = this.ezid.mintIdentifier(this.shoulder, metadata);
        Identifier identifier = new Identifier();
        identifier.setValue(doi);
        return identifier;
    }

    private String lookupTitle(SystemMetadata sysMeta) throws Exception {
        String title = ErcMissingValueCode.UNKNOWN.toString();
        if (sysMeta.getFormatId().getValue().startsWith("eml://")) {
            Eml200DataPackageParser parser = new Eml200DataPackageParser();
            MockHttpServletRequest request = new MockHttpServletRequest(null, null, null);
            Session session = new Session();
            Subject subject = MNodeService.getInstance((HttpServletRequest)request).getCapabilities().getSubject(0);
            session.setSubject(subject);
            InputStream emlStream = MNodeService.getInstance((HttpServletRequest)request).get(session, sysMeta.getIdentifier());
            parser.parse(emlStream);
            DataPackage dataPackage = parser.getDataPackage();
            title = dataPackage.getTitle();
        }
        return title;
    }

    private String lookupResourceType(SystemMetadata sysMeta) {
        String resourceType = DataCiteProfileResourceTypeValues.DATASET.toString();
        try {
            ObjectFormat objectFormat = D1Client.getCN().getFormat(sysMeta.getFormatId());
            resourceType = resourceType + "/" + objectFormat.getFormatType().toLowerCase();
        }
        catch (Exception e) {
            this.logMetacat.warn((Object)("Could not lookup resource type for formatId" + e.getMessage()));
        }
        return resourceType;
    }

    private String lookupCreator(Subject subject) throws ServiceFailure, NotAuthorized, NotImplemented, NotFound, InvalidToken {
        String fullName = subject.getValue();
        SubjectInfo subjectInfo = D1Client.getCN().getSubjectInfo(null, subject);
        if (subjectInfo != null && subjectInfo.getPersonList() != null) {
            for (Person p : subjectInfo.getPersonList()) {
                if (!p.getSubject().equals((Object)subject)) continue;
                fullName = p.getFamilyName();
                if (p.getGivenNameList() == null || p.getGivenNameList().size() <= 0) break;
                fullName = fullName + ", " + p.getGivenName(0);
                break;
            }
        }
        return fullName;
    }
}

