/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.util;

import edu.ucsb.nceas.metacat.shared.BaseException;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.metacat.util.ErrorSendingErrorException;
import edu.ucsb.nceas.utilities.FileUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class ResponseUtil {
    public static Long GENERAL_UTILITY_ERROR = new Long(101001L);
    public static Long METACAT_UTILITY_ERROR = new Long(101002L);
    public static Long PROPERTY_NOT_FOUND = new Long(104001L);
    public static Long NO_READ_PERMISSION = new Long(105001L);
    public static Long SCHEDULE_WORKFLOW_ERROR = new Long(130001L);
    public static Long UNSCHEDULE_WORKFLOW_ERROR = new Long(130002L);
    public static Long RESCHEDULE_WORKFLOW_ERROR = new Long(130003L);
    public static Long GET_SCHEDULED_WORKFLOW_ERROR = new Long(130004L);
    public static Long DELETE_SCHEDULED_WORKFLOW_ERROR = new Long(130005L);
    static Hashtable<Long, String> errorCodes = new Hashtable();
    private static Logger logMetacat;
    private static int DEFAULT_BUFFER_SIZE;

    private ResponseUtil() {
    }

    public static void redirectResponse(HttpServletRequest request, HttpServletResponse response, String destination) throws MetacatUtilException {
        try {
            logMetacat.debug((Object)("Redirecting response to " + request.getContextPath() + destination));
            response.sendRedirect(request.getContextPath() + destination);
        }
        catch (IOException ioe) {
            throw new MetacatUtilException("I/O error when redirecting response to: " + destination);
        }
    }

    public static void writeFileToOutput(HttpServletResponse response, String fileDir, String fileName) throws MetacatUtilException {
        ResponseUtil.writeFileToOutput(response, fileDir, fileName, DEFAULT_BUFFER_SIZE);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeFileToOutput(HttpServletResponse response, String fileDir, String fileName, int bufferSize) throws MetacatUtilException {
        String filePath = "";
        FileInputStream inputStream = null;
        ServletOutputStream outputStream = null;
        try {
            filePath = fileDir + FileUtil.getFS() + fileName;
            int lastFileSep = fileName.lastIndexOf(FileUtil.getFS());
            String shortFileName = fileName.substring(lastFileSep + 1, fileName.length());
            response.setHeader("Content-Disposition", "attachment; filename=\"" + shortFileName + "\"");
            inputStream = new FileInputStream(filePath);
            outputStream = response.getOutputStream();
            byte[] byteBuffer = new byte[bufferSize];
            int b = 0;
            while ((b = ((InputStream)inputStream).read(byteBuffer)) != -1) {
                outputStream.write(byteBuffer, 0, b);
            }
            outputStream.close();
            ((InputStream)inputStream).close();
        }
        catch (FileNotFoundException fnfe) {
            try {
                throw new MetacatUtilException("Error finding file: " + filePath + " when writing to output");
                catch (IOException ioe) {
                    throw new MetacatUtilException("I/O Error when writing: " + filePath + "  to output");
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    public static void send(HttpServletResponse response, String content) throws ErrorSendingErrorException {
        try (PrintWriter out = null;){
            out = response.getWriter();
            response.setContentType("text/xml");
            out.print(content);
        }
    }

    public static void sendErrorXML(HttpServletResponse response, Long errorCode, BaseException be) throws ErrorSendingErrorException {
        logMetacat.error((Object)(errorCodes.get(errorCode) + " : " + be.getMessage()));
        try (PrintWriter out = null;){
            out = response.getWriter();
            response.setContentType("text/xml");
            out.println("<?xml version=\"1.0\"?>");
            out.println("<error>");
            out.println("<code>" + errorCode + "</code>");
            out.println("<defaultMessage>" + errorCodes.get(errorCode) + "</defaultMessage>");
            out.println("<coreMessage>" + be.getCoreMessage() + "</coreMessage>");
            out.println("<chainedMessage>" + be.getMessage() + "</chainedMessage>");
            out.println("</error>");
        }
    }

    public static void sendErrorXML(HttpServletResponse response, Long errorCode, String message) throws ErrorSendingErrorException {
        logMetacat.error((Object)(errorCodes.get(errorCode) + " : " + message));
        try (PrintWriter out = null;){
            out = response.getWriter();
            response.setContentType("text/xml");
            out.println("<?xml version=\"1.0\"?>");
            out.println("<error>");
            out.println("<code>" + errorCode + "</code>");
            out.println("<defaultMessage>" + errorCodes.get(errorCode) + "</defaultMessage>");
            out.println("<coreMessage>" + message + "</coreMessage>");
            out.println("<chainedMessage></chainedMessage>");
            out.println("</error>");
        }
    }

    public static void sendSuccessXML(HttpServletResponse response, String message) throws ErrorSendingErrorException {
        try (PrintWriter out = null;){
            out = response.getWriter();
            response.setContentType("text/xml");
            out.println("<?xml version=\"1.0\"?>");
            out.println("<success>" + message + "</success>");
        }
    }

    public static boolean isSuccessXML(String message) {
        return message.indexOf("<success>") != -1;
    }

    static {
        errorCodes.put(GENERAL_UTILITY_ERROR, "General utility error");
        errorCodes.put(METACAT_UTILITY_ERROR, "Metacat utility error");
        errorCodes.put(PROPERTY_NOT_FOUND, "Property not found");
        errorCodes.put(NO_READ_PERMISSION, "Read permission denied for user");
        errorCodes.put(SCHEDULE_WORKFLOW_ERROR, "Schedule workflow error");
        errorCodes.put(UNSCHEDULE_WORKFLOW_ERROR, "Unschedule workflow error");
        errorCodes.put(RESCHEDULE_WORKFLOW_ERROR, "Reschedule workflow error");
        errorCodes.put(GET_SCHEDULED_WORKFLOW_ERROR, "Get scheduled workflow error");
        errorCodes.put(DELETE_SCHEDULED_WORKFLOW_ERROR, "Delete scheduled workflow error");
        logMetacat = Logger.getLogger(ResponseUtil.class);
        DEFAULT_BUFFER_SIZE = 4096;
    }
}

