/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.client.cache;

import com.ibm.lsid.client.LSIDResolver;
import com.ibm.lsid.client.cache.LSIDCache;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class CacheProfiler {
    public static final String OVERALL_HIT_RATE = "r";
    LSIDCache cache = null;

    public CacheProfiler(LSIDCache lSIDCache) {
        this.cache = lSIDCache;
    }

    public double computeHitRate() throws IOException {
        File file = new File(LSIDCache.getLocation());
        File file2 = new File(file, this.cache.getLogFileName());
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
        String string = bufferedReader.readLine();
        int n = 0;
        int n2 = 0;
        while (string != null) {
            if (string.indexOf("Read") != -1) {
                ++n;
            } else if (string.indexOf("Wrote") != -1) {
                ++n2;
            }
            string = bufferedReader.readLine();
        }
        return (double)n / ((double)n + (double)n2);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            System.err.println("Usage: java com.ibm.lsid.client.cache.CacheProfile <op>");
            System.err.println("<op> = r");
            System.err.println("r - compute the overall hit rate for the cache");
            return;
        }
        if (!stringArray[0].equals(OVERALL_HIT_RATE)) {
            System.err.println("Usage: java com.ibm.lsid.client.cache.CacheProfile <op>");
            System.err.println("<op> = r");
            System.err.println("r - compute the overall hit rate for the cache");
            return;
        }
        CacheProfiler cacheProfiler = new CacheProfiler(LSIDResolver.getCache());
        System.err.println("Cache hit rate: " + cacheProfiler.computeHitRate());
    }
}

