/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.client.metadata.rdf.jena;

import com.hp.hpl.jena.rdf.arp.JenaReader;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryResults;
import com.hp.hpl.jena.rdql.QueryResultsMem;
import com.hp.hpl.jena.rdql.ResultBinding;
import com.hp.hpl.jena.rdql.Value;
import com.ibm.lsid.LSID;
import com.ibm.lsid.MalformedLSIDException;
import com.ibm.lsid.MetadataResponse;
import com.ibm.lsid.client.LSIDAuthority;
import com.ibm.lsid.client.metadata.LSIDMetadata;
import com.ibm.lsid.client.metadata.LSIDMetadataException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class JenaMetadataStore
implements LSIDMetadata {
    private Model model;
    private JenaReader reader = new JenaReader();

    public JenaMetadataStore(Model model) {
        this.model = model;
    }

    /*
     * Loose catch block
     */
    public void addMetadata(MetadataResponse metadataResponse) throws LSIDMetadataException {
        block7: {
            InputStream inputStream = null;
            inputStream = metadataResponse.getMetadata();
            this.reader.read(this.model, inputStream, "");
            Object var5_3 = null;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            break block7;
            {
                catch (RDFException rDFException) {
                    throw new LSIDMetadataException((Exception)((Object)rDFException), "Error loading meta data from input stream");
                }
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    public String getFormat(LSID lSID) throws LSIDMetadataException {
        String string = "SELECT\t?format WHERE\t(<" + lSID + ">, <dc:format>, ?format) " + "USING\tdc FOR <http://purl.org/dc/elements/1.1/> ";
        QueryResults queryResults = Query.exec((String)string, (Model)this.model);
        if (queryResults.hasNext()) {
            ResultBinding resultBinding = (ResultBinding)queryResults.next();
            Value value = resultBinding.getValue("format");
            String string2 = value.asUnquotedString();
            lSID.setFormat(string2);
            return string2;
        }
        return null;
    }

    public LSID[] getInstances(LSID lSID) throws LSIDMetadataException {
        String string = "SELECT\t?instance, ?format WHERE (<" + lSID + ">, <i3cp:storedas>, ?instance), " + "(?instance, <dc:format>, ?format) USING " + "i3cp FOR <urn:lsid:i3c.org:predicates:>, " + "dc FOR <http://purl.org/dc/elements/1.1/>";
        QueryResultsMem queryResultsMem = new QueryResultsMem(Query.exec((String)string, (Model)this.model));
        LSID[] lSIDArray = new LSID[queryResultsMem.size()];
        int n = 0;
        while (queryResultsMem.hasNext()) {
            ResultBinding resultBinding = (ResultBinding)queryResultsMem.next();
            try {
                LSID lSID2 = new LSID(resultBinding.getValue("instance").asUnquotedString());
                lSID2.setFormat(resultBinding.getValue("format").asUnquotedString());
                lSID2.setAbstr(lSID);
                lSIDArray[n++] = lSID2;
            }
            catch (MalformedLSIDException malformedLSIDException) {
                throw new LSIDMetadataException(malformedLSIDException, "Bad LSID in getInstances");
            }
        }
        lSID.setInstances(lSIDArray);
        return lSIDArray;
    }

    public String getType(LSID lSID) throws LSIDMetadataException {
        String string = "SELECT\t?type WHERE\t(<" + lSID + ">, <rdf:type>, ?type) USING " + "rdf FOR <http://www.w3.org/1999/02/22-rdf-syntax-ns#>";
        QueryResults queryResults = Query.exec((String)string, (Model)this.model);
        if (queryResults.hasNext()) {
            ResultBinding resultBinding = (ResultBinding)queryResults.next();
            Value value = resultBinding.getValue("type");
            String string2 = value.asUnquotedString();
            lSID.setType(string2);
            return string2;
        }
        return null;
    }

    public LSID getAbstract(LSID lSID) throws LSIDMetadataException {
        String string = "SELECT ?abstract WHERE (?abstract, <i3cp:storedas>, <" + lSID + ">) " + "USING i3cp FOR <urn:lsid:i3c.org:predicates:> ";
        QueryResults queryResults = Query.exec((String)string, (Model)this.model);
        if (queryResults.hasNext()) {
            ResultBinding resultBinding = (ResultBinding)queryResults.next();
            Value value = resultBinding.getValue("abstract");
            try {
                LSID lSID2 = new LSID(value.asUnquotedString());
                lSID.setAbstr(lSID2);
                return lSID2;
            }
            catch (MalformedLSIDException malformedLSIDException) {
                throw new LSIDMetadataException(malformedLSIDException, "bad abstract lsid");
            }
        }
        return null;
    }

    public Model getModel() {
        return this.model;
    }

    public LSIDAuthority[] getForeignAuthorities(LSID lSID) throws LSIDMetadataException {
        ResultBinding resultBinding;
        String string = "SELECT\t?auth WHERE\t(<" + lSID + ">, <i3cp:foreignauthority>, ?auth) USING " + "i3cp FOR <urn:lsid:i3c.org:predicates:>";
        QueryResults queryResults = Query.exec((String)string, (Model)this.model);
        Vector<LSIDAuthority> vector = new Vector<LSIDAuthority>();
        while (queryResults.hasNext()) {
            resultBinding = (ResultBinding)queryResults.next();
            Value value = resultBinding.getValue("auth");
            String string2 = value.asUnquotedString();
            try {
                vector.add(new LSIDAuthority(string2));
            }
            catch (MalformedLSIDException malformedLSIDException) {
                throw new LSIDMetadataException(malformedLSIDException, "bad foreign authority in metadata");
            }
        }
        resultBinding = new LSIDAuthority[vector.size()];
        vector.toArray((T[])resultBinding);
        return resultBinding;
    }
}

