/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.ecogrid;

import java.text.SimpleDateFormat;
import org.ecoinformatics.ecogrid.ResultsetType;
import org.ecoinformatics.ecogrid.ResultsetType_record;
import org.ecoinformatics.ecogrid.ResultsetType_record_returnField;
import org.ecoinformatics.ecogrid.ResultsetType_resultsetMetadata;
import org.ecoinformatics.ecogrid.ResultsetType_resultsetMetadata_namespace;
import org.ecoinformatics.ecogrid.ResultsetType_resultsetMetadata_recordStructure;
import org.ecoinformatics.ecogrid.ResultsetType_resultsetMetadata_recordStructure_returnField;
import org.ecoinformatics.ecogrid.ResultsetType_resultsetMetadata_system;

public class EcogridResultsetTransformer {
    public static String toXMLString(ResultsetType_resultsetMetadata_recordStructure[] aRecStruct) {
        if (aRecStruct == null) {
            return "";
        }
        StringBuffer strBuf = new StringBuffer();
        for (int i = 0; i < aRecStruct.length; ++i) {
            ResultsetType_resultsetMetadata_recordStructure_returnField[] returnFields = aRecStruct[i].getReturnField();
            if (returnFields[i] == null) continue;
            strBuf.append("    <recordStructure");
            if (aRecStruct[i].getNamespace() != null) {
                strBuf.append(" namespace=\"" + aRecStruct[i].getNamespace() + "\"");
            }
            strBuf.append(">\n");
            for (int j = 0; j < returnFields.length; ++j) {
                strBuf.append("      <returnField");
                strBuf.append(" id=\"" + returnFields[j].getId() + "\"");
                if (returnFields[j].getPathns() != null) {
                    strBuf.append(" pathns=\"" + returnFields[j].getPathns() + "\"");
                }
                if (returnFields[j].getName() != null) {
                    strBuf.append(" name=\"" + returnFields[j].getName() + "\"");
                }
                strBuf.append("/>\n");
            }
            strBuf.append("    </recordStructure>\n");
        }
        return strBuf.toString();
    }

    public static String toXMLString(ResultsetType_resultsetMetadata_namespace[] aNameSpace) {
        if (aNameSpace == null) {
            return "";
        }
        StringBuffer strBuf = new StringBuffer();
        for (int i = 0; i < aNameSpace.length; ++i) {
            strBuf.append("    <namespace");
            if (aNameSpace[i].getPrefix() != null) {
                strBuf.append(" prefix=\"" + aNameSpace[i].getPrefix() + "\"");
            }
            strBuf.append(">" + aNameSpace[i].getValue() + "</namespace>\n");
        }
        return strBuf.toString();
    }

    public static String toXMLString(ResultsetType_resultsetMetadata_system[] aSystem) {
        if (aSystem == null) {
            return "";
        }
        StringBuffer strBuf = new StringBuffer();
        for (int i = 0; i < aSystem.length; ++i) {
            String urlStr = aSystem[i].getValue().toString().replaceAll("%20", " ");
            strBuf.append("    <system id=\"" + aSystem[i].getId() + "\">" + urlStr + "</system>\n");
        }
        return strBuf.toString();
    }

    public static String toXMLString(ResultsetType_resultsetMetadata aMetaData) {
        if (aMetaData == null) {
            return "";
        }
        StringBuffer strBuf = new StringBuffer();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        String date = aMetaData.getSendTime() != null ? formatter.format(aMetaData.getSendTime().getTime()) : "";
        strBuf.append("  <resultsetMetadata>\n");
        strBuf.append("    <sendTime>" + date + "</sendTime>\n");
        strBuf.append("    <startRecord>" + aMetaData.getStartRecord() + "</startRecord>\n");
        strBuf.append("    <endRecord>" + aMetaData.getEndRecord() + "</endRecord>\n");
        strBuf.append("    <recordCount>" + aMetaData.getRecordCount() + "</recordCount>\n");
        strBuf.append(EcogridResultsetTransformer.toXMLString(aMetaData.getNamespace()));
        strBuf.append(EcogridResultsetTransformer.toXMLString(aMetaData.getSystem()));
        strBuf.append(EcogridResultsetTransformer.toXMLString(aMetaData.getRecordStructure()));
        strBuf.append("  </resultsetMetadata>\n");
        return strBuf.toString();
    }

    public static String toXMLString(ResultsetType_record_returnField[] aReturnFields) {
        if (aReturnFields == null) {
            return "";
        }
        StringBuffer strBuf = new StringBuffer();
        for (int i = 0; i < aReturnFields.length; ++i) {
            strBuf.append("    <returnField");
            if (aReturnFields[i].getId() != null) {
                strBuf.append(" id=\"" + aReturnFields[i].getId() + "\"");
            } else if (aReturnFields[i].getName() != null) {
                strBuf.append(" name=\"" + aReturnFields[i].getName() + "\"");
            }
            if (aReturnFields[i] == null) {
                boolean x = false;
            }
            String content = aReturnFields[i].getContent();
            strBuf.append(">" + (content == null ? "" : content) + "</returnField>\n");
        }
        return strBuf.toString();
    }

    public static String toXMLString(ResultsetType_record aRecord) {
        if (aRecord == null) {
            return "";
        }
        StringBuffer strBuf = new StringBuffer();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        String lastModifiedDateStr = "";
        String creationDateStr = "";
        if (aRecord.getLastModifiedDate() != null) {
            lastModifiedDateStr = formatter.format(aRecord.getLastModifiedDate().getTime());
        }
        if (aRecord.getCreationDate() != null) {
            creationDateStr = formatter.format(aRecord.getCreationDate().getTime());
        }
        strBuf.append("  <record number=\"" + aRecord.getNumber() + "\"\n");
        strBuf.append("          system=\"" + aRecord.getSystem() + "\"\n");
        strBuf.append("          identifier=\"" + aRecord.getIdentifier() + "\"");
        if (lastModifiedDateStr.length() > 0) {
            strBuf.append("\n          lastModifiedDate=\"" + lastModifiedDateStr + "\"");
        }
        if (creationDateStr.length() > 0) {
            strBuf.append("\n          creationDate=\"" + creationDateStr + "\"");
        }
        strBuf.append(">\n");
        strBuf.append(EcogridResultsetTransformer.toXMLString(aRecord.getReturnField()));
        strBuf.append("  </record>\n");
        return strBuf.toString();
    }

    public static String toXMLString(ResultsetType_record[] aRecords) {
        if (aRecords == null) {
            return "";
        }
        StringBuffer strBuf = new StringBuffer();
        for (int i = 0; i < aRecords.length; ++i) {
            strBuf.append(EcogridResultsetTransformer.toXMLString(aRecords[i]));
        }
        return strBuf.toString();
    }

    public static String toXMLString(ResultsetType aRS) {
        String extraAttrs;
        if (aRS == null) {
            return "";
        }
        StringBuffer strBuf = new StringBuffer();
        strBuf.setLength(0);
        if (aRS.getSystem() != null) {
            strBuf.append("<rs:resultset system=\"" + aRS.getSystem().toString() + "\" resultsetId=\"" + aRS.getResultsetId() + "\"\n");
        }
        if ((extraAttrs = aRS.getAttrs()) != null && extraAttrs.length() > 0) {
            strBuf.append("  " + extraAttrs);
        }
        strBuf.append("  xmlns:rs=\"ecogrid://ecoinformatics.org/ecogrid-resultset-1.0.0beta1\"");
        strBuf.append(">\n");
        strBuf.append(EcogridResultsetTransformer.toXMLString(aRS.getResultsetMetadata()));
        strBuf.append(EcogridResultsetTransformer.toXMLString(aRS.getRecord()));
        strBuf.append("</rs:resultset>\n");
        return strBuf.toString();
    }
}

