/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.ecogrid;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.globus.common.CoGProperties;
import org.globus.gsi.CertUtil;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.bc.BouncyCastleCertProcessingFactory;
import org.globus.gsi.bc.BouncyCastleOpenSSLKey;
import org.globus.gsi.proxy.ext.ProxyCertInfo;

public class GridProxy {
    X509Certificate certificate;
    PrivateKey userKey = null;
    GlobusCredential proxy = null;
    ProxyCertInfo proxyCertInfo = null;
    int bits = 512;
    int lifetime = 43200;
    int proxyType;
    CoGProperties properties = CoGProperties.getDefault();
    String proxyFile = this.properties.getProxyFile();
    String keyFile = this.properties.getUserKeyFile();
    String certFile = this.properties.getUserCertFile();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int createProxy(String passwd) throws Exception {
        block8: {
            int flag = 0;
            System.out.println("Entering createProxy()");
            System.out.println("Loading Certificate...");
            this.certificate = CertUtil.loadCertificate((String)this.certFile);
            String dn = this.certificate.getSubjectDN().getName();
            System.out.println("Your identity: " + dn);
            System.out.println("Loading Key..." + this.keyFile);
            BouncyCastleOpenSSLKey sslkey = new BouncyCastleOpenSSLKey(this.keyFile);
            System.out.println("after Key loading...");
            if (sslkey.isEncrypted()) {
                System.out.println("in ecnrypted path");
                sslkey.decrypt(passwd);
            }
            System.out.println("after get the key...");
            this.userKey = sslkey.getPrivateKey();
            System.out.println("Signing...");
            this.proxyType = 14;
            BouncyCastleCertProcessingFactory factory = BouncyCastleCertProcessingFactory.getDefault();
            this.proxy = factory.createCredential(new X509Certificate[]{this.certificate}, this.userKey, this.bits, this.lifetime, this.proxyType, this.proxyCertInfo);
            System.out.println("Your proxy is valid until " + this.proxy.getCertificateChain()[0].getNotAfter());
            System.out.println("Writing File...");
            FileOutputStream out = null;
            try {
                try {
                    out = new FileOutputStream(this.proxyFile);
                    this.proxy.save((OutputStream)out);
                }
                catch (IOException e) {
                    System.err.println("Failed to save proxy to a file: " + e.getMessage());
                    throw e;
                }
                Object var9_7 = null;
                if (out == null) break block8;
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                if (out == null) throw throwable;
                try {
                    ((OutputStream)out).close();
                    throw throwable;
                }
                catch (Exception e) {
                    System.out.println("Error is " + e.getMessage());
                    throw e;
                }
            }
            try {}
            catch (Exception e) {
                System.out.println("Error is " + e.getMessage());
                throw e;
            }
            ((OutputStream)out).close();
        }
        System.out.println("Exiting createProxy()");
        return 1;
    }

    private String getInput(String str) throws Exception {
        System.out.println("" + str);
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        String input = reader.readLine();
        System.out.println("after get the input " + input.trim());
        return input.trim();
    }
}

