/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPFault;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class SOAPBody
extends MessageElement
implements javax.xml.soap.SOAPBody {
    private static Log log = LogFactory.getLog((class$org$apache$axis$message$SOAPBody == null ? (class$org$apache$axis$message$SOAPBody = SOAPBody.class$("org.apache.axis.message.SOAPBody")) : class$org$apache$axis$message$SOAPBody).getName());
    private Vector bodyElements = new Vector();
    private SOAPConstants soapConstants;
    private boolean disableFormatting = false;
    private boolean doSAAJEncodingCompliance = false;
    private static ArrayList knownEncodingStyles = new ArrayList();
    static /* synthetic */ Class class$org$apache$axis$message$SOAPBody;

    SOAPBody(SOAPEnvelope env, SOAPConstants soapConsts) {
        super(soapConsts.getEnvelopeURI(), "Body");
        this.soapConstants = soapConsts;
        try {
            this.setParentElement(env);
        }
        catch (SOAPException ex) {
            log.fatal((Object)Messages.getMessage("exception00"), (Throwable)ex);
        }
    }

    public SOAPBody(String namespace, String localPart, String prefix, Attributes attributes, DeserializationContext context, SOAPConstants soapConsts) throws AxisFault {
        super(namespace, localPart, prefix, attributes, context);
        this.soapConstants = soapConsts;
    }

    public void setParentElement(SOAPElement parent) throws SOAPException {
        if (parent == null) {
            throw new IllegalArgumentException(Messages.getMessage("nullParent00"));
        }
        try {
            super.setParentElement((SOAPEnvelope)parent);
        }
        catch (Throwable t) {
            throw new SOAPException(t);
        }
    }

    public void detachNode() {
        ((SOAPEnvelope)this.parent).removeBody();
        super.detachNode();
    }

    public void disableFormatting() {
        this.disableFormatting = true;
    }

    public void setEncodingStyle(String encodingStyle) throws SOAPException {
        if (encodingStyle == null) {
            encodingStyle = "";
        }
        if (this.doSAAJEncodingCompliance && !knownEncodingStyles.contains(encodingStyle)) {
            throw new IllegalArgumentException(Messages.getMessage("badEncodingStyle1", encodingStyle));
        }
        super.setEncodingStyle(encodingStyle);
    }

    protected void outputImpl(SerializationContext context) throws Exception {
        boolean oldPretty = context.getPretty();
        if (!this.disableFormatting) {
            context.setPretty(true);
        } else {
            context.setPretty(false);
        }
        if (this.bodyElements.isEmpty()) {
            // empty if block
        }
        context.startElement(new QName(this.soapConstants.getEnvelopeURI(), "Body"), this.getAttributes());
        Enumeration enumeration = this.bodyElements.elements();
        while (enumeration.hasMoreElements()) {
            SOAPBodyElement body = (SOAPBodyElement)enumeration.nextElement();
            body.output(context);
        }
        context.outputMultiRefs();
        context.endElement();
        context.setPretty(oldPretty);
    }

    Vector getBodyElements() throws AxisFault {
        return this.bodyElements;
    }

    SOAPBodyElement getFirstBody() throws AxisFault {
        if (this.bodyElements.isEmpty()) {
            return null;
        }
        return (SOAPBodyElement)this.bodyElements.elementAt(0);
    }

    void addBodyElement(SOAPBodyElement element) {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("addBody00"));
        }
        try {
            element.setParentElement(this);
        }
        catch (SOAPException ex) {
            log.fatal((Object)Messages.getMessage("exception00"), (Throwable)ex);
        }
    }

    void removeBodyElement(SOAPBodyElement element) {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("removeBody00"));
        }
        this.bodyElements.removeElement(element);
    }

    void clearBody() {
        if (!this.bodyElements.isEmpty()) {
            this.bodyElements.removeAllElements();
        }
    }

    SOAPBodyElement getBodyByName(String namespace, String localPart) throws AxisFault {
        return (SOAPBodyElement)this.findElement(this.bodyElements, namespace, localPart);
    }

    protected MessageElement findElement(Vector vec, String namespace, String localPart) {
        if (vec.isEmpty()) {
            return null;
        }
        QName qname = new QName(namespace, localPart);
        Enumeration e = vec.elements();
        while (e.hasMoreElements()) {
            MessageElement element = (MessageElement)e.nextElement();
            if (!element.getQName().equals(qname)) continue;
            return element;
        }
        return null;
    }

    public javax.xml.soap.SOAPBodyElement addBodyElement(Name name) throws SOAPException {
        SOAPBodyElement bodyElement = new SOAPBodyElement(name);
        this.addBodyElement(bodyElement);
        return bodyElement;
    }

    public javax.xml.soap.SOAPFault addFault() throws SOAPException {
        AxisFault af = new AxisFault(new QName("http://xml.apache.org/axis/", "Server.generalException"), "", "", new Element[0]);
        SOAPFault fault = new SOAPFault(af);
        this.addBodyElement(fault);
        return fault;
    }

    public javax.xml.soap.SOAPFault getFault() {
        Enumeration e = this.bodyElements.elements();
        while (e.hasMoreElements()) {
            Object element = e.nextElement();
            if (!(element instanceof javax.xml.soap.SOAPFault)) continue;
            return (javax.xml.soap.SOAPFault)element;
        }
        return null;
    }

    public boolean hasFault() {
        Enumeration e = this.bodyElements.elements();
        while (e.hasMoreElements()) {
            if (!(e.nextElement() instanceof javax.xml.soap.SOAPFault)) continue;
            return true;
        }
        return false;
    }

    public void addChild(MessageElement el) throws SOAPException {
        this.bodyElements.addElement(el);
    }

    public Iterator getChildElements() {
        return ((AbstractList)this.bodyElements).iterator();
    }

    public Iterator getChildElements(Name name) {
        Vector<SOAPElement> v = new Vector<SOAPElement>();
        Enumeration e = this.bodyElements.elements();
        while (e.hasMoreElements()) {
            SOAPElement bodyEl = (SOAPElement)e.nextElement();
            if (!bodyEl.getElementName().equals(name)) continue;
            v.addElement(bodyEl);
        }
        return ((AbstractList)v).iterator();
    }

    /*
     * WARNING - void declaration
     */
    public void removeChild(MessageElement child) {
        int i;
        while ((i = this.bodyElements.indexOf(child)) != -1) {
            void var2_2;
            this.bodyElements.remove((int)var2_2);
        }
    }

    public SOAPElement addChildElement(SOAPElement element) throws SOAPException {
        return super.addChildElement(element);
    }

    public void setSAAJEncodingCompliance(boolean comply) {
        this.doSAAJEncodingCompliance = true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        knownEncodingStyles.add("http://schemas.xmlsoap.org/soap/encoding/");
        knownEncodingStyles.add("http://www.w3.org/2002/12/soap-encoding");
        knownEncodingStyles.add("");
        knownEncodingStyles.add("http://www.w3.org/2002/12/soap-envelope/encoding/none");
    }
}

