/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp;

public class ByteRange {
    public long from;
    public long to;
    public static final int THIS_BELOW = 1;
    public static final int ADJACENT = 2;
    public static final int THIS_SUPERSET = 3;
    public static final int THIS_SUBSET = 4;
    public static final int THIS_ABOVE = 5;

    public ByteRange(long from, long to) {
        if (to < from) {
            throw new IllegalArgumentException("Range upper boundary smaller than lower boundary");
        }
        this.from = from;
        this.to = to;
    }

    public boolean equals(ByteRange other) {
        return this.to == other.to && this.from == other.from;
    }

    public ByteRange(ByteRange src) {
        this.copy(src);
    }

    private void copy(ByteRange other) {
        this.from = other.from;
        this.to = other.to;
    }

    public int merge(ByteRange other) {
        if (other.from < this.from) {
            if (other.to + 1L < this.from) {
                return 5;
            }
            this.from = other.from;
            if (this.to <= other.to) {
                this.to = other.to;
                return 4;
            }
        } else {
            if (this.to + 1L < other.from) {
                return 1;
            }
            if (other.to <= this.to) {
                return 3;
            }
            this.to = other.to;
            if (other.from == this.from) {
                return 4;
            }
        }
        return 2;
    }

    public String toString() {
        return Long.toString(this.from) + "-" + Long.toString(this.to);
    }
}

