/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp;

import java.io.IOException;
import java.io.OutputStream;
import org.globus.ftp.Buffer;
import org.globus.ftp.DataSink;

public class DataSinkStream
implements DataSink {
    protected OutputStream out;
    protected boolean autoFlush;
    protected boolean ignoreOffset;

    public DataSinkStream(OutputStream out) {
        this(out, false, false);
    }

    public DataSinkStream(OutputStream out, boolean autoFlush, boolean ignoreOffset) {
        this.out = out;
        this.autoFlush = autoFlush;
        this.ignoreOffset = ignoreOffset;
    }

    public void write(Buffer buffer) throws IOException {
        if (!this.ignoreOffset && buffer.getOffset() != -1L) {
            throw new IOException("Offsets not supported.");
        }
        this.out.write(buffer.getBuffer(), 0, buffer.getLength());
        if (this.autoFlush) {
            this.out.flush();
        }
    }

    public void close() throws IOException {
        this.out.close();
    }
}

