/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.globus.ftp.Buffer;
import org.globus.ftp.DataSink;
import org.globus.ftp.DataSinkStream;
import org.globus.ftp.DataSource;
import org.globus.ftp.DataSourceStream;
import org.globus.ftp.FeatureList;
import org.globus.ftp.FileInfo;
import org.globus.ftp.HostPort;
import org.globus.ftp.MarkerListener;
import org.globus.ftp.Options;
import org.globus.ftp.RestartData;
import org.globus.ftp.Session;
import org.globus.ftp.exception.ClientException;
import org.globus.ftp.exception.FTPException;
import org.globus.ftp.exception.FTPReplyParseException;
import org.globus.ftp.exception.ServerException;
import org.globus.ftp.exception.UnexpectedReplyCodeException;
import org.globus.ftp.vanilla.BasicClientControlChannel;
import org.globus.ftp.vanilla.Command;
import org.globus.ftp.vanilla.FTPControlChannel;
import org.globus.ftp.vanilla.FTPServerFacade;
import org.globus.ftp.vanilla.Reply;
import org.globus.ftp.vanilla.TransferMonitor;
import org.globus.ftp.vanilla.TransferState;

public class FTPClient {
    private static Logger logger = Logger.getLogger((String)(class$org$globus$ftp$FTPClient == null ? (class$org$globus$ftp$FTPClient = FTPClient.class$("org.globus.ftp.FTPClient")) : class$org$globus$ftp$FTPClient).getName());
    protected Session session;
    protected FTPControlChannel controlChannel;
    protected FTPServerFacade localServer;
    protected SimpleDateFormat dateFormat = null;
    static /* synthetic */ Class class$org$globus$ftp$FTPClient;

    protected FTPClient() {
    }

    public FTPClient(String host, int port) throws IOException, ServerException {
        this.session = new Session();
        this.controlChannel = new FTPControlChannel(host, port);
        this.controlChannel.open();
        this.localServer = new FTPServerFacade();
        this.localServer.authorize();
    }

    public long getSize(String filename) throws IOException, ServerException {
        Command cmd = new Command("SIZE", filename);
        Reply reply = null;
        try {
            reply = this.controlChannel.execute(cmd);
            return Long.parseLong(reply.getMessage());
        }
        catch (NumberFormatException e) {
            throw ServerException.embedFTPReplyParseException(new FTPReplyParseException(4, "Could not parse size: " + reply.getMessage()));
        }
        catch (UnexpectedReplyCodeException urce) {
            throw ServerException.embedUnexpectedReplyCodeException(urce);
        }
        catch (FTPReplyParseException rpe) {
            throw ServerException.embedFTPReplyParseException(rpe);
        }
    }

    public Date getLastModified(String filename) throws IOException, ServerException {
        Command cmd = new Command("MDTM", filename);
        Reply reply = null;
        try {
            reply = this.controlChannel.execute(cmd);
        }
        catch (FTPReplyParseException rpe) {
            throw ServerException.embedFTPReplyParseException(rpe);
        }
        catch (UnexpectedReplyCodeException urce) {
            throw ServerException.embedUnexpectedReplyCodeException(urce, "Server refused changing transfer mode");
        }
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        try {
            return this.dateFormat.parse(reply.getMessage());
        }
        catch (ParseException e) {
            throw ServerException.embedFTPReplyParseException(new FTPReplyParseException(0, "Invalid file modification time reply: " + reply));
        }
    }

    public boolean exists(String filename) throws IOException, ServerException {
        try {
            Reply reply = this.controlChannel.exchange(new Command("RNFR", filename));
            if (Reply.isPositiveIntermediate(reply)) {
                this.controlChannel.execute(new Command("ABOR"));
                return true;
            }
            return false;
        }
        catch (FTPReplyParseException rpe) {
            throw ServerException.embedFTPReplyParseException(rpe);
        }
        catch (UnexpectedReplyCodeException urce) {
            throw ServerException.embedUnexpectedReplyCodeException(urce, "Abort failed");
        }
    }

    public void changeDir(String dir) throws IOException, ServerException {
        Command cmd = new Command("CWD", dir);
        try {
            this.controlChannel.execute(cmd);
        }
        catch (FTPReplyParseException rpe) {
            throw ServerException.embedFTPReplyParseException(rpe);
        }
        catch (UnexpectedReplyCodeException urce) {
            throw ServerException.embedUnexpectedReplyCodeException(urce, "Server refused changing directory");
        }
    }

    public void deleteDir(String dir) throws IOException, ServerException {
        try {
            Command cmd = new Command("RMD", dir);
            this.controlChannel.execute(cmd);
        }
        catch (FTPReplyParseException rpe) {
            throw ServerException.embedFTPReplyParseException(rpe);
        }
        catch (UnexpectedReplyCodeException urce) {
            throw ServerException.embedUnexpectedReplyCodeException(urce, "Server refused deleting directory");
        }
    }

    public void deleteFile(String filename) throws IOException, ServerException {
        try {
            Command cmd = new Command("DELE", filename);
            this.controlChannel.execute(cmd);
        }
        catch (FTPReplyParseException rpe) {
            throw ServerException.embedFTPReplyParseException(rpe);
        }
        catch (UnexpectedReplyCodeException urce) {
            throw ServerException.embedUnexpectedReplyCodeException(urce, "Server refused deleting file");
        }
    }

    public void makeDir(String dir) throws IOException, ServerException {
        try {
            Command cmd = new Command("MKD", dir);
            this.controlChannel.execute(cmd);
        }
        catch (FTPReplyParseException rpe) {
            throw ServerException.embedFTPReplyParseException(rpe);
        }
        catch (UnexpectedReplyCodeException urce) {
            throw ServerException.embedUnexpectedReplyCodeException(urce, "Server refused creating directory");
        }
    }

    public void rename(String oldName, String newName) throws IOException, ServerException {
        try {
            Reply reply = this.controlChannel.exchange(new Command("RNFR", oldName));
            if (!Reply.isPositiveIntermediate(reply)) {
                throw new UnexpectedReplyCodeException(reply);
            }
            this.controlChannel.execute(new Command("RNTO", newName));
        }
        catch (FTPReplyParseException rpe) {
            throw ServerException.embedFTPReplyParseException(rpe);
        }
        catch (UnexpectedReplyCodeException urce) {
            throw ServerException.embedUnexpectedReplyCodeException(urce, "Server refused renaming file");
        }
    }

    public String getCurrentDir() throws IOException, ServerException {
        Reply reply = null;
        try {
            reply = this.controlChannel.execute(Command.PWD);
        }
        catch (FTPReplyParseException rpe) {
            throw ServerException.embedFTPReplyParseException(rpe);
        }
        catch (UnexpectedReplyCodeException urce) {
            throw ServerException.embedUnexpectedReplyCodeException(urce, "Server refused returning current directory");
        }
        String strReply = reply.getMessage();
        if (strReply.length() > 0 && strReply.charAt(0) == '\"') {
            return strReply.substring(1, strReply.indexOf(34, 1));
        }
        throw ServerException.embedFTPReplyParseException(new FTPReplyParseException(0, "Cannot parse 'PWD' reply: " + reply));
    }

    public void goUpDir() throws IOException, ServerException {
        try {
            this.controlChannel.execute(Command.CDUP);
        }
        catch (FTPReplyParseException rpe) {
            throw ServerException.embedFTPReplyParseException(rpe);
        }
        catch (UnexpectedReplyCodeException urce) {
            throw ServerException.embedUnexpectedReplyCodeException(urce, "Server refused changing current directory");
        }
    }

    public Vector list() throws ServerException, ClientException, IOException {
        return this.list("*");
    }

    public Vector list(String filter) throws ServerException, ClientException, IOException {
        final ByteArrayOutputStream received = new ByteArrayOutputStream(1000);
        DataSink sink = new DataSink(){

            public void write(Buffer buffer) throws IOException {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("received " + buffer.getLength() + " bytes of directory listing"));
                }
                received.write(buffer.getBuffer(), 0, buffer.getLength());
            }

            public void close() throws IOException {
            }
        };
        this.list(filter, "-d", sink);
        BufferedReader reader = new BufferedReader(new StringReader(received.toString()));
        Vector<FileInfo> fileList = new Vector<FileInfo>();
        FileInfo fileInfo = null;
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("line ->" + line));
            }
            if (line.startsWith("total")) continue;
            try {
                fileInfo = new FileInfo(line);
            }
            catch (FTPException e) {
                ClientException ce = new ClientException(0, "Could not create FileInfo");
                ce.setRootCause(e);
                throw ce;
            }
            fileList.addElement(fileInfo);
        }
        return fileList;
    }

    public void list(String filter, String modifier, DataSink sink) throws ServerException, ClientException, IOException {
        this.listCheck();
        this.checkTransferParams();
        this.actualList(filter, modifier, sink);
    }

    protected void checkTransferParams() throws ServerException, IOException, ClientException {
        Session localSession = this.localServer.getSession();
        this.session.matches(localSession);
        logger.debug((Object)"sessions match");
        if (this.session.serverMode == -1) {
            logger.debug((Object)"defining remote pasv, local active");
            this.setPassive();
            this.setLocalActive();
        }
    }

    protected void actualList(String filter, String modifier, DataSink sink) throws ServerException, ClientException, IOException {
        this.controlChannel.write(new Command("LIST ", modifier + " " + filter));
        this.localServer.store(sink);
        this.transferRun(this.localServer.getControlChannel(), null);
    }

    protected void listCheck() throws ClientException {
        if (this.session.transferType != 2) {
            throw new ClientException(8, "list requires ASCII type");
        }
    }

    public void setType(int type) throws IOException, ServerException {
        this.localServer.setTransferType(type);
        String typeStr = null;
        switch (type) {
            case 1: {
                typeStr = "I";
                break;
            }
            case 2: {
                typeStr = "A";
                break;
            }
            case 3: {
                typeStr = "E";
                break;
            }
            case 4: {
                typeStr = "L";
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad type");
            }
        }
        try {
            Command cmd = new Command("TYPE", typeStr);
            this.controlChannel.execute(cmd);
        }
        catch (FTPReplyParseException rpe) {
            throw ServerException.embedFTPReplyParseException(rpe);
        }
        catch (UnexpectedReplyCodeException urce) {
            throw ServerException.embedUnexpectedReplyCodeException(urce, "Server refused changing transfer mode");
        }
        this.session.transferType = type;
    }

    public void setMode(int mode) throws IOException, ServerException {
        String modeStr = null;
        switch (mode) {
            case 1: {
                modeStr = "S";
                break;
            }
            case 2: {
                modeStr = "B";
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad mode");
            }
        }
        this.actualSetMode(mode, modeStr);
    }

    protected void actualSetMode(int mode, String modeStr) throws IOException, ServerException {
        this.localServer.setTransferMode(mode);
        try {
            Command cmd = new Command("MODE", modeStr);
            this.controlChannel.execute(cmd);
        }
        catch (FTPReplyParseException rpe) {
            throw ServerException.embedFTPReplyParseException(rpe);
        }
        catch (UnexpectedReplyCodeException urce) {
            throw ServerException.embedUnexpectedReplyCodeException(urce, "Server refused changing transfer mode");
        }
        this.session.transferMode = mode;
    }

    public void setProtectionBufferSize(int size) throws IOException, ServerException {
        if (size <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        this.localServer.setProtectionBufferSize(size);
        try {
            Command cmd = new Command("PBSZ", Integer.toString(size));
            this.controlChannel.execute(cmd);
        }
        catch (FTPReplyParseException rpe) {
            throw ServerException.embedFTPReplyParseException(rpe);
        }
        catch (UnexpectedReplyCodeException urce) {
            throw ServerException.embedUnexpectedReplyCodeException(urce, "Server refused setting protection buffer size");
        }
        this.session.protectionBufferSize = size;
    }

    public void abort() throws IOException, ServerException {
        try {
            try {
                this.controlChannel.execute(Command.ABOR);
            }
            catch (FTPReplyParseException rpe) {
                throw ServerException.embedFTPReplyParseException(rpe);
            }
            catch (UnexpectedReplyCodeException urce) {
                throw ServerException.embedUnexpectedReplyCodeException(urce, "Server refused changing transfer mode");
            }
            Object var4_1 = null;
        }
        catch (Throwable throwable) {
            Object var4_2 = null;
            this.localServer.abort();
            throw throwable;
        }
        this.localServer.abort();
    }

    /*
     * Loose catch block
     */
    public void close() throws IOException, ServerException {
        Object v0;
        block8: {
            Reply reply = this.controlChannel.execute(Command.QUIT);
            Object var4_3 = null;
            try {
                this.controlChannel.close();
                v0 = null;
                break block8;
            }
            catch (Throwable throwable) {
                v0 = null;
            }
            {
                break block8;
                catch (FTPReplyParseException rpe) {
                    throw ServerException.embedFTPReplyParseException(rpe);
                }
                catch (UnexpectedReplyCodeException urce) {
                    throw ServerException.embedUnexpectedReplyCodeException(urce, "Server refused closing");
                }
            }
            catch (Throwable throwable) {
                Object v1;
                Object var4_4 = null;
                try {
                    this.controlChannel.close();
                    v1 = null;
                }
                catch (Throwable throwable2) {
                    v1 = null;
                }
                Object var6_8 = v1;
                this.localServer.close();
                throw throwable;
            }
        }
        Object var6_7 = v0;
        this.localServer.close();
    }

    public boolean isFeatureSupported(String feature) throws IOException, ServerException {
        return this.getFeatureList().contains(feature);
    }

    public FeatureList getFeatureList() throws IOException, ServerException {
        if (this.session.featureList != null) {
            return this.session.featureList;
        }
        Reply featReply = null;
        try {
            featReply = this.controlChannel.execute(Command.FEAT);
            if (featReply.getCode() != 211) {
                throw ServerException.embedUnexpectedReplyCodeException(new UnexpectedReplyCodeException(featReply), "Server refused returning features");
            }
        }
        catch (FTPReplyParseException rpe) {
            throw ServerException.embedFTPReplyParseException(rpe);
        }
        catch (UnexpectedReplyCodeException urce) {
            throw ServerException.embedUnexpectedReplyCodeException(urce, "Server refused returning features");
        }
        this.session.featureList = new FeatureList(featReply.getMessage());
        return this.session.featureList;
    }

    public HostPort setPassive() throws IOException, ServerException {
        HostPort hp;
        Reply reply = null;
        try {
            reply = this.controlChannel.execute(Command.PASV);
        }
        catch (UnexpectedReplyCodeException urce) {
            throw ServerException.embedUnexpectedReplyCodeException(urce);
        }
        catch (FTPReplyParseException rpe) {
            throw ServerException.embedFTPReplyParseException(rpe);
        }
        String pasvReplyMsg = null;
        pasvReplyMsg = reply.getMessage();
        int openBracket = pasvReplyMsg.indexOf("(");
        int closeBracket = pasvReplyMsg.indexOf(")", openBracket);
        String bracketContent = pasvReplyMsg.substring(openBracket + 1, closeBracket);
        this.session.serverMode = 1;
        this.session.serverAddress = hp = new HostPort(bracketContent);
        return hp;
    }

    public void setActive(HostPort hostPort) throws IOException, ServerException {
        Command cmd = new Command("PORT", hostPort.toFtpCmdArgument());
        try {
            this.controlChannel.execute(cmd);
        }
        catch (UnexpectedReplyCodeException urce) {
            throw ServerException.embedUnexpectedReplyCodeException(urce);
        }
        catch (FTPReplyParseException rpe) {
            throw ServerException.embedFTPReplyParseException(rpe);
        }
        this.session.serverMode = 2;
    }

    public void setActive() throws IOException, ServerException, ClientException {
        Session local = this.localServer.getSession();
        if (local.serverAddress == null) {
            throw new ClientException(10);
        }
        this.setActive(local.serverAddress);
    }

    public void setLocalActive() throws ClientException, IOException {
        if (this.session.serverAddress == null) {
            throw new ClientException(10);
        }
        try {
            this.localServer.setActive(this.session.serverAddress);
        }
        catch (UnknownHostException e) {
            throw new ClientException(12);
        }
    }

    public HostPort setLocalPassive() throws IOException {
        return this.localServer.setPassive();
    }

    public HostPort setLocalPassive(int port, int queue) throws IOException {
        return this.localServer.setPassive(port, queue);
    }

    public void setClientWaitParams(int maxWait, int waitDelay) {
        if (maxWait <= 0 || waitDelay <= 0) {
            throw new IllegalArgumentException("Parameter is less than 0");
        }
        this.session.maxWait = maxWait;
        this.session.waitDelay = waitDelay;
    }

    public void setOptions(Options opts) throws IOException, ServerException {
        logger.debug((Object)("setting options: " + opts.toFtpCmdArgument()));
        Command cmd = new Command("OPTS", opts.toFtpCmdArgument());
        try {
            this.controlChannel.execute(cmd);
        }
        catch (FTPReplyParseException rpe) {
            throw ServerException.embedFTPReplyParseException(rpe);
        }
        catch (UnexpectedReplyCodeException urce) {
            throw ServerException.embedUnexpectedReplyCodeException(urce, "Server refused setting options");
        }
        this.localServer.setOptions(opts);
    }

    public void setRestartMarker(RestartData restartData) throws IOException, ServerException {
        Command cmd = new Command("REST", restartData.toFtpCmdArgument());
        Reply reply = null;
        try {
            reply = this.controlChannel.exchange(cmd);
        }
        catch (FTPReplyParseException e) {
            throw ServerException.embedFTPReplyParseException(e);
        }
        if (!Reply.isPositiveIntermediate(reply)) {
            throw ServerException.embedUnexpectedReplyCodeException(new UnexpectedReplyCodeException(reply));
        }
    }

    public void authorize(String user, String password) throws IOException, ServerException {
        Reply userReply = null;
        try {
            userReply = this.controlChannel.exchange(new Command("USER", user));
        }
        catch (FTPReplyParseException rpe) {
            throw ServerException.embedFTPReplyParseException(rpe);
        }
        if (Reply.isPositiveIntermediate(userReply)) {
            Reply passReply = null;
            try {
                passReply = this.controlChannel.exchange(new Command("PASS", password));
            }
            catch (FTPReplyParseException rpe) {
                throw ServerException.embedFTPReplyParseException(rpe);
            }
            if (!Reply.isPositiveCompletion(passReply)) {
                throw ServerException.embedUnexpectedReplyCodeException(new UnexpectedReplyCodeException(passReply), "Bad password.");
            }
        } else if (!Reply.isPositiveCompletion(userReply)) {
            throw ServerException.embedUnexpectedReplyCodeException(new UnexpectedReplyCodeException(userReply), "Bad user.");
        }
        this.session.authorized = true;
    }

    public void get(String remoteFileName, DataSink sink, MarkerListener mListener) throws IOException, ClientException, ServerException {
        TransferState state = this.actualGet(remoteFileName, sink, mListener);
        this.transferWait(state);
    }

    public TransferState asynchGet(String remoteFileName, DataSink sink, MarkerListener mListener) throws IOException, ClientException, ServerException {
        return this.actualGet(remoteFileName, sink, mListener);
    }

    protected TransferState actualGet(String remoteFileName, DataSink sink, MarkerListener mListener) throws IOException, ClientException, ServerException {
        this.checkTransferParams();
        logger.debug((Object)"localserver.store()");
        this.localServer.store(sink);
        this.controlChannel.write(new Command("RETR", remoteFileName));
        return this.transferStart(this.localServer.getControlChannel(), mListener);
    }

    public void put(String remoteFileName, DataSource source, MarkerListener mListener) throws IOException, ServerException, ClientException {
        this.put(remoteFileName, source, mListener, false);
    }

    public void put(String remoteFileName, DataSource source, MarkerListener mListener, boolean append) throws IOException, ServerException, ClientException {
        TransferState state = this.actualPut(remoteFileName, source, mListener, append);
        this.transferWait(state);
    }

    public TransferState asynchPut(String remoteFileName, DataSource source, MarkerListener mListener) throws IOException, ServerException, ClientException {
        return this.actualPut(remoteFileName, source, mListener, false);
    }

    protected TransferState actualPut(String remoteFileName, DataSource source, MarkerListener mListener, boolean append) throws IOException, ServerException, ClientException {
        this.checkTransferParams();
        this.localServer.retrieve(source);
        if (append) {
            this.controlChannel.write(new Command("APPE", remoteFileName));
        } else {
            this.controlChannel.write(new Command("STOR", remoteFileName));
        }
        return this.transferStart(this.localServer.getControlChannel(), mListener);
    }

    public void transfer(String remoteSrcFile, FTPClient destination, String remoteDstFile, boolean append, MarkerListener mListener) throws IOException, ServerException, ClientException {
        this.session.matches(destination.session);
        if (this.session.serverMode == -1) {
            HostPort hp = destination.setPassive();
            this.setActive(hp);
        }
        destination.controlChannel.write(new Command(append ? "APPE" : "STOR", remoteDstFile));
        this.controlChannel.write(new Command("RETR", remoteSrcFile));
        this.transferRun(destination.controlChannel, mListener);
    }

    protected void transferRun(BasicClientControlChannel other, MarkerListener mListener) throws IOException, ServerException, ClientException {
        logger.debug((Object)"transferRun()");
        TransferState transferState = this.transferBegin(other, mListener);
        this.transferWait(transferState);
    }

    protected TransferState transferBegin(BasicClientControlChannel other, MarkerListener mListener) {
        TransferState transferState = new TransferState(mListener);
        TransferMonitor ourMonitor = new TransferMonitor(this.controlChannel, transferState, mListener, this.session.maxWait, this.session.waitDelay, TransferMonitor.LOCAL);
        TransferMonitor otherMonitor = new TransferMonitor(other, transferState, mListener, this.session.maxWait, this.session.waitDelay, TransferMonitor.REMOTE);
        ourMonitor.setOther(otherMonitor);
        otherMonitor.setOther(ourMonitor);
        ourMonitor.start();
        otherMonitor.start();
        return transferState;
    }

    protected TransferState transferStart(BasicClientControlChannel other, MarkerListener mListener) throws IOException, ServerException, ClientException {
        TransferState transferState = this.transferBegin(other, mListener);
        logger.debug((Object)"wait for both transfer to start");
        transferState.waitForStart();
        logger.debug((Object)"transfer started");
        return transferState;
    }

    protected void transferWait(TransferState transferState) throws IOException, ServerException, ClientException {
        logger.debug((Object)"wait for both monitor threads to finish");
        transferState.waitForEnd();
        logger.debug((Object)"transfer finished");
    }

    public Reply quote(String command) throws IOException, ServerException {
        Command cmd = new Command(command);
        return this.doCommand(cmd);
    }

    public Reply site(String args) throws IOException, ServerException {
        Command cmd = new Command("SITE", args);
        return this.doCommand(cmd);
    }

    private Reply doCommand(Command cmd) throws IOException, ServerException {
        try {
            return this.controlChannel.execute(cmd);
        }
        catch (UnexpectedReplyCodeException urce) {
            throw ServerException.embedUnexpectedReplyCodeException(urce);
        }
        catch (FTPReplyParseException rpe) {
            throw ServerException.embedFTPReplyParseException(rpe);
        }
    }

    public long size(String filename) throws IOException, ServerException {
        return this.getSize(filename);
    }

    public Date lastModified(String filename) throws IOException, ServerException {
        return this.getLastModified(filename);
    }

    public void get(String remoteFileName, File localFile) throws IOException, ClientException, ServerException {
        DataSinkStream sink = new DataSinkStream(new FileOutputStream(localFile));
        this.get(remoteFileName, sink, null);
    }

    public void put(File localFile, String remoteFileName, boolean append) throws IOException, ServerException, ClientException {
        DataSourceStream source = new DataSourceStream(new FileInputStream(localFile));
        this.put(remoteFileName, source, null, append);
    }

    public void setPassiveMode(boolean passiveMode) throws IOException, ClientException, ServerException {
        if (passiveMode) {
            this.setPassive();
            this.setLocalActive();
        } else {
            this.setLocalPassive();
            this.setActive();
        }
    }

    public boolean isPassiveMode() {
        return this.session.serverMode == 1;
    }

    public boolean isActiveMode() {
        return this.session.serverMode == 2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

