/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.globus.ftp.Buffer;
import org.globus.ftp.DataSink;
import org.globus.ftp.DataSource;

public class FileRandomIO
implements DataSink,
DataSource {
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    protected int bufferSize;
    protected RandomAccessFile file;

    public FileRandomIO(RandomAccessFile file) {
        this(file, 16384);
    }

    public FileRandomIO(RandomAccessFile file, int bufferSize) {
        this.file = file;
        this.bufferSize = bufferSize;
    }

    public synchronized void write(Buffer buffer) throws IOException {
        long offset = buffer.getOffset();
        if (offset < 0L) {
            throw new IOException("Invalid offset: " + offset);
        }
        this.file.seek(offset);
        this.file.write(buffer.getBuffer(), 0, buffer.getLength());
    }

    public synchronized Buffer read() throws IOException {
        long offset = this.file.getFilePointer();
        byte[] buf = new byte[this.bufferSize];
        int read = this.file.read(buf);
        if (read == -1) {
            return null;
        }
        return new Buffer(buf, read, offset);
    }

    public void close() throws IOException {
        this.file.close();
    }
}

