/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.dc;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.globus.ftp.Buffer;
import org.globus.ftp.DataSink;
import org.globus.ftp.DataSource;
import org.globus.ftp.Session;
import org.globus.ftp.dc.AbstractDataChannel;
import org.globus.ftp.dc.DataChannelReader;
import org.globus.ftp.dc.DataChannelWriter;
import org.globus.ftp.dc.LocalReply;
import org.globus.ftp.dc.SocketBox;
import org.globus.ftp.dc.TransferContext;
import org.globus.ftp.vanilla.BasicServerControlChannel;
import org.globus.ftp.vanilla.FTPServerFacade;

public class SimpleDataChannel
extends AbstractDataChannel {
    protected static Logger logger = Logger.getLogger((String)(class$org$globus$ftp$dc$SimpleDataChannel == null ? (class$org$globus$ftp$dc$SimpleDataChannel = SimpleDataChannel.class$("org.globus.ftp.dc.SimpleDataChannel")) : class$org$globus$ftp$dc$SimpleDataChannel).getName());
    protected SocketBox socketBox;
    protected TransferThread transferThread;
    static /* synthetic */ Class class$org$globus$ftp$dc$SimpleDataChannel;

    public SimpleDataChannel(Session session, SocketBox socketBox) {
        super(session);
        if (socketBox == null) {
            throw new IllegalArgumentException("socketBox is null");
        }
        if (socketBox.getSocket() == null) {
            throw new IllegalArgumentException("socket is null");
        }
        if (session == null) {
            throw new IllegalArgumentException("session is null");
        }
        this.socketBox = socketBox;
    }

    public void close() throws IOException {
        if (this.transferThread != null) {
            this.transferThread.interrupt();
            TransferThread transferThread = this.transferThread;
            synchronized (transferThread) {
                if (this.transferThread.isRunning()) {
                    try {
                        this.transferThread.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        if (this.socketBox.getSocket() != null) {
            this.socketBox.getSocket().close();
            this.socketBox.setSocket(null);
        }
    }

    public void startTransfer(DataSink sink, BasicServerControlChannel localControlChannel, TransferContext context) throws Exception {
        this.transferThread = new TransferSinkThread(this.socketBox, sink, localControlChannel, context);
        this.transferThread.start();
    }

    public void startTransfer(DataSource source, BasicServerControlChannel localControlChannel, TransferContext context) throws Exception {
        this.transferThread = new TransferSourceThread(this.socketBox, source, localControlChannel, context);
        this.transferThread.start();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class TransferSinkThread
    extends TransferThread {
        private DataChannelReader reader;
        private DataSink sink;
        private BasicServerControlChannel localControlChannel;
        private TransferContext context;
        private boolean running = false;
        private SocketBox socketBox;

        public TransferSinkThread(SocketBox socketBox, DataSink sink, BasicServerControlChannel localControlChannel, TransferContext context) throws Exception {
            this.socketBox = socketBox;
            this.sink = sink;
            this.localControlChannel = localControlChannel;
            this.context = context;
            this.reader = SimpleDataChannel.this.getDataChannelSource(context);
            this.reader.setDataStream(socketBox.getSocket().getInputStream());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                boolean error;
                block12: {
                    this.running = true;
                    error = false;
                    logger.debug((Object)"TransferSinkThread executing");
                    if (this.localControlChannel.getReplyCount() == 0) {
                        this.localControlChannel.write(new LocalReply(125));
                        logger.debug((Object)"wrote first reply");
                    }
                    try {
                        try {
                            this.copy();
                        }
                        catch (Exception e) {
                            error = true;
                            FTPServerFacade.exceptionToControlChannel(e, "exception during TransferSinkThread", this.localControlChannel);
                            Object var4_4 = null;
                            this.reader.close();
                            this.socketBox.setSocket(null);
                            if (this.context.readyToQuit()) {
                                this.sink.close();
                            }
                            break block12;
                        }
                        Object var4_3 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        this.reader.close();
                        this.socketBox.setSocket(null);
                        if (!this.context.readyToQuit()) throw throwable;
                        this.sink.close();
                        throw throwable;
                    }
                    this.reader.close();
                    this.socketBox.setSocket(null);
                    if (this.context.readyToQuit()) {
                        this.sink.close();
                    }
                }
                if (!error && this.context.readyToQuit()) {
                    this.localControlChannel.write(new LocalReply(226));
                }
                TransferSinkThread transferSinkThread = this;
                synchronized (transferSinkThread) {
                    this.running = false;
                    this.notify();
                    return;
                }
            }
            catch (Exception e) {
                FTPServerFacade.cannotPropagateError(e);
            }
        }

        public boolean isRunning() {
            return this.running;
        }

        /*
         * WARNING - void declaration
         */
        protected void copy() throws Exception {
            Buffer buf;
            long transferred = 0L;
            while ((buf = this.reader.read()) != null) {
                void var1_2;
                transferred += (long)var1_2.getLength();
                this.sink.write((Buffer)var1_2);
            }
            logger.debug((Object)("finished reading data; transferred " + transferred + "bytes"));
        }
    }

    class TransferSourceThread
    extends TransferThread {
        protected boolean running = false;
        private DataChannelWriter writer;
        private DataSource source;
        private BasicServerControlChannel localControlChannel;
        private TransferContext context;
        private SocketBox socketBox = null;

        public TransferSourceThread(SocketBox socketBox, DataSource source, BasicServerControlChannel localControlChannel, TransferContext context) throws Exception {
            this.socketBox = socketBox;
            this.source = source;
            this.localControlChannel = localControlChannel;
            this.context = context;
            this.writer = SimpleDataChannel.this.getDataChannelSink(context);
            this.writer.setDataStream(socketBox.getSocket().getOutputStream());
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                boolean error;
                block15: {
                    this.running = true;
                    long transferred = 0L;
                    error = false;
                    logger.debug((Object)"TransferSourceThread executing");
                    if (this.localControlChannel.getReplyCount() == 0) {
                        this.localControlChannel.write(new LocalReply(125));
                    }
                    try {
                        try {
                            while (true) {
                                void var1_3;
                                Buffer buf;
                                if ((buf = this.source.read()) == null) {
                                    logger.debug((Object)("finished reading data; transferred " + transferred + " bytes"));
                                    break;
                                }
                                transferred += (long)var1_3.getLength();
                                this.writer.write((Buffer)var1_3);
                            }
                        }
                        catch (Exception e) {
                            error = true;
                            FTPServerFacade.exceptionToControlChannel(e, "exception during TransferSourceThread", this.localControlChannel);
                            Object var7_6 = null;
                            this.writer.close();
                            this.socketBox.setSocket(null);
                            if (this.context.readyToQuit()) {
                                this.source.close();
                            }
                            break block15;
                        }
                        Object var7_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        this.writer.close();
                        this.socketBox.setSocket(null);
                        if (!this.context.readyToQuit()) throw throwable;
                        this.source.close();
                        throw throwable;
                    }
                    this.writer.close();
                    this.socketBox.setSocket(null);
                    if (this.context.readyToQuit()) {
                        this.source.close();
                    }
                }
                if (!error && this.context.readyToQuit()) {
                    this.localControlChannel.write(new LocalReply(226));
                }
                TransferSourceThread transferSourceThread = this;
                synchronized (transferSourceThread) {
                    this.running = false;
                    this.notify();
                    return;
                }
            }
            catch (Exception e) {
                FTPServerFacade.cannotPropagateError(e);
            }
        }

        public boolean isRunning() {
            return this.running;
        }
    }

    abstract class TransferThread
    extends Thread {
        TransferThread() {
        }

        public abstract boolean isRunning();
    }
}

