/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gram;

import org.globus.gram.GramJob;
import org.globus.gram.GramJobListener;
import org.globus.gram.JobRun;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.util.deactivator.Deactivator;
import org.ietf.jgss.GSSCredential;

public class MultiUserGramTest
implements GramJobListener {
    public void statusChanged(GramJob job) {
        String subject = "unknown";
        try {
            subject = job.getCredentials().getName().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("Job status change \n    ID     : " + job.getIDAsString() + "\n" + "    Status : " + job.getStatusAsString() + "\n" + "   Subject : " + subject);
    }

    private static GramJob createJob(GSSCredential proxy, GramJobListener listener, String dir, int id) {
        String subject = "unknown";
        try {
            subject = proxy.getName().toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        GramJob job = null;
        String env = "(environment=(CERT_SUBJECT \"" + subject + "\"))";
        job = new GramJob("&(directory=\"" + dir + "\")" + "(stdout=date.out." + id + ")" + env + "(executable=\"/bin/env\")");
        job.setCredentials(proxy);
        job.addListener(listener);
        return job;
    }

    private static GSSCredential load(String file) {
        try {
            GlobusCredential cred = new GlobusCredential(file);
            return new GlobusGSSCredentialImpl(cred, 0);
        }
        catch (Exception e) {
            System.err.println("Failed to load proxy: " + e.getMessage());
            System.exit(-1);
            return null;
        }
    }

    private static Thread submit(String contact, GramJob job) {
        Thread t = new Thread(new JobRun(contact, job));
        t.start();
        return t;
    }

    public static void main(String[] argv) {
        if (argv.length < 4) {
            System.out.println("Usage: java MultiUserGramTest contact dir proxy1 proxy2");
            System.exit(-1);
        }
        String contact = argv[0];
        String dir = argv[1];
        GSSCredential proxy1 = MultiUserGramTest.load(argv[2]);
        GSSCredential proxy2 = MultiUserGramTest.load(argv[3]);
        MultiUserGramTest test = new MultiUserGramTest();
        GramJob job1 = MultiUserGramTest.createJob(proxy1, test, dir, 0);
        GramJob job2 = MultiUserGramTest.createJob(proxy2, test, dir, 1);
        Thread t1 = MultiUserGramTest.submit(contact, job1);
        Thread t2 = MultiUserGramTest.submit(contact, job2);
        System.out.println("wait for job completion.");
        do {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while (job1.getStatus() != 8 && job1.getStatus() != 4 || job2.getStatus() != 8 && job2.getStatus() != 4);
        Deactivator.deactivateAll();
    }
}

