/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.util.StringTokenizer;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.globus.util.Base64;
import org.globus.util.PEMUtils;
import org.globus.util.Util;

public abstract class OpenSSLKey {
    public static final String HEADER = "-----BEGIN RSA PRIVATE KEY-----";
    private String keyAlg = null;
    private boolean isEncrypted = false;
    private byte[] encodedKey = null;
    private PrivateKey intKey = null;
    private IvParameterSpec iv = null;
    private Cipher cipher = null;
    private String encAlg = null;
    private byte[] keyData = null;

    public OpenSSLKey(InputStream is) throws IOException, GeneralSecurityException {
        InputStreamReader isr = new InputStreamReader(is);
        this.readPEM(isr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OpenSSLKey(String file) throws IOException, GeneralSecurityException {
        FileReader f = null;
        try {
            f = new FileReader(file);
            this.readPEM(f);
            Object var4_3 = null;
            if (f == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (f == null) throw throwable;
            f.close();
            throw throwable;
        }
        f.close();
    }

    public OpenSSLKey(PrivateKey key) {
        this.intKey = key;
        this.isEncrypted = false;
        this.keyData = this.getEncoded(key);
    }

    public OpenSSLKey(String algorithm, byte[] data) throws GeneralSecurityException {
        this.keyData = data;
        this.isEncrypted = false;
        this.intKey = this.getKey(algorithm, data);
    }

    private void readPEM(Reader rd) throws IOException, GeneralSecurityException {
        BufferedReader in = new BufferedReader(rd);
        StringBuffer sb = new StringBuffer();
        String next = null;
        while ((next = in.readLine()) != null) {
            if (next.indexOf("PRIVATE KEY") == -1) continue;
            this.keyAlg = this.getAlgorithm(next);
            break;
        }
        if (next == null) {
            throw new InvalidKeyException("PRIVATE KEY section not found.");
        }
        if (this.keyAlg == null) {
            throw new InvalidKeyException("Algorithm not supported.");
        }
        next = in.readLine();
        if (next.startsWith("Proc-Type: 4,ENCRYPTED")) {
            this.isEncrypted = true;
            this.checkEncrypted(in.readLine());
            in.readLine();
        } else {
            sb.append(next);
        }
        while ((next = in.readLine()) != null) {
            if (next.startsWith("-----END")) break;
            sb.append(next);
        }
        this.encodedKey = sb.toString().getBytes();
        if (!this.isEncrypted()) {
            this.keyData = Base64.decode(this.encodedKey);
            this.intKey = this.getKey(this.keyAlg, this.keyData);
        } else {
            this.keyData = null;
        }
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public void decrypt(String password) throws GeneralSecurityException, InvalidKeyException {
        this.decrypt(password.getBytes());
    }

    public void decrypt(byte[] password) throws GeneralSecurityException, InvalidKeyException {
        if (!this.isEncrypted()) {
            return;
        }
        byte[] enc = Base64.decode(this.encodedKey);
        SecretKeySpec key = this.getSecretKey(password, this.iv.getIV());
        this.cipher = this.getCipher(this.encAlg);
        this.cipher.init(2, (Key)key, this.iv);
        enc = this.cipher.doFinal(enc);
        this.intKey = this.getKey(this.keyAlg, enc);
        this.keyData = enc;
        this.isEncrypted = false;
    }

    public void encrypt(String password) throws GeneralSecurityException {
        this.encrypt(password.getBytes());
    }

    public void encrypt(byte[] password) throws GeneralSecurityException {
        if (this.isEncrypted()) {
            return;
        }
        if (this.iv == null) {
            this.iv = this.generateIV();
        }
        SecretKeySpec key = this.getSecretKey(password, this.iv.getIV());
        this.cipher = this.getCipher("DESede");
        this.cipher.init(1, (Key)key, this.iv);
        this.keyData = this.cipher.doFinal(this.getEncoded(this.intKey));
        this.isEncrypted = true;
    }

    public PrivateKey getPrivateKey() {
        return this.intKey;
    }

    public void writeTo(OutputStream output) throws IOException {
        if (this.keyData == null) {
            throw new IOException("No key info");
        }
        output.write(this.toPEM().getBytes());
    }

    public void writeTo(Writer w) throws IOException {
        if (this.keyData == null) {
            throw new IOException("No key info");
        }
        w.write(this.toPEM());
    }

    public void writeTo(String file) throws IOException {
        if (this.keyData == null) {
            throw new IOException("No key info");
        }
        PrintWriter p = null;
        try {
            p = new PrintWriter(new FileOutputStream(file));
            Util.setFilePermissions(file, 600);
            p.write(this.toPEM());
            Object var4_3 = null;
            if (p != null) {
                p.close();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (p != null) {
                p.close();
            }
            throw throwable;
        }
    }

    protected abstract byte[] getEncoded(PrivateKey var1);

    protected abstract PrivateKey getKey(String var1, byte[] var2) throws GeneralSecurityException;

    protected String getProvider() {
        return null;
    }

    private Cipher getCipher(String encAlg) throws GeneralSecurityException {
        if (this.cipher == null) {
            String provider = this.getProvider();
            this.cipher = provider == null ? Cipher.getInstance(encAlg + "/CBC/PKCS5Padding") : Cipher.getInstance(encAlg + "/CBC/PKCS5Padding", provider);
        }
        return this.cipher;
    }

    private String getAlgorithm(String line) {
        if (line.indexOf("RSA") != -1) {
            return "RSA";
        }
        if (line.indexOf("DSA") != -1) {
            return "DSA";
        }
        return null;
    }

    private void checkEncrypted(String line) {
        String keyInfo = line.substring(10);
        StringTokenizer tknz = new StringTokenizer(keyInfo, ",", false);
        if (tknz.nextToken().equals("DES-EDE3-CBC")) {
            this.encAlg = "DESede";
        }
        this.iv = this.getIV(tknz.nextToken());
    }

    private IvParameterSpec getIV(String s) {
        byte[] ivBytes = new byte[8];
        int j = 0;
        while (j < 8) {
            ivBytes[j] = (byte)Integer.parseInt(s.substring(j * 2, j * 2 + 2), 16);
            ++j;
        }
        return new IvParameterSpec(ivBytes);
    }

    private IvParameterSpec generateIV() {
        byte[] b = new byte[8];
        SecureRandom sr = new SecureRandom();
        sr.nextBytes(b);
        return new IvParameterSpec(b);
    }

    private SecretKeySpec getSecretKey(byte[] pwd, byte[] iv) throws NoSuchAlgorithmException {
        byte[] keyMat = new byte[24];
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(pwd);
        md.update(iv);
        byte[] data = md.digest();
        System.arraycopy(data, 0, keyMat, 0, 16);
        md.update(data);
        md.update(pwd);
        md.update(iv);
        data = md.digest();
        System.arraycopy(data, 0, keyMat, 16, 8);
        return new SecretKeySpec(keyMat, this.encAlg);
    }

    private String toPEM() {
        byte[] data = Base64.encode(this.keyData);
        String header = HEADER;
        if (this.isEncrypted()) {
            StringBuffer buf = new StringBuffer(header);
            buf.append(PEMUtils.lineSep);
            buf.append("Proc-Type: 4,ENCRYPTED");
            buf.append(PEMUtils.lineSep);
            buf.append("DEK-Info: DES-EDE3-CBC,").append(PEMUtils.toHex(this.iv.getIV()));
            buf.append(PEMUtils.lineSep);
            header = buf.toString();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            PEMUtils.writeBase64(out, header, data, "-----END RSA PRIVATE KEY-----");
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected error: " + e.getMessage());
        }
        return new String(out.toByteArray());
    }
}

