/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.bc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERString;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.globus.gsi.CertUtil;
import org.globus.gsi.TrustedCertificates;
import org.globus.gsi.bc.X509NameHelper;
import org.globus.gsi.proxy.ext.ProxyCertInfo;
import org.globus.gsi.proxy.ext.ProxyPolicy;

public class BouncyCastleUtil {
    public static byte[] toByteArray(DERObject obj) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DEROutputStream der = new DEROutputStream(bout);
        der.writeObject(obj);
        return bout.toByteArray();
    }

    public static DERObject toDERObject(byte[] data) throws IOException {
        ByteArrayInputStream inStream = new ByteArrayInputStream(data);
        DERInputStream derInputStream = new DERInputStream(inStream);
        return derInputStream.readObject();
    }

    public static DERObject duplicate(DERObject obj) throws IOException {
        return BouncyCastleUtil.toDERObject(BouncyCastleUtil.toByteArray(obj));
    }

    public static TBSCertificateStructure getTBSCertificateStructure(X509Certificate cert) throws CertificateEncodingException, IOException {
        DERObject obj = BouncyCastleUtil.toDERObject(cert.getTBSCertificate());
        return TBSCertificateStructure.getInstance(obj);
    }

    public static DERObject getExtensionObject(X509Extension ext) throws IOException {
        return BouncyCastleUtil.toDERObject(ext.getValue().getOctets());
    }

    public static int getCertificateType(X509Certificate cert, TrustedCertificates trustedCerts) throws CertificateException {
        try {
            return BouncyCastleUtil.getCertificateType(BouncyCastleUtil.getTBSCertificateStructure(cert), trustedCerts);
        }
        catch (IOException e) {
            throw new CertificateException(e.getMessage());
        }
    }

    public static int getCertificateType(X509Certificate cert) throws CertificateException {
        try {
            return BouncyCastleUtil.getCertificateType(BouncyCastleUtil.getTBSCertificateStructure(cert));
        }
        catch (IOException e) {
            throw new CertificateException(e.getMessage());
        }
    }

    public static int getCertificateType(TBSCertificateStructure crt, TrustedCertificates trustedCerts) throws CertificateException, IOException {
        int type = BouncyCastleUtil.getCertificateType(crt);
        if (type == 3) {
            if (trustedCerts == null) {
                trustedCerts = TrustedCertificates.getDefaultTrustedCertificates();
            }
            if (trustedCerts != null && trustedCerts.getCertificate(crt.getSubject().toString()) != null) {
                type = 4;
            }
        }
        return type;
    }

    public static int getCertificateType(TBSCertificateStructure crt) throws CertificateException, IOException {
        BasicConstraints basicExt;
        X509Extensions extensions = crt.getExtensions();
        X509Extension ext = null;
        if (extensions != null && (ext = extensions.getExtension(X509Extensions.BasicConstraints)) != null && (basicExt = BouncyCastleUtil.getBasicConstraints(ext)).isCA()) {
            return 4;
        }
        int type = 3;
        X509Name subject = crt.getSubject();
        ASN1Set entry = X509NameHelper.getLastNameEntry(subject);
        ASN1Sequence ava = (ASN1Sequence)entry.getObjectAt(0);
        if (X509Name.CN.equals(ava.getObjectAt(0))) {
            String value = ((DERString)((Object)ava.getObjectAt(1))).getString();
            if (value.equalsIgnoreCase("proxy")) {
                type = 10;
            } else if (value.equalsIgnoreCase("limited proxy")) {
                type = 11;
            } else if (extensions != null && (ext = extensions.getExtension(ProxyCertInfo.OID)) != null) {
                if (ext.isCritical()) {
                    ProxyCertInfo proxyCertExt = BouncyCastleUtil.getProxyCertInfo(ext);
                    ProxyPolicy proxyPolicy = proxyCertExt.getProxyPolicy();
                    DERObjectIdentifier oid = proxyPolicy.getPolicyLanguage();
                    type = ProxyPolicy.IMPERSONATION.equals(oid) ? 14 : (ProxyPolicy.INDEPENDENT.equals(oid) ? 13 : (ProxyPolicy.LIMITED.equals(oid) ? 15 : 12));
                } else {
                    throw new CertificateException("ProxyCertInfo extension must be critical");
                }
            }
            if (CertUtil.isProxy(type)) {
                X509NameHelper iss = new X509NameHelper(crt.getIssuer());
                iss.add((ASN1Set)BouncyCastleUtil.duplicate(entry));
                X509Name issuer = iss.getAsName();
                if (!issuer.equals(subject)) {
                    throw new CertificateException("Issuer name + proxy CN entry is not equal to subject name");
                }
            }
        }
        return type;
    }

    public static boolean[] getKeyUsage(X509Extension ext) throws IOException {
        DERBitString bits = (DERBitString)BouncyCastleUtil.getExtensionObject(ext);
        byte[] bytes = bits.getBytes();
        int length = bytes.length * 8 - bits.getPadBits();
        boolean[] keyUsage = new boolean[length < 9 ? 9 : length];
        int i = 0;
        while (i != length) {
            keyUsage[i] = (bytes[i / 8] & 128 >>> i % 8) != 0;
            ++i;
        }
        return keyUsage;
    }

    public static BasicConstraints getBasicConstraints(X509Extension ext) throws IOException {
        DERObject obj = BouncyCastleUtil.getExtensionObject(ext);
        if (obj instanceof ASN1Sequence && ((ASN1Sequence)obj).size() <= 0) {
            return new BasicConstraints(false);
        }
        return BasicConstraints.getInstance(obj);
    }

    public static ProxyCertInfo getProxyCertInfo(X509Extension ext) throws IOException {
        return ProxyCertInfo.getInstance(BouncyCastleUtil.getExtensionObject(ext));
    }

    public static String getIdentity(X509Certificate cert) {
        if (cert == null) {
            return null;
        }
        return X509NameHelper.toString((X509Name)((Object)cert.getSubjectDN()));
    }

    public static String getIdentity(X509Certificate[] chain) throws CertificateException {
        return BouncyCastleUtil.getIdentity(BouncyCastleUtil.getIdentityCertificate(chain));
    }

    public static X509Certificate getIdentityCertificate(X509Certificate[] chain) throws CertificateException {
        if (chain == null) {
            throw new IllegalArgumentException("chain == null");
        }
        int i = 0;
        while (i < chain.length) {
            int certType = BouncyCastleUtil.getCertificateType(chain[i]);
            if (!CertUtil.isImpersonationProxy(certType)) {
                return chain[i];
            }
            ++i;
        }
        return null;
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
    }
}

