/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.gssapi.net.example;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.GlobusGSSManagerImpl;
import org.globus.gsi.gssapi.auth.Authorization;
import org.globus.gsi.gssapi.auth.HostAuthorization;
import org.globus.gsi.gssapi.auth.IdentityAuthorization;
import org.globus.gsi.gssapi.auth.SelfAuthorization;
import org.globus.gsi.gssapi.net.GssSocket;
import org.globus.gsi.gssapi.net.GssSocketFactory;
import org.globus.gsi.gssapi.net.example.GetOpts;
import org.gridforum.jgss.ExtendedGSSContext;
import org.ietf.jgss.GSSManager;

public class GssClient {
    private static final String helpMsg = "Where options are:\n -gss-mode mode\t\t\tmode is: 'ssl' or 'gsi' (default)\n -deleg-type type\t\ttype is: 'none', 'limited' (default), or 'full'\n -lifetime time\t\t\tLifetime of context. time is in seconds.\n -rejectLimitedProxy\t\tEnables checking for limited proxies (off by default)\n -anonymous\t\t\tDo not send certificates to the server\n -enable-conf\t\t\tEnables confidentiality (do encryption) (enabled by default)\n -disable-conf\t\t\tDisables confidentiality (no encryption)\n -auth auth\t\t\tIf auth is 'host' host authorization will be performed.\n           \t\t\tIf auth is 'self' self authorization will be performed.\n           \t\t\tOtherwise, identity authorization is performed.\n           \t\t\tAuthorization is not performed by default.\n -wrap-mode mode\t\tmode is: 'ssl' (default) or 'gsi'";

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        void var9_13;
        String usage = "Usage: java GssClient [options] host port";
        GetOpts opts = new GetOpts(usage, helpMsg);
        int pos = opts.parse(args);
        if (pos + 2 > args.length) {
            System.err.println(usage);
            return;
        }
        String host = args[pos];
        int port = Integer.parseInt(args[pos + 1]);
        GlobusGSSManagerImpl manager = new GlobusGSSManagerImpl();
        ExtendedGSSContext context = null;
        Socket s = null;
        SelfAuthorization selfAuthorization = SelfAuthorization.getInstance();
        Object targetName = null;
        if (opts.auth != null) {
            if (opts.auth.equals("host")) {
                HostAuthorization hostAuthorization = HostAuthorization.getInstance();
            } else if (opts.auth.equals("self")) {
                SelfAuthorization selfAuthorization2 = SelfAuthorization.getInstance();
            } else {
                IdentityAuthorization identityAuthorization = new IdentityAuthorization(opts.auth);
            }
        }
        context = (ExtendedGSSContext)((GSSManager)manager).createContext(null, GSSConstants.MECH_OID, null, opts.lifetime);
        context.requestCredDeleg(opts.deleg);
        context.requestConf(opts.conf);
        context.requestAnonymity(opts.anonymity);
        context.setOption(GSSConstants.GSS_MODE, opts.gsiMode ? GSIConstants.MODE_GSI : GSIConstants.MODE_SSL);
        if (opts.deleg) {
            context.setOption(GSSConstants.DELEGATION_TYPE, opts.limitedDeleg ? GSIConstants.DELEGATION_TYPE_LIMITED : GSIConstants.DELEGATION_TYPE_FULL);
        }
        context.setOption(GSSConstants.REJECT_LIMITED_PROXY, new Boolean(opts.rejectLimitedProxy));
        s = GssSocketFactory.getDefault().createSocket(host, port, context);
        ((GssSocket)s).setWrapMode(opts.wrapMode);
        ((GssSocket)s).setAuthorization((Authorization)var9_13);
        OutputStream out = s.getOutputStream();
        InputStream in = s.getInputStream();
        System.out.println("Context established.");
        System.out.println("Initiator : " + context.getSrcName());
        System.out.println("Acceptor  : " + context.getTargName());
        System.out.println("Lifetime  : " + context.getLifetime());
        System.out.println("Privacy   : " + context.getConfState());
        System.out.println("Anonymity : " + context.getAnonymityState());
        String msg = "POST ping/jobmanager HTTP/1.1\r\nHost: " + host + "\r\n" + "Content-Type: application/x-globus-gram\r\n" + "Content-Length: 0\r\n\r\n";
        byte[] tmp = msg.getBytes();
        out.write(tmp);
        out.flush();
        String line = null;
        BufferedReader r = new BufferedReader(new InputStreamReader(in));
        while ((line = r.readLine()) != null) {
            System.out.println(line);
        }
        Object var18_22 = null;
        if (s == null) return;
        try {
            s.close();
            return;
        }
        catch (Exception e2) {}
        return;
        {
            catch (Exception e) {
                e.printStackTrace();
                Object var18_23 = null;
                if (s == null) return;
                try {
                    s.close();
                    return;
                }
                catch (Exception e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var18_24 = null;
            if (s == null) throw throwable;
            try {
                s.close();
                throw throwable;
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw throwable;
        }
    }
}

